/***************************************************************************
                          cl_login.cpp  -  description
                             -------------------
    begin                : Sat Jan 04 2003
    copyright            : (C) 2003 by Reto Loepfe & Thomas Gemperli
    email                : loege@gemperli.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cl_login.h"

// Default Konstruktor
cl_login::cl_login()
{
	// Pfad zu den Datenfiles feststellen und in private Variable sichern.
	if(getenv("DOCUMENT_ROOT"))
	{
		m_loginFile = getenv("DOCUMENT_ROOT");
		m_loginFile.append("/loege/data/login.txt");
		m_tmploginFile = getenv("DOCUMENT_ROOT");
		m_tmploginFile.append("/loege/data/tmplogin.txt");
		m_filePath = getenv("DOCUMENT_ROOT");
		m_filePath.append("/loege/data/");
	}
}

// Default Destruktor. Der Vollstaendigkeit halber.
cl_login::~cl_login()
{
}

//User erstellen
bool cl_login::setUser(const string& Username, const string& Password)
{
	m_Username = Username;
	m_Password = Password;

	bool user = false;
	bool success = false;

	ifstream inFile(m_loginFile.c_str());

	// Sicherstellen dass Quellfile offen ist
	if(inFile.is_open())
	{
		string text;

		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,text,';'); //String bis zum ";" einlesen (User)

			if(m_Username == text && text != "")
			{
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen

				user = true;
			}
			else
			{
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen
			}
		}
		while(!inFile.eof());
	}

	// Wenn der User noch nicht existiert
	if(user != true)
	{
		//Datei erzeugen und ffnen
		ofstream outFile(m_loginFile.c_str(),ios::app);
		//Ist die Datei wirklich offen?
		if(outFile.is_open())
		{
			//Userangaben ins File schreiben
			outFile << m_Username << ";" << m_Password << ";\n";
		}
		//Datei schliessen
		outFile.close();
		success = true;
	}
	else
	{
		success = false;
	}
	inFile.close();
	
	return success;
}


//Berechtigung abfragen
bool cl_login::getLogin(const string& Username, const string& Password)
{
	// Username und Password bergeben
	m_Username = Username;
	m_Password = Password;

	bool login = false;
	

	ifstream inFile(m_loginFile.c_str());

	if(inFile.is_open())
	{
		string text;
		
		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,text,';'); //String bis zum ";" einlesen (User)

			if(m_Username == text && text != "")
			{
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)

				if(m_Password == text)
				{
					login = true;
				}
			}
			else
			{


				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen 
			}
		}
		while(!inFile.eof());
	}
	inFile.close();
	
	//Rckgabewert, true -> User gefunden, false -> User nicht gefunden
	return login;

}

//User lschen
bool cl_login::delUser(const string& Username, const string& Password)
{	
	// Username und Password bergeben
	m_Username = Username;
	m_Password = Password;

	bool del = false;

	ifstream inFile(m_loginFile.c_str());
	ofstream outFile(m_tmploginFile.c_str());
	

	if(inFile.is_open())
	{
		string text;

		//Zeilen auslesen und scheiben bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,text,';'); //String bis zum ";" einlesen (User)

			// Alle User ausser dem zu Loeschenden in neues File schreiben.
			if(m_Username != text && outFile.is_open() && text != "")
			{
				outFile << text << ";"; //Userangaben ins File schreiben
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				outFile << text << ";\n"; //Userangaben ins File schreiben
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen
			}
			else
			{
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen
				del = true;
			}
		}
		while(!inFile.eof());
	}
	inFile.close(); //Datei schliessen
	outFile.close(); //Datei schliessen

	// File zurueckschreiben
	ifstream inFileNew(m_tmploginFile.c_str());
	ofstream outFileNew(m_loginFile.c_str());

	if(inFileNew.is_open())
	{
		string text;

		getline(inFileNew,text,';'); //String bis zum ";" einlesen (User)

		//Zeilen auslesen und scheiben bis das Ende des Files erreicht ist.
		do
		{
			if(outFileNew.is_open() && text != "")
			{
				outFileNew << text << ";"; //Daten ins File schreiben
				getline(inFileNew,text,';'); //String bis zum ";" einlesen (User)
			}
		}
		while(!inFileNew.eof());

		outFileNew << endl;
	}
	inFileNew.close(); //Datei schliessen
	outFileNew.close(); //Datei schliessen

	// Userdaten file leoschen
	m_filePath.append(m_Username);
	m_filePath.append(".dat");
 	remove(m_filePath.c_str());
	
	// Tmpfile loeschen
	remove(m_tmploginFile.c_str());
	
	return del;
}

bool cl_login::changePw(const string& Username, const string& Password, const string& newPassword)
{
	// Username und Password bergeben
	m_Username = Username;
	m_Password = Password;
	m_newPassword = newPassword;

	bool change = false;

	ifstream inFile(m_loginFile.c_str());
	ofstream outFile(m_tmploginFile.c_str());


	if(inFile.is_open())
	{
		string text;

		//Zeilen auslesen und scheiben bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,text,';'); //String bis zum ";" einlesen (User)

			// Alle User ausser dem mit der Passwort Aenderung in neues File schreiben.
			if(m_Username != text && outFile.is_open() && text != "")
			{
				outFile << text << ";"; //Userangaben ins File schreiben
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				outFile << text << ";\n"; //Userangaben ins File schreiben
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen
			}
			else
			{
				getline(inFile,text,';'); //String bis zum ";" einlesen (Password)
				getline(inFile,text,'\n'); //String bis zur naechsten newline einlesen
				change = true;
			}
		}
		while(!inFile.eof());
	}
	inFile.close(); //Datei schliessen
	outFile.close(); //Datei schliessen

	// File zurueckschreiben
	ifstream inFileNew(m_tmploginFile.c_str());
	ofstream outFileNew(m_loginFile.c_str());

	if(inFileNew.is_open())
	{
		string text;

		getline(inFileNew,text,';'); //String bis zum ";" einlesen (User)

		//Zeilen auslesen und scheiben bis das Ende des Files erreicht ist.
		do
		{
			if(outFileNew.is_open() && text != "")
			{
				outFileNew << text << ";"; //Daten ins File schreiben
				getline(inFileNew,text,';'); //String bis zum ";" einlesen (User)
			}
		}
		while(!inFileNew.eof());

		// User mit dem neuen Passwort wieder ins File zurueckschreiben
		outFileNew << endl;
		outFileNew << m_Username << ";";
		getline(inFileNew,text,';');
		outFileNew << m_newPassword << ";";
		getline(inFileNew,text,';');

		outFileNew << endl;
	}
	inFileNew.close(); //Datei schliessen
	outFileNew.close(); //Datei schliessen

	// Tmpfile loeschen
	remove(m_tmploginFile.c_str());
	
	return change;
}

