/***************************************************************************
                          cl_userfile.cpp  -  description
                             -------------------
    begin                : Mon Jan 21 2003
    copyright            : (C) 2003 by Reto Loepfe & Thomas Gemperli
    email                : loege@gemperli.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <fstream>
#include <iostream>
#include <string>
#include <map>

#include "cl_userfile.h"

using namespace std;

typedef multimap<int, string> MULTI_MAP;
typedef MULTI_MAP::iterator ITERATOR;


cl_userfile::cl_userfile()
{
	if(getenv("DOCUMENT_ROOT"))
	{
		m_Path = getenv("DOCUMENT_ROOT");
		m_Path.append("/loege/data/");
	}
}

cl_userfile::~cl_userfile()
{
}


//Setzt das Flag eines Wortes auf true oder false.
//Das ganze Userfile kann geresetet werden, indem man der Methode
//einen String (str_resAll) bergibt
string cl_userfile::setLearnFlag(const string& str_language, 
						const string& str_username, 
						const string& str_Word,
						const string& str_Flag,
						const string& str_resAll)
{
	string str_Path(m_Path);
	m_username = str_username;
	m_language = str_language;

	str_Path.append(m_username);
	
	string str_tmpPath = str_Path;
	str_tmpPath.append(".tmp");
	str_Path.append(".dat");

	m_resAll = str_resAll;
	m_Word = str_Word;
	string m_tmpWord;

	ifstream inFile(str_Path.c_str());
	ofstream outFile(str_tmpPath.c_str());
	
	if(inFile.is_open())
	{
		//Zeilen auslesen und schreiben bis das Ende des Files erreicht ist.
		do
		{
			//String bis zum ";" einlesen (ID)
			getline(inFile,m_ID,':');
			getline(inFile,m_unit,':');
			getline(inFile,m_DWord,':');
			getline(inFile,m_EWord,':');
			getline(inFile,m_Flag,'\n');

				if(m_language == "DE_EN")
				{
					m_tmpWord = m_DWord;
				}
			
				else
				{
				m_tmpWord = m_EWord;
				}


			if(m_ID != "")
			{
				outFile << m_ID << ":";		//Userangaben ins File schreiben
				outFile << m_unit << ":";	//Userangaben ins File schreiben
				outFile << m_DWord << ":";	//Userangaben ins File schreiben
				outFile << m_EWord << ":";	//Userangaben ins File schreiben

				if(m_resAll != "")
				{
					//Setz alle Flags im gesammten Userfile auf false (RESET)
					outFile << "false\n" << "\n";
				}
				else
				{
					//Wenn Flag == str_Flag, muss das Flag gesetzt werden ganze file false
					if(outFile.is_open() && m_Flag != str_Flag && m_Word == m_tmpWord)

					{
						outFile << str_Flag << "\n";//Userangaben ins File schreiben
					}
					else
					{
						outFile << m_Flag << "\n";	//Userangaben ins File schreiben
					}
				}
			}

		}
		while(!inFile.eof());
	}
	inFile.close(); //Datei schliessen
	outFile.close(); //Datei schliessen

	// File zurueckschreiben
	ifstream inFileNew(str_tmpPath.c_str());
	ofstream outFileNew(str_Path.c_str());

	if(inFileNew.is_open())
	{
		string text;

		//Zeilen auslesen und scheiben bis das Ende des Files erreicht ist.
		do
		{
			getline(inFileNew,text,'\n'); //String bis zum ";" einlesen (User)
			if(outFileNew.is_open() && text != "")
			{
				outFileNew << text << "\n"; //Daten ins File schreiben
			}
		}
		while(!inFileNew.eof());

	}
	inFileNew.close(); //Datei schliessen
	outFileNew.close(); //Datei schliessen

	remove(str_tmpPath.c_str());
	return m_Flag;

}


//Zeile aus dem Userfile lschen
bool cl_userfile::delWord(const string& str_language, 
						const string& str_username, 
						const string str_Word)
{
	m_language = str_language;
	m_username = str_username;
	m_Word = str_Word;
	m_ok = false;

	string str_Path(m_Path);
	str_Path.append(m_username);
	str_Path.append(".dat");

	string m_tmpWord;

	if(m_language == "DE_EN")
	{
		m_tmpWord = m_DWord;
	}
	else
	{
		m_tmpWord = m_EWord;
	}

	ifstream inFile(str_Path.c_str());

	ofstream outFile(str_Path.c_str());
	if(inFile.is_open())
	{
		//Zeilen auslesen und schreiben bis das Ende des Files erreicht ist.
		do
		{
			//String bis zum ";" einlesen (ID)
			getline(inFile,m_ID,':');
			getline(inFile,m_unit,':');
			getline(inFile,m_DWord,':');
			getline(inFile,m_EWord,':');
			getline(inFile,m_Flag,'\n');

			if(m_ID != "")
			{
				outFile << m_ID << ":";		//Userangaben ins File schreiben
				outFile << m_unit << ":";	//Userangaben ins File schreiben
				outFile << m_DWord << ":";	//Userangaben ins File schreiben
				outFile << m_EWord << ":";	//Userangaben ins File schreiben

				if(m_resAll != "")
				{
					//Setz alle Flags im gesammten Userfile auf false (RESET)
					outFile << "false\n" << "\n";
				}
				else
				{
					string str_Flag;
					//Wenn Flag == str_Flag, muss das Flag gesetzt werden ganze file false
					if(outFile.is_open() && m_Flag != str_Flag && m_Word == m_tmpWord)
					{
						outFile << str_Flag << "\n";//Userangaben ins File schreiben
					}
					else
					{
						outFile << m_Flag << "\n";	//Userangaben ins File schreiben
					}
				}
			}

		}
		while(!inFile.eof());
	}
	inFile.close(); //Datei schliessen
	outFile.close(); //Datei schliessen

	// File zurueckschreiben
	ifstream inFileNew(str_Path.c_str());
	ofstream outFileNew(str_Path.c_str());

	if(inFileNew.is_open())
	{
		string text;

		//Zeilen auslesen und scheiben bis das Ende des Files erreicht ist.
		do
		{
			getline(inFileNew,text,'\n'); //String bis zum ";" einlesen (User)
			if(outFileNew.is_open() && text != "")
			{
				outFileNew << text << "\n"; //Daten ins File schreiben
			}
		}
		while(!inFileNew.eof());

	}
	inFileNew.close(); //Datei schliessen
	outFileNew.close(); //Datei schliessen

	return m_ok;
}

//Ermittelt die Anzahl verschiedener Units in einem Userfile
int cl_userfile::anzUnit(const string& str_username) 
{
	string str_Path(m_Path);
	m_username = str_username;
	str_Path.append(m_username);
	str_Path.append(".dat");

	MULTI_MAP m;
	int counter = 0;

	ifstream inFile(str_Path.c_str());
	if(inFile.is_open())
	{
		//Zeilen auslesen und schreiben bis das Ende des Files erreicht ist.
		do
		{
			//String bis zum ";" einlesen (ID)
			getline(inFile,m_ID,':');
			getline(inFile,m_unit,':');
			getline(inFile,m_Dummy,'\n');
			cout << m_unit << endl;

			//erster Durchgang
			if(counter == 0)
			{
				m.insert(pair<int, string>(counter, m_unit));
				counter++;
			}

		}
		while(!inFile.eof());
	}
	inFile.close(); //Datei schliessen

	m_anzUnit = 4;

	return m_anzUnit;
}


// Userfile ausgeben
bool cl_userfile::showFile(const string& str_username)
{
	m_username = str_username;
	m_ok = false;

	string str_Path(m_Path);
	str_Path.append(m_username);
	str_Path.append(".dat");

	ifstream inFile(str_Path.c_str());

	if(inFile.is_open())
	{

    // fuer alle Lektionen durchackern
    for(int i = 1; i < 100; ++i)
    {
      // inFile wieder auf den Anfang des Files "pointen"
      ifstream inFile(str_Path.c_str());

		  //Zeilen auslesen bis das Ende des Files erreicht ist.
		  do
		  {
          // int i in string umwandeln, damit i mit string m_unit verglichen werden kann
      		string g;
      		stringstream einStream;
     		  einStream << i;
       		einStream >> g;

  			  //String bis zum ":" einlesen (ID)
    			getline(inFile,m_ID,':');
    			getline(inFile,m_unit,':');
    			getline(inFile,m_DWord,':');
    			getline(inFile,m_EWord,':');
    			getline(inFile,m_Flag,'\n');

          //Ausgeben
    			if(m_ID != "" && m_unit == g)         // && m_ID == g
    			{
    				cout << "<tr><td>" << m_unit << "</td>" << endl;
    				cout << "<td>" << m_DWord << "</td>" << endl;
    				cout << "<td>" << m_EWord << "</td>" << endl;
            if(m_Flag == "true")
            {
    				  cout << "<td>sitzt</td></tr>" << endl;
            }
            else
            {
              cout << "<td>sitzt nicht</td></tr>" << endl;
            }
   	  		}
    	 }
    	 while(!inFile.eof());
    }
    m_ok = true;
	}
  else
  {
     cout << "<tr><td><p class=\"error\">Wortliste existiert nicht.</p></td></tr>" << endl;
  }
	inFile.close(); //Datei schliessen

	return m_ok;
}
