/***************************************************************************
                          cl_search.cpp  -  description
                             -------------------
    begin                : Mon Jan 21 2003
    copyright            : (C) 2003 by Reto Loepfe & Thomas Gemperli
    email                : loege@gemperli.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <fstream>
#include <iostream>
#include <string>


#include "cl_search.h"

using namespace std;

cl_search::cl_search()
{
	if(getenv("DOCUMENT_ROOT"))
	{
		m_DePath = getenv("DOCUMENT_ROOT");
		m_DePath.append("/loege/data/DE_EN/");
		m_EnPath = getenv("DOCUMENT_ROOT");
		m_EnPath.append("/loege/data/EN_DE/");
	}

	m_DeLen = 0;
	m_EnLen = 0;
	m_mtDeLen = 0;
	m_mtEnLen = 0;
	m_anz_counter = 0;
	m_Word = "";
	m_EnWord = "";  	//Variable fr das Englische Wort
	m_DeWord = "";		//Variable fr das Deutsche Wort
	m_EnText = "";		//Variable fr englisches Wort aus den Masterfiles
	m_DeText = "";		//Variable fr deutsches Wort aus den Masterfiles
	m_dummy = "";		//Dummyvariable, wenn Deutsches Wort nicht gefunden wurde
	m_found_flag = false;	//Flag welches auf True gesetzt wird, wenn das Wort im Masterfile gefunden wurde

}


cl_search::~cl_search()
{
}


//Anhand des ersten Buchstaben Pfad und Name der bersetzungstabelle ermitteln
string cl_search::getPathName(const string& str_Word, const string& str_learnTyp)
{
	m_Word = str_Word;
	int i_fChar = m_Word[0];
	string str_fName;

	if(str_learnTyp == "DE_EN")
	{
		m_Path = m_DePath;
	}
	else
	{
		m_Path = m_EnPath;
	}

	switch (i_fChar)
	{
	case 'A':
		str_fName = "m_tabA.dat";
		break;
	case 'a':
		str_fName = "m_tabA.dat";
		break;
	case 'B':
		str_fName = "m_tabB.dat";
		break;
	case 'b':
		str_fName = "m_tabB.dat";
		break;
	case 'C':
		str_fName = "m_tabC.dat";
		break;
	case 'c':
		str_fName = "m_tabC.dat";
		break;
	case 'D':
		str_fName = "m_tabD.dat";
		break;
	case 'd':
		str_fName = "m_tabD.dat";
		break;
	case 'E':
		str_fName = "m_tabE.dat";
		break;
	case 'e':
		str_fName = "m_tabE.dat";
		break;
	case 'F':
		str_fName = "m_tabF.dat";
		break;
	case 'f':
		str_fName = "m_tabF.dat";
		break;
	case 'G':
		str_fName = "m_tabG.dat";
		break;
	case 'g':
		str_fName = "m_tabG.dat";
		break;
	case 'H':
		str_fName = "m_tabH.dat";
		break;
	case 'h':
		str_fName = "m_tabH.dat";
		break;
	case 'i':
		str_fName = "m_tabI.dat";
		break;
	case 'I':
		str_fName = "m_tabI.dat";
		break;
	case 'J':
		str_fName = "m_tabJ.dat";
		break;
	case 'j':
		str_fName = "m_tabJ.dat";
		break;
	case 'K':
		str_fName = "m_tabK.dat";
		break;
	case 'k':
		str_fName = "m_tabK.dat";
		break;
	case 'L':
		str_fName = "m_tabL.dat";
		break;
	case 'l':
		str_fName = "m_tabL.dat";
		break;
	case 'M':
		str_fName = "m_tabM.dat";
		break;
	case 'm':
		str_fName = "m_tabM.dat";
		break;
	case 'N':
		str_fName = "m_tabN.dat";
		break;
	case 'n':
		str_fName = "m_tabN.dat";
		break;
	case 'O':
		str_fName = "m_tabO.dat";
		break;
	case 'o':
		str_fName = "m_tabO.dat";
		break;
	case 'P':
		str_fName = "m_tabP.dat";
		break;
	case 'p':
		str_fName = "m_tabP.dat";
		break;
	case 'Q':
		str_fName = "m_tabQ.dat";
		break;
	case 'q':
		str_fName = "m_tabQ.dat";
		break;
	case 'R':
		str_fName = "m_tabR.dat";
		break;
	case 'r':
		str_fName = "m_tabR.dat";
		break;
	case 'S':
		str_fName = "m_tabS.dat";
		break;
	case 's':
		str_fName = "m_tabS.dat";
		break;
	case 'T':
		str_fName = "m_tabT.dat";
		break;
	case 't':
		str_fName = "m_tabT.dat";
		break;
	case 'U':
		str_fName = "m_tabU.dat";
		break;
	case 'u':
		str_fName = "m_tabU.dat";
		break;
	case 'V':
		str_fName = "m_tabV.dat";
		break;
	case 'v':
		str_fName = "m_tabV.dat";
		break;
	case 'W':
		str_fName = "m_tabW.dat";
		break;
	case 'w':
		str_fName = "m_tabW.dat";
		break;
	case 'X':
		str_fName = "m_tabX.dat";
		break;
	case 'x':
		str_fName = "m_tabX.dat";
		break;
	case 'Y':
		str_fName = "m_tabY.dat";
		break;
	case 'y':
		str_fName = "m_tabY.dat";
		break;
	case 'Z':
		str_fName = "m_tabZ.dat";
		break;
	case 'z':
		str_fName = "m_tabZ.dat";
		break;
	default:
		str_fName = "m_tabOth.dat";
		break;
	}

	m_Path.append(str_fName);

	return m_Path;
}


//Englisches Wort suchen
string cl_search::getEnWord(const string& str_DeWord)
{
	m_DeWord.erase();
	m_EnWord.erase();
	m_anz_counter = 0;
	//bergebenes Wort in Variable m_DeWord abspeichern
	m_DeWord = str_DeWord;
	//lnge des bergebenen Wortes ermitteln
	m_DeLen = m_DeWord.length();

	string str_learnTyp = "DE_EN";
	getPathName(m_DeWord,str_learnTyp);

	ifstream inFile(m_Path.c_str());

	if(inFile.is_open())
	{
		bool ok_flag = false;

		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			m_count = 0;			//Zhlvariable


			getline(inFile,m_DeText,':');
			

			m_mtDeLen = m_DeText.length();

			if( ( m_DeLen <= m_mtDeLen))
			{
				//Schleife mit der Anzahl der lnge des eingegebenen Wortes (deutsch)
				//Kontrolle ob Wort identisch mit dem Suchbegriff!
				for(int i = 0; i < m_mtDeLen; ++i)
				{

					ok_flag = true;

					if((m_DeWord[i] == m_DeText[i]))
					{
						//Buchstabe identisch
						m_count++;
					}
					else
					{
						ok_flag = false;
						i = m_mtDeLen;
					}
				}
			}


			if(ok_flag)
			{
				//String bis zum "\n" einlesen, d.h. englische Seite einlesen
				getline(inFile,m_EnText,'\n');  
				if(m_anz_counter > 0)
				{
					m_EnWord.append ("<br>");
					m_EnWord.append (m_EnText);
				}
				else
				{
					m_EnWord.append (m_EnText);
				}
				m_found_flag = true;
				m_anz_counter++;
				ok_flag = false;
			}
			else
			{
				//Dummy-Variable abfllen
				//String bis zum "\n" einlesen, d.h. englische Seite einlesen
				getline(inFile,m_dummy,'\n'); 
			}
		}
		while(!inFile.eof());

		//File wieder schliessen
		inFile.close();

	}

	//Kontrolle, ob im Masterfile das deutsche Wort gefunden wurde
	if(!m_found_flag)
	{
		m_EnWord = "Suchwort nicht gefunden";
	}
	//Rckgabewert, das gefundene Wort wird zurckgegeben
	return m_EnWord;

}

//Deutsches Wort suchen
string cl_search::getDeWord(const string& str_EnWord)
{
	//bergebenes Wort in Variable m_DeWord abspeichern

	m_DeWord.erase();
	m_EnWord.erase();
	m_anz_counter = 0;
	m_EnWord = str_EnWord;
	m_EnLen = m_EnWord.length();
	string str_learnTyp = "EN_DE";
	getPathName(m_EnWord,str_learnTyp);

	ifstream inFile(m_Path.c_str());

	if(inFile.is_open())
	{
		bool ok_flag = false;

		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			//Zhlvariable
			m_count = 0;

			getline(inFile,m_DeText,':');
			getline(inFile,m_EnText,'\n');

			m_mtEnLen = m_EnText.length();

			if( ( m_EnLen <= m_mtEnLen)) 
			{
				//Schleife mit der Anzahl der lnge des eingegebenen Wortes (deutsch)
				//Kontrolle ob Wort identisch mit dem Suchbegriff!
				for(int i = 0; i < m_mtEnLen; ++i)
				{

					ok_flag = true;

					if((m_EnWord[i] == m_EnText[i]))
					{
						//Buchstabe identisch
						m_count++;
					}
					else
					{
						ok_flag = false;
						i = m_mtEnLen;
					}
				}
			}

			if(ok_flag)
			{
				if(m_anz_counter > 0)
				{
					m_DeWord.append ("<br>");
					m_DeWord.append (m_DeText);
				}
				else
				{
					m_DeWord.append (m_DeText);
				}
				m_found_flag = true;
				m_anz_counter++;
				ok_flag = false;
			}
		}
		while(!inFile.eof());

		//File wieder schliessen
		inFile.close();

	}

	//Kontrolle, ob im Masterfile das deutsche Wort gefunden wurde
	if(!m_found_flag)
	{
		m_DeWord = "Suchwort nicht gefunden";
	}

	//Rckgabewert, das gefundene Wort wird zurckgegeben
	return m_DeWord;

}
