/***************************************************************************
                          cl_printhtml.h  -  description
                             -------------------
    begin                : Sat Jan 04 2003
    copyright            : (C) 2003 by Reto Loepfe & Thomas Gemperli
    email                : loege@gemperli.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CL_PRINTHTML_H
#define CL_PRINTHTML_H

#include <iostream>
#include <fstream>
#include <string>
#include <stdio.h>
#include <sstream>

#include "cgicc/Cgicc.h"
#include "cgicc/HTTPHTMLHeader.h"
#include "cgicc/HTMLClasses.h"

#include "cl_login.h"
#include "cl_search.h"
#include "cl_learn.h"


using namespace std;
using namespace cgicc;

class cl_printhtml
{

public: 
	cl_printhtml(const string& version);
	~cl_printhtml();
	
	void print();
	void print_line();
	void print_header();
	void print_nav();
	void print_foot();
	void print_contentWelcome();
	void print_contentError();
	void print_contentHilfe();
	void print_contentLernen();
	void print_contentLernenSet();
	void print_contentErfassen();
	void print_contentDictionary();
	void print_contentEinstellungen();
	void print_contentLogin();
	void add_user();
	void del_user();
	void change_Pw();
	void check_user();
	void query_dict();
	void set_word();
	void set_wordBack();
	void check_word();
	void get_word();
	
private:
	string m_version;
	string m_showform;
	string m_formLernenUnit;
	string m_formLernenLang;
	string m_formLernenWord;
	string m_formLernenQuestion;
	string m_formLernenAnswer;
	string m_formErfassenUnit;
	string m_formErfassenDeutsch;
	string m_formErfassenEnglish;
	string m_formDictionaryTolerant;
	string m_formDictionarySearch;
	string m_formDictionaryResult;
	string m_formUsername;
	string m_formPassword;
	string m_formNewUser;
	string m_formDelUser;
	string m_formSearchWord;
	string m_formDixLang;
	string m_formSetWord;
	string m_formSetWordBack;
	string m_formGetWord;
	string m_formchangePw;
	string m_formchangePwW1;
	string m_formchangePwW2;
	string m_formCheckWord;
	string m_formLernenStatusRes;
	string m_tmpErfassenFile;
	
};

#endif
