/***************************************************************************
                          cl_learn.cpp  -  description
                             -------------------
    begin                : Mon Jan 21 2003
    copyright            : (C) 2003 by Reto Loepfe & Thomas Gemperli
    email                : loege@gemperli.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <fstream>
#include <iostream>
#include <string>
#include <map>


#include "cl_learn.h"

using namespace std;

typedef multimap<int, string> MULTI_MAP;
typedef MULTI_MAP::iterator ITERATOR;

cl_learn::cl_learn()
{
	// Pfad zu den Datenfiles feststellen und in private Variable sichern.
	if(getenv("DOCUMENT_ROOT"))
	{
		m_filePath = getenv("DOCUMENT_ROOT");
		m_filePath.append("/loege/data/");
	}

	m_unit = "";
	m_m_Unit = "";
	m_learnTyp = "";
	m_m_learnTyp = "";
	m_username = "";
	m_m_username = "";
	m_WordTrueFalse = "";
	m_WordTrueFalse = "";
	m_Word2Learn = "";
	m_Word2Learn = "";
	m_flag = true;
}


cl_learn::~cl_learn()
{
}


//Hoechste ID der bergebenen Unit ermitteln
int cl_learn::getMaxID(const string& str_Unit, const string& str_DeWord, const string& str_WordTrueFalse)
{
	string str_ID;
	m_unit = str_Unit;

	//Zhler um die hchste ID zu ermitteln, ist auch der Rckgabewert
	int count = 0;

	//Wort zur berprfung, ob es schon im User-File vorhanden ist
	string Word;
	m_DWord = str_DeWord;
	m_WordTrueFalse = str_WordTrueFalse;

	string str_Path = m_filePath;
	str_Path.append(m_username);
	str_Path.append(".dat");

	ifstream inFile(str_Path.c_str());

	if(inFile.is_open())
	{
		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,str_ID,':');

			if(m_unit == "Alle")
			{
				m_m_Unit = "Alle";
				getline(inFile,m_Dummy,':');
			}
			else
			{
				getline(inFile,m_m_Unit,':');
			}
			
			getline(inFile,Word,':');
			getline(inFile,m_Dummy,':');
			getline(inFile,m_m_WordTrueFalse,'\n');

			//Kontrolle, ob das zu speichernde Wort schon in der Tabelle ist mit der gleichen Lektion
			if(m_DWord == Word && m_DWord != "")
			{
				//Wort schon einmal gefunden,
				//Loop bis zum Dateiende
				do
				{
					getline(inFile,m_Dummy,'\n');
				}
				while(!inFile.eof());

				//-99 heisst, das zu speichernde Wort ist bereits vorhanden
				count = -99;
			}
			else
			{
				if((m_m_Unit == str_Unit) && (m_m_WordTrueFalse == m_WordTrueFalse))
				{
					//Gefundene Unit identisch mit gesuchter
					str_ID = m_ID;
					count++;
				}
				else
				{
					if((m_WordTrueFalse == "") && (m_m_Unit == str_Unit))
					{
						count++;
					}
				}
			}

		}
		while(!inFile.eof());

	}

	return count;
}

//Word zum lernen mit random ermitteln
string cl_learn::getWord2Learn(const string& str_Unit, 
							   const string& str_learnTyp, 
							   const string& str_username, 
							   const string& str_WordTrueFalse)
{
	m_unit = str_Unit;
	m_learnTyp = str_learnTyp;
	m_username = str_username;
	m_WordTrueFalse = str_WordTrueFalse;

	int id = 0;
	int m_random = 0;

	id = getMaxID(m_unit,"",m_WordTrueFalse);

	// Division durch Null verhindern
	if(id == 0)
	{
		id = 1;
	}

	long sek;
	time(&sek);
	srand((unsigned)sek);
	
	for(int i=0; i < 20; ++i)
	{
		m_random = rand() % id;
	}

	string str_Path = m_filePath;
	str_Path.append(m_username);
	str_Path.append(".dat");

	int map_ID = 0;
	string flag,Unit,Word;

	ifstream inFile(str_Path.c_str());

	MULTI_MAP m;
	ITERATOR pos;

	if(inFile.is_open())
	{
		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,m_Dummy,':');

			if(m_unit == "Alle")
			{
				Unit = "Alle";
				getline(inFile,m_Dummy,':');
			}
			else
			{
				getline(inFile,Unit,':');
			}

			getline(inFile,m_DWord,':');
			getline(inFile,m_EWord,':');
			getline(inFile,flag,'\n');

			if(m_learnTyp == "EN_DE")
			{
				Word = m_EWord;
			}
			else
			{
				Word = m_DWord;
			}


			//Es werden nur Wrter mit der richtigen Auswahl in den Container gespeichert.
			if(flag == m_WordTrueFalse && m_unit == Unit)
			{
				m.insert(pair<int, string>(map_ID,Word));
				map_ID++;
			}
			else if(m_WordTrueFalse == "" && m_unit == Unit)
			{
				m.insert(pair<int, string>(map_ID,Word));
				map_ID++;
			}

		}
		while(!inFile.eof());

	}

	inFile.close();

	
	pos = m.find(m_random);

	if(pos != m.end())
	{
		m_Word2Learn = pos->second;
	}

	return m_Word2Learn;
}



bool cl_learn::setDEWord(const string& str_DWord, 
							   const string& str_EWord, 
							   const string& str_Unit, 
							   const string& str_username)
{
	m_DWord = str_DWord;
	m_EWord = str_EWord;
	m_unit = str_Unit;
	m_username = str_username;

	string str_Path = m_filePath;
	str_Path.append(m_username);
	str_Path.append(".dat");

	m_m_ID = getMaxID(m_unit,m_DWord,"");

	ofstream outFile(str_Path.c_str(),ios::app);

	if(outFile.is_open() && m_m_ID != -99)
	{

		outFile << ++m_m_ID << ":" << m_unit << ":" << m_DWord << ":" << m_EWord << ":" << "false" << "\n";
		m_flag = true;
			
	}
	else
	{
		m_flag = false;
	}

	//Datei schliessen
	outFile.close();

	return m_flag;
}

//Vom User eingegebene Lsung kontrollieren
string cl_learn::getResult(const string& str_SprachWahl,
							   const string& str_Word,
							   const string& str_RWord,
							   const string& str_username)
{
	m_username = str_username;
	m_learnTyp = str_SprachWahl;
	string result,unit;

	if(m_learnTyp == "DE_EN")
	{
		//Englisches Wort ermitteln
		m_DWord = str_Word;
		m_RWord = str_RWord;
	}
	else
	{
		//Deutsches Wort ermitteln
		m_EWord = str_Word;
		m_RWord = str_RWord;
	}
	
	string str_Path = m_filePath;
	str_Path.append(m_username);
	str_Path.append(".dat");
	
	ifstream inFile(str_Path.c_str());


	if(inFile.is_open())
	{
		//Zeilen auslesen bis das Ende des Files erreicht ist.
		do
		{
			getline(inFile,m_Dummy,':');
			getline(inFile,m_unit,':');
			getline(inFile,m_m_DWord,':');
			getline(inFile,m_m_EWord,':');
			getline(inFile,m_Dummy,'\n');


			if(m_DWord == m_m_DWord && m_learnTyp == "DE_EN")
			{
				if(m_RWord == m_m_EWord)
				{
					do
					{
						getline(inFile,m_Dummy,'\n');
					}
					while(!inFile.eof());
					result = "SUCCESS";
				}
				else
				{
					do
					{
						getline(inFile,m_Dummy,'\n');
					}
					while(!inFile.eof());
					result = "FAILED";
				}
				m_rightWord = m_m_EWord;
				unit = m_unit;
			}
			else if(m_EWord == m_m_EWord && m_learnTyp == "EN_DE")
			{
				if(m_RWord == m_m_DWord)
				{
					do
					{
						getline(inFile,m_Dummy,'\n');
					}
					while(!inFile.eof());
					result = "SUCCESS";
				}
				else
				{
					do
					{
						getline(inFile,m_Dummy,'\n');
					}
					while(!inFile.eof());
					result = "FAILED";

				}
				m_rightWord = m_m_DWord;
				unit = m_unit;
			}

		}
		while(!inFile.eof());
	}
	inFile.close();
	
	//Bei richtiger Eingabe des Users!
	if(result == "SUCCESS")
	{
		cl_userfile einSetFlagTrue;
		einSetFlagTrue.setLearnFlag(m_learnTyp, m_username, str_Word, "true", "");
	}

	return result;

}

// Rueckgabe der richtigen Loesung an html teil
string cl_learn::getRightWord()
{
	return m_rightWord;
}


