/***************************************************************************
                          cl_printhtml.cpp  -  description
                             -------------------
    begin                : Sat Jan 04 2003
    copyright            : (C) 2003 by Reto Loepfe & Thomas Gemperli
    email                : loege@gemperli.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cl_printhtml.h"

// Default Konstruktor
cl_printhtml::cl_printhtml(const string& version)
{	
	// Ein neues Cgicc Objekt erstellen. Enthaelt die CGI-Form Daten.
	Cgicc cgi;

	// Zeiger(form_iterator) auf die einzelnen CGI-Form Elemente setzen.
	form_iterator showform = cgi.getElement("showform");
	form_iterator formLernenUnit = cgi.getElement("formLernenUnit");
	form_iterator formLernenLang = cgi.getElement("formLernenLang");
	form_iterator formLernenWord = cgi.getElement("formLernenWord");
	form_iterator formLernenQuestion = cgi.getElement("formLernenQuestion");
	form_iterator formLernenAnswer = cgi.getElement("formLernenAnswer");
	form_iterator formErfassenUnit = cgi.getElement("formErfassenUnit");
	form_iterator formErfassenDeutsch = cgi.getElement("formErfassenDeutsch");
	form_iterator formErfassenEnglish = cgi.getElement("formErfassenEnglish");
	form_iterator formDictionaryTolerant = cgi.getElement("formDictionaryTolerant");
	form_iterator formDictionarySearch = cgi.getElement("formDictionarySearch");
	form_iterator formDictionaryResult = cgi.getElement("formDictionaryResult");
	form_iterator formUsername = cgi.getElement("formUsername");
	form_iterator formPassword = cgi.getElement("formPassword");
	form_iterator formNewUser = cgi.getElement("formNewUser");
	form_iterator formDelUser = cgi.getElement("formDelUser");
	form_iterator formSearchWord = cgi.getElement("formSearchWord");
	form_iterator formDixLang = cgi.getElement("formDixLang");
	form_iterator formSetWord = cgi.getElement("formSetWord");
	form_iterator formSetWordBack = cgi.getElement("formSetWordBack");
	form_iterator formGetWord = cgi.getElement("formGetWord");
	form_iterator formchangePw = cgi.getElement("formchangePw");
	form_iterator formchangePwW1 = cgi.getElement("formchangePwW1");
	form_iterator formchangePwW2 = cgi.getElement("formchangePwW2");
	form_iterator formCheckWord = cgi.getElement("formCheckWord");
	form_iterator formLernenStatusRes = cgi.getElement("formLernenStatusRes");
	
	// CGI-Formdaten in private Variablen abfuellen. Nur bei gueltigem Wert.
	if(showform != cgi.getElements().end())
	{	m_showform = **showform; }
	if(formLernenUnit != cgi.getElements().end())
	{	m_formLernenUnit = **formLernenUnit; }
	if(formLernenLang != cgi.getElements().end())
	{	m_formLernenLang = **formLernenLang; }
	if(formLernenWord != cgi.getElements().end())
	{	m_formLernenWord = **formLernenWord; }
	if(formLernenQuestion != cgi.getElements().end())
	{	m_formLernenQuestion = **formLernenQuestion; }
	if(formLernenAnswer != cgi.getElements().end())
	{	m_formLernenAnswer = **formLernenAnswer; }
	if(formErfassenUnit != cgi.getElements().end())
	{	m_formErfassenUnit = **formErfassenUnit; }
	if(formErfassenDeutsch != cgi.getElements().end())
	{	m_formErfassenDeutsch = **formErfassenDeutsch; }
	if(formErfassenEnglish != cgi.getElements().end())
	{	m_formErfassenEnglish = **formErfassenEnglish; }
	if(formDictionaryTolerant != cgi.getElements().end())
	{	m_formDictionaryTolerant = **formDictionaryTolerant; }
	if(formDictionarySearch != cgi.getElements().end())
	{	m_formDictionarySearch = **formDictionarySearch; }
	if(formDictionaryResult != cgi.getElements().end())
	{	m_formDictionaryResult = **formDictionaryResult; }
	if(formUsername != cgi.getElements().end())
	{	m_formUsername = **formUsername; }
	if(formPassword != cgi.getElements().end())
	{	m_formPassword = **formPassword; }
	if(formNewUser != cgi.getElements().end())
	{	m_formNewUser = **formNewUser; }
	if(formDelUser != cgi.getElements().end())
	{	m_formDelUser = **formDelUser; }
	if(formSearchWord != cgi.getElements().end())
	{	m_formSearchWord = **formSearchWord; }
	if(formDixLang != cgi.getElements().end())
	{	m_formDixLang = **formDixLang; }
	if(formSetWord != cgi.getElements().end())
	{	m_formSetWord = **formSetWord; }
	if(formSetWordBack != cgi.getElements().end())
	{	m_formSetWordBack = **formSetWordBack; }
	if(formGetWord != cgi.getElements().end())
	{	m_formGetWord = **formGetWord; }
	if(formchangePw != cgi.getElements().end())
	{	m_formchangePw = **formchangePw; }
	if(formchangePwW1 != cgi.getElements().end())
	{	m_formchangePwW1 = **formchangePwW1; }
	if(formchangePwW2 != cgi.getElements().end())
	{	m_formchangePwW2 = **formchangePwW2; }
	if(formCheckWord != cgi.getElements().end())
	{	m_formCheckWord = **formCheckWord; }
	if(formLernenStatusRes != cgi.getElements().end())
	{	m_formLernenStatusRes = **formLernenStatusRes; }


	// Einfache Versionsaenderung
	m_version = version;

}


// Default Destruktor. Der Vollstaendigkeit halber.
cl_printhtml::~cl_printhtml()
{
}


// Diese Methode wird aus dem main aufgerufen.
// Baut die Seite je nach Wert der CGI-Form Daten auf.
void cl_printhtml::print()
{
	// Header der html Seite ausgeben.
	print_header();

	// Navigation ausgeben
	print_nav();
	
	// Neuen Benutzer anlegen
	add_user();

	// Benutzer loeschen
	del_user();

	// Passwort neu setzen
	change_Pw();

	// Hat User eingeloggt und ist er gueltig?
	check_user();

	// Footer der html Seite ausgeben.
	print_foot();
}


// Eine horizontale Linie. Zwecks Vereinfachung und Codeersparniss.
void cl_printhtml::print_line()
{
    cout << "<table width=\"100%\" border=\"0\" \
    		cellpadding=\"0\" cellspacing=\"0\">" << endl;
    cout << "<tr><td class=\"menu\">\
    		<img src=\"/loege/pix/onepixel.gif\" height=\"11\" alt=\"\"></td></tr>" << endl;
    cout << "<tr><td class=\"border\">\
    		<img src=\"/loege/pix/onepixel.gif\" height=\"1\" alt=\"\"></td></tr>" << endl;
    cout << "<tr><td class=\"menu\">\
    		<img src=\"/loege/pix/onepixel.gif\" height=\"6\" alt=\"\"></td></tr>" << endl;
    cout << "</table>" << endl;
}

// Ausgeben des HTML-Headers
void cl_printhtml::print_header()
{
	// HTML Dokument Typ festlegen
    cout << HTTPHTMLHeader() << HTMLDoctype(HTMLDoctype::eTransitional) << endl;
    cout << html().set("lang", "en").set("dir", "ltr") << endl;

    // Header oeffnen
    cout << head() << endl;

	// Style sheet Direktiven. Vereinfachen das graphische Managament der
	// Website durch zentrale Speicherung von Darstellungsinformationen.
	cout << style() << comment() << endl;
	cout << "body{margin-left:0px;margin-right:0px;margin-top:\
			0px;margin-bottom:0px;font-family:helvetica,arial,sans-serif;\
			background-color:#667788;color:#ffffff;}" << endl;
	cout << "a:link{color:#d0e0f0;}" << endl;
	cout << "a:visited{color:#d0e0f0;}" << endl;
	cout << "a:active{color:#d0e0f0;}" << endl;
	cout << "p{font-family:helvetica,arial,sans-serif;\
			font-size:12pt;color:#ffffff;}" << endl;
	cout << "p.title{margin-top:10px;margin-bottom:0px;\
			font-family:helvetica,arial,sans-serif;\
			font-weight:bold;font-size:14pt;color:#ffffff;}" << endl;
	cout << "p.subtitle{margin-top:10px;margin-bottom:10px;\
			font-family:helvetica,arial,sans-serif;\
			font-weight:bold;font-size:11pt;color:#ffffff;}" << endl;
	cout << "p.good{margin-top:10px;margin-bottom:10px;\
			font-family:helvetica,arial,sans-serif;\
			font-weight:bold;font-size:11pt;color:#00ff00;}" << endl;
	cout << "p.error{margin-top:10px;margin-bottom:10px;\
			font-family:helvetica,arial,sans-serif;\
			font-weight:bold;font-size:11pt;color:#ee7733;}" << endl;	
	cout << "pre{font-family:courier,sans-serif;font-size:10pt;\
			text-align:left;color:#ffffff;}" << endl;
	cout << "td{font-family:helvetica,arial,sans-serif;\
			font-size:10pt;color:#ffffff;}" << endl;
	cout << "td.menutop{font-family:helvetica,arial,sans-serif;\
			font-size:11pt;background-color:#3e4266;color:#ffffff;}" << endl;
	cout << "td.content{font-family:helvetica,arial,sans-serif;\
			font-size:11pt;background-color:#ffffff;color:#3e4266;}" << endl;
	cout << "td.border{background-color:#3e4266;color:#ffffff;}" << endl;
	cout << "td.menu{font-family:helvetica,arial,sans-serif;font-size:10pt;\
			background-color:#7a8a9a;color:#ffffff;}" << endl;
	cout << "td.menumain{font-family:helvetica,arial,sans-serif;font-size:12pt;\
			background-color:#7a8a9a;color:#ffffff;}" << endl;
	cout << "td.background{background-color:#667788;color:#667788;}" << endl;
    cout << comment() << style() << endl;

	// Titel ausgeben und Header schliessen
	cout << title() << "LoeGe v" << m_version << title() << endl;
    cout << head() << endl;
}

// Die HTML Ausgabe des Menus.
void cl_printhtml::print_nav()
{
    // HTML body oeffnen
    cout << body() << endl;
    
	// Ausgeben des Navigationsteiles der Website
	cout << "<!-- main table -->" << endl;
    cout << "<table border=\"0\" width=\"90%\" cellspacing=\"0\" \
    		cellpadding=\"10\" align=\"center\">" << endl;
    cout << "<!-- logo -->" << endl;
    cout << "<tr><td>" << endl;

    // Laden des Logos
    cout << "<a href=\"loege\"><img src=\"/loege/pix/logo-loege.png\" border=\"0\" \
			alt=\"LoeGe\"></a>" << endl;
    cout << "</td></tr>" << endl;
    cout << "<!-- menu -->" << endl;
    cout << "<tr><td>" << endl;
    cout << "<table width=\"130\" border=\"0\" cellpadding=\"0\" \
    		cellspacing=\"0\">" << endl;
    cout << "<tr valign=\"top\">" << endl;
    cout << "<td class=\"background\" width=\"10\">\
    		<img src=\"/loege/pix/onepixel.gif\" alt=\"\"></td>" << endl;
    cout << "<td class=\"menutop\" width=\"120\">\
    		<img src=\"/loege/pix/onepixel.gif\" width=\"6\" alt=\"\"><b>Menu</b></td>" << endl;
    cout << "</tr>" << endl;
    cout << "</table>" << endl;
    cout << "<table width=\"100%\" border=\"0\" cellpadding=\"0\" \
    		cellspacing=\"0\">" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"border\" colspan=\"3\">\
    		<img src=\"/loege/pix/onepixel.gif\" height=\"1\" alt=\"\"></td>" << endl;
    cout << "</tr>" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"border\">\
    		<img src=\"/loege/pix/onepixel.gif\" width=\"1\" alt=\"\"></td>" << endl;
    cout << "<td width=\"100%\">" << endl;
    cout << "<table width=\"100%\" border=\"0\" \
    		cellpadding=\"6\" cellspacing=\"0\">" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"menu\">" << endl;
	cout << "<table><tr>" << endl;

	// Zielseite, Username und Passwort werden durch Senden des (Navigations) Formulars uebergeben
	cout << "<td width=\"20%\"><form action=\"loege\" method=\"Post\" name=\"gotoLernen\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"showform\" value=\"lernen\">" << endl;
	cout << "<input type=\"submit\" name=\"action\" value=\"    Lernen     \">" << endl;
	cout << "</form></td>" << endl;
	cout << "<td width=\"20%\"><form action=\"loege\" method=\"Post\" name=\"gotoErfassen\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"showform\" value=\"erfassen\">" << endl;
	cout << "<input type=\"submit\" name=\"action\" value=\"    Wortliste   \">" << endl;
	cout << "</form></td>" << endl;
	cout << "<td width=\"20%\"><form action=\"loege\" method=\"Post\" name=\"gotoDictionary\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"showform\" value=\"dictionary\">" << endl;
	cout << "<input type=\"submit\" name=\"action\" value=\"  W&ouml;rterbuch  \">" << endl;
	cout << "</form></td>" << endl;
	cout << "<td width=\"20%\"><form action=\"loege\" method=\"Post\" name=\"gotoEinstellungen\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"showform\" value=\"einstellungen\">" << endl;
	cout << "<input type=\"submit\" name=\"action\" value=\"   Benutzer    \">" << endl;
	cout << "</form></td>" << endl;
	cout << "<td width=\"20%\"><form action=\"loege\" method=\"Post\" name=\"gotoHilfe\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"showform\" value=\"hilfe\">" << endl;
	cout << "<input type=\"submit\" name=\"action\" value=\"      Hilfe      \">" << endl;
	cout << "</form></td>" << endl;
	cout << "</tr></table>" << endl;
    cout << "</td>" << endl;
    cout << "</tr>" << endl;
    cout << "</table>" << endl;
    cout << "</td>" << endl;
    cout << "<td class=\"border\">\
    		<img src=\"/loege/pix/onepixel.gif\" width=\"1\" alt=\"\"></td>" << endl;
    cout << "</tr>" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"border\" colspan=\"3\">\
			<img src=\"/loege/pix/onepixel.gif\" height=\"1\" alt=\"\"></td>" << endl;
    cout << "</tr>" << endl;
    cout << "</table>" << endl;
    cout << "</td></tr>" << endl;

   // Der "Inhaltsbereich" beginnt
    cout << "<!-- content -->" << endl;
    cout << "<tr><td>" << endl;
    cout << "<table width=\"130\" border=\"0\" \
    		cellpadding=\"0\" cellspacing=\"0\">" << endl;
    cout << "<tr valign=\"top\">" << endl;
    cout << "<td class=\"background\" width=\"10\">\
    		<img src=\"/loege/pix/onepixel.gif\" alt=\"\"></td>" << endl;
    cout << "<td class=\"menutop\" width=\"120\">\
    		<img src=\"/loege/pix/onepixel.gif\" width=\"6\" \
      		alt=\"\"><b>Inhalt</b></td>" << endl;
    cout << "</tr>" << endl;
    cout << "</table>" << endl;
    cout << "<table width=\"100%\" border=\"0\" \
    		cellpadding=\"0\" cellspacing=\"0\">" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"border\" colspan=\"3\">\
    		<img src=\"/loege/pix/onepixel.gif\" height=\"1\" \
      		alt=\"\"></td>" << endl;
    cout << "</tr>" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"border\">\
    		<img src=\"/loege/pix/onepixel.gif\" width=\"1\" alt=\"\"></td>" << endl;
    cout << "<td width=\"100%\">" << endl;
    cout << "<table width=\"100%\" border=\"0\" \
    		cellpadding=\"6\" cellspacing=\"0\">" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"menumain\">" << endl;
}

// Die HTML Ausgabe des Fussteiles der Website
void cl_printhtml::print_foot()
{
    cout << "</td>" << endl;
    cout << "</tr>" << endl;
    cout << "</table>" << endl;
    cout << "</td>" << endl;
    cout << "<td class=\"border\">\
    		<img src=\"/loege/pix/onepixel.gif\" width=\"1\" alt=\"\"></td>" << endl;
    cout << "</tr>" << endl;
    cout << "<tr>" << endl;
    cout << "<td class=\"border\" colspan=\"3\">\
    		<img src=\"/loege/pix/onepixel.gif\" height=\"1\" alt=\"\"></td>" << endl;
    cout << "</tr>" << endl;
    cout << "</table>" << endl;
    cout << "</td></tr>" << endl;
    cout << "</table>" << endl;
    // HTML Body und Dokument schliessen
	cout << body() << html() << endl;
}

// Die HTML Ausgabe des Willkommenseite. Erscheint nach erfolgreichem Login.
void cl_printhtml::print_contentWelcome()
{
	cout << "<p class=\"title\">LoeGe</p>" << endl;
	print_line();
    cout << "<p class=\"subtitle\">English - Deutsch Lernprogramm</p>" << endl;   
    cout << "<img src=\"/loege/pix/lazy.gif\" alt=\"under construction\">" << endl;
    cout << "<p>Einfacher Englisch lernen.</p>" << endl;
    cout << "<p>&nbsp;</p>" << endl;
}

// Die HTML Ausgabe bei einem Fehler. Darf nicht vorkommen.
void cl_printhtml::print_contentError()
{
	cout << "<p class=\"title\">Fehler!</p>" << endl;
	print_line();
    cout << "<p>Gib dem Programmierer einen Tritt in den Arsch.</p>" << endl;
    cout << "<p>&nbsp;</p>" << endl;
}

// Die HTML Ausgabe der Hilfe Texte.
void cl_printhtml::print_contentHilfe()
{
	cout << "<p class=\"title\">Hilfe</p>" << endl;
	print_line();
    cout << "<p class=\"subtitle\">Zweck</p>" << endl;
    cout << "<p>LoeGe ist ein Vokabular Lernprogramm, das " << endl;
    cout << "zum Erlernen von englischen W&ouml;rtern benutzt wird.<br>" << endl;
    cout << "Es kann weiter als normales W&ouml;rterbuch verwendet werden.\
    		 </p><p>LoeGe ist das Resultat einer Vordiplomarbeit zum Informatiker TS. <br>\
       		 Rahmenbedingungen der Arbeit waren die Implementation in C++ und \
          	 die Verwendung der Konsole zur Daten Ein- und Ausgabe.</p><p>\
             Wir erweiterten die Ein- und Ausgabe um HTML Steuerelemente und \
             konnten so ein GUI realisieren. \
             Der gesamte HTML Code wird von LoeGe dynamisch generiert.\
             </p><p>Implementiert wurde die Applikation in ANSI Standard C++. \
             <br>So konnte ein Maximum an Portabilit&auml;t und Lerneffekt \
             f&uuml;r uns ;) erreicht werden.</p>" << endl;
 	print_line();
    cout << "<p class=\"subtitle\">Menu</p>" << endl;
    cout << "<p>Mittels Klick der Buttons werden die verschiedenen Funktionen von LoeGe " << endl;
    cout << "erreicht.<br>Durch ein Klick auf das Logo loggen Sie sich aus.</p>" << endl;
 	print_line();
    cout << "<p class=\"subtitle\">Lernen</p>" << endl;
    cout << "<p>Dies ist der Vokabeltrainer. <br>Zu Beginn erscheint eine Maske auf der " << endl;
    cout << "folgende Optionen gesetzt werden m&uuml;ssen:</p>" << endl;
    cout << "<ul><li><b>Unit</b> Selektieren Sie einzelne oder alle Lektionen aus Ihrer\
    		pers&ouml;nlichen Wortliste.</li><li><b>Status</b> W&auml;hlen Sie entweder \
     		alle W&ouml;rter, die, die Sie beherrschen oder jene, die noch nicht ganz \
       		sitzen.</li><li><b>Sprachwahl</b> Lernen Sie Deutsch-English oder English-Deutsch\
         	</li></ul>" << endl;
    cout << "<p>Danach folgt das Abfragefenster. Im oberen Teil werden nochmals die gesetzten \
    		Suchoptionen angezeigt. </p><p> Im unteren Teil geschieht die eigentliche Abfrage. \
      		Falls Sie die \"Sonderzeichen\" Funktion benutzen wollen, muss ihr \
        	Browser Java-Script aktiviert haben. </p><p>Nachdem auf &Uuml;berpr&uuml;fen geklickt \
         	wurde, wird das Ergebniss Ihrer &Uuml;bersetzung im mittleren, dem Resultat Teil \
          	ausgegeben. <br>LoeGe zeigt Ihnen die richtige L&ouml;sung in jedem Fall an. \
    		</p><p>Wenn Sie eine Abfrage richtig beantwortet haben, wird deren Status in \
      		Ihrer Wortliste automatisch auf \"sitzt\" gesetzt." << endl;
 	print_line();
    cout << "<p class=\"subtitle\">Wortliste</p>" << endl;
    cout << "<p>Diese Maske dient zum Erfassen von Vokabeln in die pers&ouml;nliche Wortliste. <br>\
    		Die Wortliste ist, wie die meisten Englisch Kurse auch, nach Lektionen\
      		sortiert. </p><p>Die hier erfassten Vokabeln stehen Ihnen im \"Lernen Modus\" \
        	zur Verf&uuml;gung.  </p><p>Mit der Funktion \"Wortliste zur&uuml;cksetzen\" \
         	k&ouml;nnen Sie den Status aller Vokabeln auf \"sitzt nicht\" \
          	zur&uuml;cksetzen.</p><p>Im letzten Abschnitt wird die aktuelle \
          Wortliste ausgegeben.</p>" << endl;
    print_line();
    cout << "<p class=\"subtitle\">W&ouml;rterbuch</p>" << endl;
    cout << "<p>Dies ist ein simpler, elektronischer &Uuml;bersetzer.<br>\
    		Suchen Sie nach deutschen oder englischen W&ouml;rtern. </p><p>\
      		Falls Sie die \"Sonderzeichen\" Funktion benutzen wollen, muss ihr \
        	Browser Java-Script aktiviert haben. </p>" << endl;
    print_line();
    cout << "<p class=\"subtitle\">Benutzer</p>" << endl;
    cout << "<p>Diese Maske erlaubt Ihnen den aktuellen Benutzer zu \
    		l&ouml;schen sowie dessen Passwort neu zu setzen.</p>" << endl;
    print_line();
    cout << "<p class=\"subtitle\">Hilfe</p>" << endl;
    cout << "<p>Dieses Dokument. <br>Informationen und die Bedienungsanleitung zu LoeGe.</p>" << endl;
    print_line();
    cout << "<p class=\"subtitle\">Download</p>" << endl;
    cout << "<p>LoeGe Sourcecode als <a href=\"/loege/source/just_our_files.zip\">zip</a>\
             oder als <a href=\"/loege/source/just_our_files.tar.gz\">tar.gz</a> Archiv.<br>\
             Der Source in einem kompletten Kdevelop Projekt als\
             <a href=\"/loege/source/loege-1.2.tar.gz\">tar.gz</a> Archiv.</p>\
             <p>Die verwendete <a href=\"/loege/source/cgicc-3.2.1.tar.gz\">Cgicc</a> Bibliothek.</p>\
             <p>Die Daten (W&ouml;rterbuch DB, Logo, usw.) als \
             <a href=\"/loege/source/loege.zip\">zip</a>\
             oder als <a href=\"/loege/source/loege.tar.gz\">tar.gz</a> Archiv.</p>\
             <p>Die Dokumentation zum Projekt im \
             <a href=\"/loege/doc/vordiplomarbeit_loege.pdf\">pdf</a> Format.</p>" << endl;
    print_line();
    cout << "<p class=\"subtitle\">About</p>" << endl;
    cout << "<p><a href=\"http://loege.ethz.ch/\">LoeGe</a> \
    		Version " << m_version << "</p>" << endl;
	  cout << "<p>&copy; 2003 by Reto Loepfe & Thomas Gemperli<br>" << endl;

	  // loege@gemperli.net ist ein Mailverteiler an die Projektbeteiligten
    cout << "Kontakt: <a href=\"mailto:loege@gemperli.net\">\
    		loege@gemperli.net</a></p>" << endl;
    cout << "<p>&nbsp;</p>" << endl;
}

// Die HTML Ausgabe der Optionenseite der Funktion "Woerter lernen"
void cl_printhtml::print_contentLernen()
{
	cout << "<p class=\"title\">Lernmodus Optionen</p>" << endl;
	print_line();
    cout << "<p class=\"subtitle\">Bitte Optionen setzen</p>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"formLernenParam\">" << endl;
	cout << "<table><tr>" << endl;
	cout << "<td width=\"100\">Unit</td>" << endl;
	cout << "<td><select name=\"formLernenUnit\">" << endl;
	cout << "<option selected=\"Alle\">Alle" << endl;
	for(int i = 1; i < 100; ++i)
	{
		cout << "<option value=\"" << i << "\"" << ">" << i << endl;
	}
	cout << "</select></td></tr>" << endl;
	cout << "<tr><td width=\"100\">Status</td>" << endl;
	cout << "<td><select name=\"formLernenWord\">" << endl;
	cout << "<option value=\"Alle\">Alle" << endl;
	cout << "<option selected=\"Nicht Gewusste\">Nicht Gewusste" << endl;
	cout << "<option value=\"Gewusste\">Gewusste" << endl;
	cout << "</select></td></tr>" << endl;
	cout << "<tr><td width=\"100\">Sprachwahl</td>" << endl;
	cout << "<td><select name=\"formLernenLang\">" << endl;
	cout << "<option selected=\"De-En\">De-En" << endl;
	cout << "<option value=\"En-De\">En-De" << endl;
	cout << "</select></td>" << endl;
	cout << "</tr></table>" << endl;
	print_line();
	cout << "<table><tr>" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formGetWord\" value=\"on\">" << endl;
	cout << "<td width=\"100\"><input type=\"hidden\" name=\"showform\" value=\"lernenSet\"></td>" << endl;
	cout << "<td><input type=\"submit\" name=\"action\" value=\"     Start      \"></td>" << endl;
	cout << "</tr></table></form>" << endl;
	cout << "<p>&nbsp;</p>" << endl;
}

// Die HTML Ausgabe der Maske "Woerter lernen"
void cl_printhtml::print_contentLernenSet()
{	
	cout << "<p class=\"title\">Lernmodus</p>" << endl;
	print_line();
    cout << "<p class=\"subtitle\">Gew&auml;hlte Optionen</p>" << endl;
	cout << "<table><tr>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"formLernenSet\">" << endl;
	cout << "<td width=\"100\">Unit</td>" << endl;
	cout << "<td width=\"100\">" << m_formLernenUnit << "</td></tr>" << endl;
	cout << "<tr><td width=\"100\">Status</td>" << endl;
	cout << "<td width=\"100\">" << m_formLernenWord << "</td></tr>" << endl;
	cout << "<tr><td width=\"100\">Sprachwahl</td>" << endl;
	cout << "<td width=\"100\">" << m_formLernenLang << "</td></tr></table>" << endl;
	print_line();

	// Der Statusbereich der Maske "Woerter lernen"
    cout << "<p class=\"subtitle\">Resultat</p>" << endl;

	// Rueckmeldung der Resulte an den Benutzer
	check_word();

	print_line();
	
	// Der Abfragebereich der Maske "Woerter lernen"
    cout << "<p class=\"subtitle\">Abfrage</p>" << endl;
	cout << "<table><tr>" << endl;

	// Status des letzten Aufrufes der Seite abfragen, default Optionen
	// entsprechend setzen und ausgeben
    if(m_formLernenLang == "De-En")
    {
    	cout << "<td width=\"100\">Deutsch</td><td>" << endl;
    }
    else
    {
    	cout << "<td width=\"100\">English</td><td>" << endl;
    }

    // Wort zum Abfragen holen.
    get_word();

	// Status des letzten Aufrufes der Seite abfragen, default Optionen
	// entsprechend setzen und ausgeben
    if(m_formLernenLang == "En-De")
    {
    	cout << "</td></tr><tr><td width=\"100\">Deutsch</td>" << endl;
    }
    else
    {
    	cout << "</td></tr><tr><td width=\"100\">English</td>" << endl;
    }
  	cout << "<td><input type=\"text\" name=\"formLernenAnswer\" size=\"30\">" << endl;
    cout << "</td></tr><tr>" << endl;
    cout << "<td width=\"100\">Sonderzeichen</td>" << endl;
    cout << "<td><input type=\"button\" value=\" &auml; \" onClick=\"this.form.formLernenAnswer.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &ouml; \" onClick=\"this.form.formLernenAnswer.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &uuml; \" onClick=\"this.form.formLernenAnswer.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &aring; \" onClick=\"this.form.formLernenAnswer.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &oslash; \" onClick=\"this.form.formLernenAnswer.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &otilde; \" onClick=\"this.form.formLernenAnswer.value\
            += '';\">" << endl;
    cout << "</td></tr><tr>" << endl;
	cout << "<td width=\"100\">&nbsp;</td></tr><tr>" << endl;
 	cout << "<td width=\"100\"><input type=\"hidden\" name=\"showform\" value=\"lernenSet\">" << endl;
  	cout << "<input type=\"hidden\" name=\"formGetWord\" value=\"on\">" << endl;
    cout << "<input type=\"hidden\" name=\"formCheckWord\" value=\"on\">" << endl;
	cout << "<input type=\"hidden\" name=\"formLernenQuestion\" value=\"" << m_formLernenQuestion << "\">" << endl;
  	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formLernenUnit\" value=\"" << m_formLernenUnit << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formLernenWord\" value=\"" << m_formLernenWord << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formLernenLang\" value=\"" << m_formLernenLang << "\"></td>" << endl;
	cout << "<td><input type=\"submit\" name=\"action\" value=\"  &Uuml;berpr&uuml;fen   \"></td>" << endl;
	cout << "</form></tr></table>" << endl;
	
	cout << "<p>&nbsp;</p>" << endl;
}

// Die HTML Ausgabe der Maske "Wortliste"
void cl_printhtml::print_contentErfassen()
{
	// Falls vorhanden, Wort erfassen.
	set_word();

	cout << "<p class=\"title\">Pers&ouml;nliche Wortliste</p>" << endl;
	print_line();
	cout << "<p class=\"subtitle\">W&ouml;rter erfassen</p>" << endl;
	cout << "<table><tr>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"formErfassen\">" << endl;
	cout << "<td width=\"100\">Unit</td>" << endl;
	cout << "<td><select name=\"formErfassenUnit\">" << endl;
	
	for(int i = 1; i < 100; ++i)
	{
		// int i in string umwandeln, damit i mit sting m_formErfassenUnit verglichen werden kann
		string g;
		stringstream einStream;
		einStream << i;
		einStream >> g;

		if(m_formErfassenUnit == g)
		{
			cout << "<option selected=\"" << i << "\"" << ">" << i << endl;
		}
		else
		{
			cout << "<option value=\"" << i << "\"" << ">" << i << endl;
		}
	}
	
	cout << "</select></td></tr><tr>" << endl;
	cout << "<td width=\"100\">Deutsch</td>" << endl;
	cout << "<td><input type=\"text\" name=\"formErfassenDeutsch\"\
			 size=\"30\"></td></tr><tr>" << endl;
    cout << "<td width=\"100\">Sonderzeichen</td>" << endl;
    cout << "<td><input type=\"button\" value=\" &auml; \" onClick=\"this.form.formErfassenDeutsch.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &ouml; \" onClick=\"this.form.formErfassenDeutsch.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &uuml; \" onClick=\"this.form.formErfassenDeutsch.value\
            += '';\">" << endl;
    cout << "</td></tr><tr>" << endl;
	cout << "<td width=\"100\">English</td>" << endl;
	cout << "<td><input type=\"text\" name=\"formErfassenEnglish\"\
			 size=\"30\"></td></tr><tr>" << endl;
    cout << "<td width=\"100\">Sonderzeichen</td>" << endl;
    cout << "<td><input type=\"button\" value=\" &auml; \" onClick=\"this.form.formErfassenEnglish.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &ouml; \" onClick=\"this.form.formErfassenEnglish.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &uuml; \" onClick=\"this.form.formErfassenEnglish.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &aring; \" onClick=\"this.form.formErfassenEnglish.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &oslash; \" onClick=\"this.form.formErfassenEnglish.value\
            += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &otilde; \" onClick=\"this.form.formErfassenEnglish.value\
            += '';\">" << endl;
    cout << "</td></tr><tr>" << endl;
	cout << "<td width=\"100\">&nbsp;</td></tr><tr>" << endl;
	cout << "<input type=\"hidden\" name=\"formSetWord\" value=\"on\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<td width=\"100\"><input type=\"hidden\" name=\"showform\" value=\"erfassen\"></td>" << endl;
	cout << "<td><input type=\"submit\" name=\"action\" value=\"   Erfassen    \"></td>" << endl;
	cout << "</form></tr></table>" << endl;
    cout << "<p>&nbsp;</p>" << endl;

    print_line();

    // Falls gewuenscht, Woerter Status zuruecksetzen.
	set_wordBack();

	cout << "<p class=\"subtitle\">Wortliste zur&uuml;cksetzen</p>" << endl;
	cout << "<p>Status aller W&ouml;rter auf \"sitzt nicht\" zur&uuml;cksetzen.</p>" << endl;
	cout << "<table><tr>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"formZuruecksetzen\">" << endl;
	cout << "<td width=\"100\">&nbsp;" << endl;
	cout << "<input type=\"hidden\" name=\"formSetWordBack\" value=\"on\">" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"showform\" value=\"erfassen\"></td>" << endl;
	cout << "<td><input type=\"submit\" name=\"action\" value=\"Zur&uuml;cksetzen\"></td>" << endl;
	cout << "</form></tr></table>" << endl;

  print_line();

	cout << "<p class=\"subtitle\">Inhalt der Wortliste</p>" << endl;
	cout << "<p>Der aktuelle Inhalt der Wortliste, nach Lektionen sortiert.</p>" << endl;
	cout << "<table><tr>" << endl;
	cout << "<td width=\"70\"><b>Lektion</b></td><td width=\"120\"><b>Deutsch</b></td>" << endl;
	cout << "<td width=\"120\"><b>English</b></td><td width=\"100\"><b>Status</b></td></tr>" << endl;

  // Wortliste ausgeben
  cl_userfile einUserfile;
  einUserfile.showFile(m_formUsername);

	cout << "</table>" << endl;

  cout << "<p>&nbsp;</p>" << endl;

}

// Die HTML Ausgabe der Maske "Woerterbuch"
void cl_printhtml::print_contentDictionary()
{
	cout << "<p class=\"title\">W&ouml;rterbuch</p>" << endl;
	print_line();
	cout << "<form action=\"loege\" method=\"Post\" name=\"formDictionary\">" << endl;
	cout << "<table><tr>" << endl;

	cout << "<td width=\"100\">Sprachwahl</td>" << endl;
	cout << "<td><select name=\"formDixLang\">" << endl;
	if(m_formDixLang == "De-En")
	{
		cout << "<option selected=\"De-En\">De-En" << endl;
		cout << "<option value=\"En-De\">En-De" << endl;
	}
	else
	{
		cout << "<option value=\"De-En\">De-En" << endl;
		cout << "<option selected=\"En-De\">En-De" << endl;
	}
	cout << "</select></td>" << endl;

	cout << "</tr><tr>" << endl;
	cout << "<td width=\"100\">Suchwort</td>" << endl;
	cout << "<td><input type=\"text\" name=\"formDictionarySearch\"\
			 size=\"30\"></td></tr><tr>" << endl;

	cout << "<td width=\"100\">Sonderzeichen</td>" << endl;
    cout << "<td><input type=\"button\" value=\" &auml; \" onClick=\"this.form.formDictionarySearch.value\
    		 += '';\">" << endl;
    cout << "<input type=\"button\" value=\" &ouml; \" onClick=\"this.form.formDictionarySearch.value\
    		+= '';\">" << endl;
    cout << "<input type=\"button\" value=\" &uuml; \" onClick=\"this.form.formDictionarySearch.value\
			+= '';\"></td></tr><tr>" << endl;

			 
	cout << "<td width=\"100\"><p>&nbsp;</p></td>" << endl;
	cout << "</tr><tr><td width=\"100\">&nbsp;</td></tr><tr>" << endl;
	cout << "<input type=\"hidden\" name=\"formSearchWord\" value=\"on\">" << endl;
	cout << "<td width=\"100\"><input type=\"hidden\" name=\"showform\" value=\"dictionary\"></td>" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
	cout << "<td><input type=\"submit\" name=\"action\" value=\"   Suchen    \"></td>" << endl;
	cout << "</form></tr></table>" << endl;
    
    print_line();
    cout << "<table><tr>" << endl;
    cout << "<td width=\"100\">Ergebniss(e)</td><td>" << endl;

	// Dictionary Funktion aufrufen, Suchwort abfragen
	query_dict();

	cout << "</td></tr></table>" << endl;
	cout << "<br>" << endl;
}

// Die HTML Ausgabe der Maske "Benutzer"
void cl_printhtml::print_contentEinstellungen()
{
	cout << "<p class=\"title\">Benutzer</p>" << endl;
	print_line();
    cout << "<p class=\"subtitle\">Benutzer l&ouml;schen</p>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"delUser\">" << endl;
 	cout << "<table><tr>" << endl;
	cout << "<td width=\"100\">Aktueller Benutzer</td><td><p class=\"good\">" << m_formUsername << "</p>" << endl;
	cout << "<input type=\"hidden\" name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\" value=\"" << m_formPassword << "\">" << endl;
  	cout << "<input type=\"hidden\" name=\"showform\" value=\"einstellungen\">" << endl;
   	cout << "<input type=\"hidden\" name=\"formDelUser\" value=\"on\"></td></tr>" << endl;
	cout << "<tr><td width=\"100\">&nbsp;</td><td><input type=\"submit\" name=\"action\" \
			value=\"   L&ouml;schen   \"></td></tr>" << endl;
	cout << "</form></table>" << endl;
	print_line();

	// Passwort aendern
    cout << "<p class=\"subtitle\">Passwort &auml;ndern</p>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"changePw\">" << endl;
 	cout << "<table><tr>" << endl;
	cout << "<td width=\"100\">Neues Passwort</td>" << endl;
	cout << "<td><input type=\"password\" name=\"formchangePwW1\"\
			 size=\"30\"></td></tr><tr>" << endl;
	cout << "<td width=\"100\">Neues Passwort wiederholen</td>" << endl;
	cout << "<td><input type=\"password\" name=\"formchangePwW2\"\
			 size=\"30\"></td></tr><tr><td>&nbsp;</td></tr><tr>" << endl;
	cout << "<td width=\"100\"><input type=\"hidden\" \
			name=\"formUsername\" value=\"" << m_formUsername << "\">" << endl;
	cout << "<input type=\"hidden\" name=\"formPassword\"\
			value=\"" << m_formPassword << "\">" << endl;
  	cout << "<input type=\"hidden\" name=\"showform\" value=\"einstellungen\">" << endl;
   	cout << "<input type=\"hidden\" name=\"formchangePw\" value=\"on\"></td>" << endl;
	cout << "<td width=\"100\"><input type=\"submit\" name=\"action\" \
			value=\"   &Auml;ndern   \"></td></tr>" << endl;
	cout << "</form></table>" << endl;

}

// Die HTML Ausgabe der Login Maske 
void cl_printhtml::print_contentLogin()
{
	cout << "<p class=\"title\">Login</p>" << endl;
	print_line();
    cout << "<p class=\"subtitle\">Bitte Benutzerdaten eingeben.</p>" << endl;
 	cout << "<table><tr>" << endl;
	cout << "<form action=\"loege\" method=\"Post\" name=\"Login\">" << endl;
	cout << "<td width=\"100\">Benutzername</td>" << endl;
  	cout << "<td><input type=\"text\" name=\"formUsername\" size=\"30\"></td></tr>" << endl;
	cout << "<tr><td width=\"100\">Passwort</td>" << endl;
  	cout << "<td><input type=\"password\" name=\"formPassword\" size=\"30\"></td></tr>" << endl;
    cout << "<tr><td width=\"100\">Neuer Benutzer</td>" << endl;

    // Falls die folgende Checkbox true ist, wird ein Neuer Benutzer angelegt
	cout << "<td><input type=\"checkbox\" name=\"formNewUser\"></td></tr>" << endl;
   	cout << "<tr><td width=\"100\">&nbsp;</td></tr><tr>" << endl;
	cout << "<td width=\"100\"><input type=\"hidden\" name=\"showform\" value=\"\"></td>" << endl;
	cout << "<td><input type=\"submit\" name=\"action\" value=\"   Einloggen   \"></td></tr>" << endl;
	cout << "</form></table>" << endl;
}

// Ruft die Methode setUser aus cl_login auf
void cl_printhtml::add_user()
{
	// Objekt ein_login der Klasse cl_login erstellen
	 cl_login ein_login;

	// Nur Ausfuehren, wenn ein neuer Benutzer angelegt werden soll.
     if(m_formNewUser == "on" )
     {
	   	// TODO
     	// Ungueltige Zeichen im Benutzername und Passwort abfangen (" ; usw)
		if(m_formUsername == "" || m_formPassword == "")
		{
	       	cout << "<p class=\"error\">Benutzername/Passwort ung&uuml;ltig \
         		oder Benutzer bereits vorhanden.</p>" << endl;
          	print_line();
		}
		else
		{
			//setUser gibt bei Erfolg true zurueck
    		if(ein_login.setUser(m_formUsername,m_formPassword))
	     	{
	      		cout << "<p class=\"good\">Benutzer \
	   		     	" << m_formUsername << " wurde erfolgreich angelegt.</p>" << endl;
	        	 print_line();
    	    }
	        else
	        {
		       	cout << "<p class=\"error\">Benutzername/Passwort ung&uuml;ltig \
     		    	oder Benutzer bereits vorhanden.</p>" << endl;
	         	print_line();
	      	}
	    }
    }
}

// Ruft die Methode delUser aus cl_login auf
void cl_printhtml::del_user()
{
	// Objekt ein_login der Klasse cl_login erstellen
	cl_login ein_login;

	// Nur Ausfuehren, wenn ein Benutzer geloescht werden soll.
	if(m_formDelUser == "on" )
    {
    	//delUser gibt bei Erfolg true zurueck
    	if(ein_login.delUser(m_formUsername,m_formPassword))
     	{
			cout << "<p class=\"good\">Benutzer \
	        	" << m_formUsername << " wurde erfolgreich gel&ouml;scht.</p>" << endl;
	     }
	     else
	     {
		  	cout << "<p class=\"error\">Benutzer \
        	 	" << m_formUsername << " konnte nicht gel&ouml;scht werden.</p>" << endl;
	     }
    }
}

// Ruft die Methode changePw aus cl_login auf
void cl_printhtml::change_Pw()
{
	// Objekt ein_login der Klasse cl_login erstellen
	cl_login ein_login;

	// Nur Ausfuehren, wenn ein Passwort gesetzt werden soll.
	if(m_formchangePw == "on")
    {
    	if(m_formchangePwW1 == m_formchangePwW2 && m_formchangePwW1 != "")
     	{
    		if(ein_login.changePw(m_formUsername,m_formPassword,m_formchangePwW1))
     		{
	    		cout << "<p class=\"good\">Passwort von Benutzer \
	     	  		" << m_formUsername << " wurde erfolgreich gesetzt.</p>" << endl;
		    	print_line();
	     	}
	     	else
	     	{
		  		cout << "<p class=\"error\">Passwort von Benutzer \
        		 	" << m_formUsername << " konnte nicht gesetzt werden.</p>" << endl;
		 	}
		 }
		 else
		 {
		  	cout << "<p class=\"error\">Passw&ouml;rter stimmen nicht &uuml;berein\
		   			oder sind ung&uuml;ltig.</p>" << endl;
		 }
     }
}

// Login Daten des Benutzers ueberpruefen. Wird bei jedem Aufruf von loege ausgefuehrt.
void cl_printhtml::check_user()
{
	cl_login ein_login;

	//getLogin gibt bei Erfolg true zurueck
	if(ein_login.getLogin(m_formUsername,m_formPassword))
	{
		// Falls User authentifiziert ist, gewuenschte Seite ausgeben
	 	if(m_showform == "")
		{
			print_contentWelcome();
		}
	   	else if(m_showform == "lernen")
	    {
	    	print_contentLernen();
	    }
	   	else if(m_showform == "lernenSet")
	    {
	    	print_contentLernenSet();
	    }
	    else if(m_showform == "erfassen")
    	{
	    	print_contentErfassen();
	    }
	    else if(m_showform == "dictionary")
	    {
	    	print_contentDictionary();
	    }
	    else if(m_showform == "einstellungen")
	    {
	    	print_contentEinstellungen();
	    }
	    else if(m_showform == "hilfe")
	    {
	    	print_contentHilfe();
	    }
		else
		{
	   		print_contentError();
	   	}
	}
	else
	{
		print_contentLogin();
	}
}

// Ruft getEnWord rsp. getDeWord aus cl_search auf
void cl_printhtml::query_dict()
{
	cl_search eineSuche;

	// Nur ausfuehren, wenn User den Dictionary benutzt
	if(m_formSearchWord == "on" )
    {
    	// Zu gewuenschter Spache Suchfunktion aufrufen
    	if(m_formDixLang == "De-En")
     	{
			m_formDictionaryResult = eineSuche.getEnWord(m_formDictionarySearch);
		}
		else
		{
			m_formDictionaryResult = eineSuche.getDeWord(m_formDictionarySearch);
		}

		// Resultate der Suche ausgeben.
		if(m_formDictionaryResult == "Suchwort nicht gefunden")
		{
			cout << "<p class=\"error\">" << m_formDictionaryResult << "</p>" << endl;
		}
		else
		{
			cout << "<p class=\"good\">" << m_formDictionaryResult << "</p>" << endl;
		}
	}
}

// Ruft setDEWord aus cl_learn auf
void cl_printhtml::set_word()
{
	// Objekt einLearn der Klasse cl_learn erstellen.
	cl_learn einLern;

	// Nur ausfuehren, wenn User ein Wort setzen will
	if(m_formSetWord == "on" )
    {
    	// Erfassen von leeren Werten verhindern
    	if(m_formErfassenDeutsch != "" && m_formErfassenEnglish != "")
     	{
    		if(einLern.setDEWord(m_formErfassenDeutsch,m_formErfassenEnglish,m_formErfassenUnit,m_formUsername))
			{
				cout << "<p class=\"good\">Das Wortpaar wurde erfolgreich erfasst.</p>" << endl;
			}
			else
			{
				cout << "<p class=\"error\">Fehler beim Schreiben des Wortpaares.</p>" << endl;
			}
		}
		else
		{
			cout << "<p class=\"error\">Ung&uuml;ltige Eingabe.</p>" << endl;
		}
	}
}			


// Setzt den Status aller Woerter in der Wortliste auf false zurueck
void cl_printhtml::set_wordBack()
{
	// Objekt einUserfile der Klasse cl_userfile erstellen.
	cl_userfile einUserfile;

	// Nur ausfuehren, wenn User ein Wort setzen will
	if(m_formSetWordBack == "on" )
    {

		// Einige der Werte der &Uuml;bergabeparameter sind nicht kompatibel.
		string str_lang = "DE_EN";
		string str_user = m_formUsername;
		string str_word = "egal";
		string str_stat = "";
		string str_resall = "yes";

		einUserfile.setLearnFlag(str_lang,str_user,str_word,str_stat,str_resall);
		cout << "<p class=\"good\">Die Wortliste wurde erfolgreich zur&uuml;ckgesetzt.</p>" << endl;

	}
}


// Wort aus Methode getWord2Learn "holen"
void cl_printhtml::get_word()
{
	// Objekt einLearn der Klasse cl_learn erstellen.
	cl_learn einLearn;

	if(m_formGetWord == "on" )
	{
		// Bugfix. Einige der Werte der &Uuml;bergabeparameter sind nicht kompatibel.
		string str_unit = m_formLernenUnit;
		string str_lang;
		string str_user = m_formUsername;
		string str_stat;

		if(str_unit != "Alle")
		{
			// Leerzeichen von HTML Form entfernen
			str_unit.erase(1,1);
		}
		
		if(m_formLernenLang == "De-En")
		{str_lang = "DE_EN"; }
		if(m_formLernenLang == "En-De")
		{str_lang = "EN_DE"; }

		if(m_formLernenWord == "Nicht Gewusste")
		{str_stat = "false"; }
		if(m_formLernenWord == "Gewusste")
		{str_stat = "true"; }
		if(m_formLernenWord == "Alle")
		{str_stat = ""; }

		m_formLernenQuestion = einLearn.getWord2Learn(str_unit,str_lang,str_user,str_stat);

		if(m_formLernenQuestion != "")
		{
			cout <<	"<p class=\"good\">" << m_formLernenQuestion << "</p>" << endl;
		}
		else
		{
			cout <<	"<p class=\"error\">Mit diesen Optionen ist kein Wort verf&uuml;gbar.</p>" << endl;
		}
	}	
}


// Worter fuer Maske lernen vergleichen und Status ausgeben.
void cl_printhtml::check_word()
{
	// Objekt einLearn der Klasse cl_learn erstellen.
	cl_learn einLearn;

	if(m_formCheckWord == "on" )
	{
		// Bugfix. Einige der Werte der &Uuml;bergabeparameter sind nicht kompatibel.
		string str_lang;
		string str_user = m_formUsername;
		string str_Word = m_formLernenQuestion;
		string str_RWord = m_formLernenAnswer;

		if(m_formLernenLang == "De-En")
		{str_lang = "DE_EN"; }
		if(m_formLernenLang == "En-De")
		{str_lang = "EN_DE"; }
		
		m_formLernenStatusRes = einLearn.getResult(str_lang,str_Word,str_RWord,str_user);
		
		cout << "<table><tr>" << endl;
		cout << "<td width=\"100\">Wort gewusst</td><td>" << endl;
		
		if(m_formLernenStatusRes == "SUCCESS")
		{
			cout <<	"<p class=\"good\">Ja. <font color=\"ffffff\">Das Wort </font>"
				 << m_formLernenQuestion << " <font color=\"ffffff\">stimmt \
					mit dem Wort </font>" << m_formLernenAnswer
					<< " <font color=\"ffffff\">&uuml;berein.</font></p>" << endl;
		}
		else
		{
			cout <<	"<p class=\"error\">Nein. <font color=\"ffffff\">Das Wort </font>"
				 << m_formLernenQuestion << " <font color=\"ffffff\">stimmt \
					mit dem Wort </font>" << m_formLernenAnswer
					<< " <font color=\"ffffff\">nicht &uuml;berein.</font></p>" << endl;
		}

		cout << "</td></tr><tr><td width=\"100\">Richtige L&ouml;sung</td>" << endl;
		cout << "<td><p class=\"good\">" << einLearn.getRightWord() << "</p></td>" << endl;
		cout << "</tr></table>" << endl;

	}
}


