/**********************************************************************
 *  Demonstrationsprogramm USRCOOR2                                   *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Es wird der Funktionsgraph einer mathematischen Funktion          *
 *  gezeichnet.                                                       *
 *                                                                    *
 *  Das Programm demonstriert die "gi_win"-Funktionen vrect_gi        *
 *  (Zeichnen eines Rechteckrahmens mit "Viewport Coordinates"),      *
 *  stuci_gi (Definieren von "User Coordinates" mit ISOTROPER         *
 *  SKALIERUNG der beiden Koordinatenrichtungen) und umove_gi und     *
 *  uline_gi (Zeichenaktionen unter Verwendung von "User              *
 *  Coordinates").                                                    *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

HANDLE   hActInstance   ;  /* ... ist der an WinMain uebergebene Handle */ 

int      nViewpx = 4 , nViewpy = 2 ;

LRESULT CALLBACK WndProc    (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProc (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "USRCOOR2" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     double         x , pmarg = 0. ;
     int            width , height ;
     static FARPROC Ptr2DialogProc ;
     HDC            hdc ;
     long           ix , iy ;                            

     switch (message)
        { 
          case WM_CREATE : 
          
               Ptr2DialogProc = MakeProcInstance (DialogProc , hActInstance) ; 
               return 0  ;
                      
	      case WM_COMMAND:
 
             if (wParam == 100)                 
                 {             
                   if (DialogBox (hActInstance , "USRCOOR2" , hwnd , Ptr2DialogProc))
                     InvalidateRect (hwnd , NULL , TRUE) ; /* ... weil beim Verlassen
                               der Dialogbox ueber die Schaltflaeche "OK" (Function 
                               DialogBox liefert TRUE ab) die Parameter wahrscheinlich
                               geaendert wurden                                      */
                   return 0 ;
                 }                                                        
                 
             break ;    
                  
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;  /* ... sind die Abmessungen (Pixel) des */
               cyClient = HIWORD (lParam) ;  /*     Zeichen-Fensters                 */

               return 0 ; 
               
          case WM_PAINT :                       
          
               hdc     = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               width  = cxClient / nViewpx  - 2 ; /* ... etwas kleiner fuer die Rahmen  */  
               height = cyClient / nViewpy  - 2 ; /*     um die Viewports               */
               
               for (iy = 0 ; iy < nViewpy ; iy++)
                {
                 for (ix = 0 ; ix < nViewpx ; ix++)
                   {
                     stcvp_gi (hdc , (int) (cxClient * ix / nViewpx) + 1 , 
                                     (int) (cyClient * iy / nViewpy) + 1 , 
                                     width , height , GI_XYBOTTOMLEFT) ;    
                        /* ... definiert den "Current Viewport" mit einem (Geraete-)
                               Viewport-Koordinatensystem in der linken unteren Ecke    */           
                            
                     vrect_gi (hdc , 0 , 0 , width - 1 , height - 1 ) ;
                        /* ... zeichnet einen Rahmen um den Viewport                    */       
                      
                     if (ix == 0) stuci_gi ( 0. , -3.5 , 10.5 , 4.5 , pmarg) ;
                        /* ... definiert "User Coordinates": Punkt (0;-3.5) wird auf die
                               linke untere Viewport-Ecke gelegt, Punkt (10.5;4.5) auf
                               die rechte obere Ecke, wenn dabei allerdings eine
                               unterschiedliche Skalierung in den beiden Richtungen
                               entsteht, werden in einer Richtung die beiden Punkte 
                               (symmetrisch) zur Mitte verschoben, im Durchlauf mit ix=0
                               (obere Reihe) gilt pmarg=0. (kein Rand), danach pmarg=10.*/                          
                     if (ix == 1) stuci_gi ( 0. ,  4.5 , 10.5 , -3.5 , pmarg) ;
                     if (ix == 2) stuci_gi (10. ,  4.5 ,  0.  , -3.5 , pmarg) ;
                     if (ix >= 3) stuci_gi (10. , -3.5 ,  0.  ,  4.5 , pmarg) ;
                        /* ... und in den ersten vier Viewports einer Reihe sind alle
                               vier Kombinationen fuer die Richtungen der beiden
                               Koordinatenachsen realisiert                             */
                                                       
                     umove_gi (hdc ,  0.  ,  4.5) ;                                   
                     uline_gi (hdc ,  0.  , -3.5) ;  /* Horizontale Linie als x-Achse   */                                 
                     umove_gi (hdc ,  0.  ,  0. ) ;                                   
                     uline_gi (hdc , 10.5 ,  0. ) ;  /* Vertikale Linie als y-Achse     */
                                                        
                     umove_gi (hdc , 0. ,  4. ) ;    /* Startpunkt fuer Funktionsgraph  */
                                                    
                     for (x = 0.05 ; x <= 10. ; x += 0.05)
                       {     
                         /*                    -x/5
                              Funktion  y = 4 e   cos 3x :                              */
                         uline_gi (hdc , x , 4. * exp (-.2 * x) * cos (3. * x)) ;
                       }
                     
                   }
                    
                 pmarg = 10. ;                        /* ... untere Reihe mit 10% Rand  */
                }
                
               gstop_gi (hwnd) ;  
               return 0 ;

          case WM_DESTROY : 
          
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

BOOL CALLBACK DialogProc (HWND   hDlg   , UINT   message ,
                          WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       
  char    *end_p ;
  int     n ;

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12i" , nViewpx) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      sprintf (StrBuff , "%12i" , nViewpy) ;
      SetDlgItemText (hDlg , 410 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            n = (int) strtol (StrBuff , &end_p , 10) ;
            if (*end_p == '\0') nViewpx = n ;
    
            GetDlgItemText (hDlg , 410 , StrBuff , 15) ; 
            n = (int) strtol (StrBuff , &end_p , 10) ;
            if (*end_p == '\0') nViewpy = n ;
    
            EndDialog (hDlg , TRUE) ; 
            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 
            return TRUE ;
        }
  }
  return FALSE ;
}
