/**********************************************************************
 *  Demonstrationsprogramm PROJEC1                                    *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Es wird der Einsatz der GIW-Routinen fuer die Darstellung von     *
 *  3D-Objekten demonstriert ("pr...-Funktionen):                     *
 *                                                                    *
 *  * Mit prini_gi werden alle 3D-Projektionsparameter initialisiert, *
 *    eingestellt wird eine Parallelprojektion.                       *
 *                                                                    *
 *  * Die eingestellten Parameter ("Eye Point" fuer Zentralprojektion *
 *    und "Vektor der Blickrichtung fuer Parallelprojektion,          *
 *    Referenzpunkt der Projektionsebene fuer beide Projektionen)     *
 *    werden mit prgte_gi , prgtd_gi und prgtr_gi erfragt und         *
 *    globalen Variablen zugewiesen, so dass sie in Dialog-Funktionen *
 *    zugaenglich sind und geaendert werden koennen.                  *
 *                                                                    *
 *  * Mit prgtp_gi wird (bei der Bearbeitung von WM_PAINT) der        *
 *    eingestellte Projektionstyp erfragt und in das Fenster          *
 *    geschrieben. Mit prmov_gi und prlin_gi werden drei gerade       *
 *    Linien (unterschiedlicher Farben) gezeichnet, die auf den       *
 *    Achsen des 3D-Koordinatensystems liegen.                        *
 *                                                                    *
 *  * Ueber Dialoge koennen die Parameter und der Projektionstyp      *
 *    geaendert werden. Dafuer werden die Funktionen projn_gi         *
 *    (Aenderung des Projektionstyps), prste_gi und prstd_gi          *
 *    (Aenderung des "Eye Points" bzw. des "Blickrichtungsvektors",   *
 *    beide Funktionen aendern gegebenenfalls auch den Projektions-   *
 *    typ) und prstr_gi (Aenderung des Referenzpunktes der            *
 *    Projektionsebene) benutzt.                                      *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <stdio.h>
#include <stdlib.h>                                   

double  xwe , ywe , zwe ;          /* Koordinaten des "Eye Points"    */
double  xwr , ywr , zwr ;          /* Koordinaten des Referenzpunktes */
double  xwd , ywd , zwd ;          /* Koordinaten der "Blickrichtung" */

HINSTANCE  hActInstance ;

LRESULT CALLBACK WndProc      (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcE  (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcD  (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcR  (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance    , HINSTANCE hPrevInstance ,
                    LPSTR     lpszCmdParam , int       nCmdShow)  
{
     static char szAppName [] = "PROJEC1" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , "3D-Projektion" , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     static HPEN    hPenRed  , hPenBlue ;
     HDC            hdc ;

     switch (message)
        { 
          case WM_CREATE : 
          
             prini_gi () ;                    /* ... initialisiert Projektionen      */
             prgte_gi (&xwe , &ywe , &zwe) ;  /* ... liefert "Eye Point"             */
             prgtr_gi (&xwr , &ywr , &zwr) ;  /* ... liefert Referenzpunkt           */
             prgtd_gi (&xwd , &ywd , &zwd) ;  /* ... liefert "Blickrichtungs"-Vektor */
             
             hPenRed  = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_RED)) ;
             hPenBlue = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_BLUE)) ;
               
             return 0 ; 

	      case WM_COMMAND:
             
             switch (wParam)
               { 
                 case 100:                            /* ... aendert Projektionstyp: */          
                               
                   if   (prgtp_gi () == GI_CENTRAL) projn_gi (GI_PARALLEL) ;
                   else                             projn_gi (GI_CENTRAL)  ;

                   InvalidateRect (hwnd , NULL , TRUE) ;

                   return 0 ;
                                                                         
                 case 200:                            /* "Eye Point" aendern:        */    
                               
                   if (DialogBox (hActInstance , "EYEPOINT" , hwnd , 
                       MakeProcInstance (DialogProcE , hActInstance)))
                     {
                        if (!prste_gi (xwe , ywe , zwe))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 300:                            /* "Blickrichtung" aendern:    */     
                               
                   if (DialogBox (hActInstance , "BLICKRICHTUNG" , hwnd , 
                       MakeProcInstance (DialogProcD , hActInstance)))
                     {
                        if (!prstd_gi (xwd , ywd , zwd))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 400:                             /* "Referenzpunkt" aendern:   */    
                               
                   if (DialogBox (hActInstance , "REFERENZ" , hwnd , 
                       MakeProcInstance (DialogProcR , hActInstance)))
                     {
                        if (!prstr_gi (xwr , ywr , zwr))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 500:                      /* Zurueck zur Standard-Einstellung: */  
                               
                   prini_gi () ;               
                   prgte_gi (&xwe , &ywe , &zwe) ;
                   prgtr_gi (&xwr , &ywr , &zwr) ;
                   prgtd_gi (&xwd , &ywd , &zwd) ;

                   InvalidateRect (hwnd , NULL , TRUE) ;

                   return 0 ;
                }
                 
             break ;    
                  
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ; 

               return 0 ; 
               
          case WM_PAINT :                       

               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               if (prgtp_gi () == GI_CENTRAL)
                 TextOut (hdc , 10 , 10 , "Zentralprojektion   " , 20); 
               else  
                 TextOut (hdc , 10 , 10 , "Parallelprojektion  " , 20); 

               stuci_gi (- 15. , - 5. , 15. , 10. , 0.) ; 
               
               prmov_gi (hdc , -5. ,  0. ,  0.) ;
               prlin_gi (hdc , 10. ,  0. ,  0.) ;
               
               SelectObject (hdc , hPenRed) ;
               prmov_gi (hdc ,  0. , -5. ,  0.) ;
               prlin_gi (hdc ,  0. , 10. ,  0.) ;

               SelectObject (hdc , hPenBlue) ;
               prmov_gi (hdc ,  0. ,  0. , -5.) ;
               prlin_gi (hdc ,  0. ,  0. , 10.) ;
                     
               gstop_gi (hwnd) ;  

               return 0 ;

          case WM_DESTROY :                         
          
               DeleteObject (hPenRed)  ;
               DeleteObject (hPenBlue) ;
          
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

BOOL CALLBACK DialogProcE (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwe) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywe) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwe) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwe = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywe = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwe = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}

BOOL CALLBACK DialogProcD (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwd) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywd) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwd) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwd = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywd = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwd = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}

BOOL CALLBACK DialogProcR (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwr) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywr) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwr) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwr = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywr = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwr = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}
