/**********************************************************************
 *  Demonstrationsprogramm MARKER                                     *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Es wird die Funktion umark_gi (Zeichnen eines Markers mit Hilfe   *
 *  von "User Coordinates") demonstriert.                             *
 *                                                                    *
 *  Die Marker werden mit Zufallszahlen im Fenster plaziert, die      *
 *  Zufallszahlen bestimmen auch Markergroesse und Markertyp (und     *
 *  die Farben) nach folgendem Prinzip: Am unteren Fensterrand        *
 *  wird Markertyp 1 (Kreis), am oberen Fensterrand Markertyp 7       *
 *  gefuelltes Quadrat) gezeichnet. Die Markergroesse steigt vom      *
 *  linken zum rechten Fensterrand an, am linken Rand gilt msize = 0  *
 *  (es wird die minimale Groesse mit einem "Offset" von einem Pixel  *
 *  gezeichnet, "Offset" ist der Abstand von Markermitte bis zu       *
 *  einem Rand des umschliessenden Quadrats),                         *
 *  am rechten Rand msize = 2, in der Mitte wird die Standard-Marker- *
 *  groesse (msize = 1) gezeichnet.                                   *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define  NMARK  2000       /* Anzahl der zu zeichnenden Marker  */

HANDLE   hActInstance   ;  /* ... ist der an WinMain uebergebene Handle */ 
                                      
LRESULT CALLBACK WndProc (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "MARKER" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}


LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     int            i , mtype ;
     double         msize , xs , ys , rand1 , rand2 ;
     static FARPROC Ptr2DialogProc ;
     HDC            hdc ;    
     static HBRUSH  hBrush [8] ;
     static HPEN    hPen   [8] ;

     switch (message)
        { 
          case WM_CREATE :
               
               for (i = 0 ; i < 8 ; i++)
                 {
                    hPen   [i] = CreatePen (PS_SOLID , 1 , mkrgb_gi (i)) ;
                    hBrush [i] = CreateSolidBrush (mkrgb_gi (i)) ;
                 }
               /* ... stellt 8 "Zeichenstifte" und 8 "Brushs" (fuer die 
                      "gefuellten Markertypen") bereit, die mit den von
                       mkrgb_gi gelieferten 8 Grundfarben arbeiten      */

               return 0 ; 

          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;  /* ... sind die Abmessungen (Pixel) des */
               cyClient = HIWORD (lParam) ;  /*     Zeichen-Fensters                 */

               return 0 ; 
               
          case WM_PAINT :                       
          
               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
              
               for (i = 1 ; i <= NMARK ; i++)
                 {                 
                    rand1 = (double) rand () / RAND_MAX ;
                    rand2 = (double) rand () / RAND_MAX ;
                    /* ... die erzeugten Zufallszahlen liegen im Bereich 0...1 */
                
                    xs    = (int) (rand1 * cxClient) ;
                    ys    = (int) (rand2 * cyClient) ;  
                    
                    mtype = (int) (rand2 * 7) + 1 ;
                    msize = rand1 * 2. ;   
                    /* ... und Zufallszahl rand1 bestimmt die horizontale
                           Koordinate und die Markergroesse, Zufallszahl rand2
                           die vertikale Koordinate und den Markertyp          */

                    rand1 = (double) rand () / RAND_MAX ;
                    rand2 = (double) rand () / RAND_MAX ;
                    /* ... sind neue Zufallszahlen fuer die Farbauswahl, damit
                           es "schoen bunt" wird                               */
                           
                    SelectObject (hdc , hPen   [(int) (rand1 * 8.)]) ;                            
                    SelectObject (hdc , hBrush [(int) (rand2 * 8.)]) ;                            
                       
                    umark_gi (hdc , mtype , msize , xs , ys , 0) ;
                 }
                           
               gstop_gi (hwnd) ;  
               
               return 0 ;

          case WM_DESTROY : 
                            
               for (i = 0 ; i < 8 ; i++)
                 {
                    DeleteObject (hPen   [i]) ;
                    DeleteObject (hBrush [i]) ;
                 }
          
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}
