/**********************************************************************
 *  Demonstrationsprogramm MALTESR0                                   *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Das Programm demonstriert die Verwendung der "t-Funktionen"       *
 *  der GIW-Library.                                                  *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <math.h>

void DrawCross (HDC hdc) ;
void DrawPivot (HDC hdc , double y) ;

HANDLE   hActInstance   ;   

const double  L = 60. , R = 30. ; 
double        Rc , Rs , Pi , xA , yA , yB , Rm ;
HBRUSH  hBrushBlue , hBrushCyan , hBrushBlack , hBrushYellow ;
HPEN    hPenWhite  , hPenBlue   , hPenBlack   ;
                                      
LRESULT CALLBACK WndProc (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "Malteserkreuz" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}


LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     HDC            hdc ;
               
     switch (message)
        { 
          case WM_CREATE:                            
               
               Pi = atan (1.) * 4. ;
               Rc = R * .75 ;
               Rs = R * .15 ;
               xA = Rc * sin (Pi / 3.) ;
               yA = L - Rc * cos (Pi / 3.) ;
               yB = L + Rc * cos (Pi / 3.) ;
               Rm = sqrt (L * L - R * R) ;
               
               hBrushBlue   = CreateSolidBrush (mkrgb_gi (GI_BLUE))   ;
               hBrushCyan   = CreateSolidBrush (mkrgb_gi (GI_CYAN))   ;
               hBrushBlack  = CreateSolidBrush (mkrgb_gi (GI_BLACK))  ;
               hBrushYellow = CreateSolidBrush (mkrgb_gi (GI_YELLOW)) ;
               hPenWhite    = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_WHITE)) ;
               hPenBlue     = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_BLUE))  ;
               hPenBlack    = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_BLACK)) ;
               
               return 0 ; 
               
          case WM_SIZE:
          
               cxClient = LOWORD (lParam) ;        /* Abmessungen (Pixel) der    */
               cyClient = HIWORD (lParam) ;        /* "Client Area"              */

               return 0 ; 
                      
          case WM_PAINT :                       
                            
               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               SelectObject (hdc , hPenWhite)  ;                                             
               SelectObject (hdc , hBrushBlue) ;                                             
            
               vfrec_gi (hdc , 0 , 0 , cxClient - 1 , cyClient - 1) ;
               stuci_gi (- L , - L , L , L + R + Rs , 5.) ;
               
               tinit_gi () ;                   /* Transformation initialisieren */
               DrawCross (hdc)      ;          /* Malteserkreuz zeichnen        */
                     
               DrawPivot (hdc , 0.) ;
               DrawPivot (hdc , L)  ;
                           
               gstop_gi (hwnd) ;      
                                 
               return 0 ;

          case WM_DESTROY : 
                              
               DeleteObject    (hBrushBlue)   ;               
               DeleteObject    (hBrushCyan)   ;               
               DeleteObject    (hBrushBlack)  ;               
               DeleteObject    (hBrushYellow) ;               
               DeleteObject    (hPenWhite)    ;
               DeleteObject    (hPenBlue)     ;
               DeleteObject    (hPenBlack)    ;
                             
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

void DrawCross (HDC hdc)
{
/* int  i ;
   
   for (i = 0 ; i < 6 ; i++)  */
     {
        tdarc_gi (hdc , 0. , L , Rc , - xA , yA , xA , yA) ;
        tmove_gi (hdc , xA , yA) ;
        trota_gi (0.  , 0. , - Pi / 6.) ;   /* ... um 30 drehen     */
        tline_gi (hdc , - Rs , Rm) ;
        tline_gi (hdc , - Rs , L - R) ;
        tdarc_gi (hdc , 0. , L - R , Rs , - Rs , L - R , Rs , L - R) ;
        tmove_gi (hdc , Rs , L - R) ;
        tline_gi (hdc , Rs , Rm) ;
        trota_gi (0.  , 0. , - Pi / 6.)  ;  /* ... noch einmal 30   */
        tline_gi (hdc , - xA , yA) ;
     }
}

void DrawPivot (HDC hdc , double y)
{       
        SelectObject (hdc , hBrushBlack) ;                                             
        SelectObject (hdc , hPenBlack)   ;                                             
        ufsec_gi     (hdc , 0. , y , Rs , 0. , y + Rs , - Rs , y) ;
        ufsec_gi     (hdc , 0. , y , Rs , 0. , y - Rs ,   Rs , y) ;
        SelectObject (hdc , hBrushYellow) ;                                             
        ufsec_gi     (hdc , 0. , y , Rs ,   Rs  , y , 0. , y + Rs) ;
        ufsec_gi     (hdc , 0. , y , Rs , - Rs  , y , 0. , y - Rs) ;
}