/**********************************************************************
 *  Demonstrationsprogramm MALTESER                                   *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Das Programm demonstriert die Verwendung der "t-Funktionen"       *
 *  der GIW-Library, die nach folgendem Prinzip arbeiten:             *
 *                                                                    *
 *  Es wird eine ebene Transformation (Matrix, die sich auf homogene  *
 *  Koordinaten bezieht) definiert. In diesem Programm werden dafuer  *
 *  die Funktionen tinit_gi, trota_gi, ttabs_gi, tsttm_gi, tgttm_gi   *
 *  und tmiry_gi verwendet. Beim Aufruf der mit "User Coordinates"    *
 *  arbeitenden "zeichnenden t-Funktionen" werden alle uebergebenen   *
 *  Punkt-Koordinaten vor ihrer Verwendung der aktuellen Transfor-    *
 *  mation unterworfen. In diesem Programm werden die Funktionen      *
 *  tmove_gi, tline_gi, tdarc_gi und tfcir_gi verwendet.              *
 *                                                                    *
 *  In den Funktionen DrawCross und DrawCrank wird gezeigt, wie man   *
 *  eine symmetrische Zeichnung (durch "Spiegeln") bzw. eine          *
 *  Zeichnung, die durch einen mehrfach verwendeten Sektor definiert  *
 *  ist, (unter Verwendung von Rotations-Transformationen) mit        *
 *  Vorteil unter Verwendung der "t-Funktionen" gezeichnet werden     *
 *  kann.                                                             *
 *                                                                    *
 *  Die Auswertung der Botschaft WM_TIMER zeigt, wie man mit den      *
 *  "t-Funktionen" eine einfache Animation programmieren kann.        *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <math.h>

void DrawCross (HDC hdc) ;
void DrawCrank (HDC hdc) ;
void DrawPivot (HDC hdc , double y) ;

HANDLE   hActInstance   ;   

const double  L = 60. , R = 30. ; 
double  Rc , Rs , Pi , xA , yA , yB , Rm , OmT , Phi , dOmT ;
HBRUSH  hBrushBlue , hBrushCyan , hBrushBlack , hBrushYellow ;
HPEN    hPenWhite  , hPenBlue   , hPenBlack   ;
                                      
LRESULT CALLBACK WndProc (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "Malteserkreuz" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;
                          
     while (!SetTimer (hwnd , 1 , 50 , NULL))
        if (IDCANCEL == MessageBox (hwnd , "Kein Timer verfgbar!" ,
                        szAppName , MB_ICONSTOP | MB_RETRYCANCEL)) return FALSE ;                    

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}


LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     HDC            hdc ;
     static double  tm_cross [9] , tm_crank [9] ;
               
     switch (message)
        { 
          case WM_CREATE:                            
               
               Pi = atan (1.) * 4. ;
               Rc = R * .75 ;
               Rs = R * .15 ;
               xA = Rc * sin (Pi / 3.) ;
               yA = L - Rc * cos (Pi / 3.) ;
               yB = L + Rc * cos (Pi / 3.) ;
               Rm = sqrt (L * L - R * R) ;
               
               hBrushBlue   = CreateSolidBrush (mkrgb_gi (GI_BLUE))   ;
               hBrushCyan   = CreateSolidBrush (mkrgb_gi (GI_CYAN))   ;
               hBrushBlack  = CreateSolidBrush (mkrgb_gi (GI_BLACK))  ;
               hBrushYellow = CreateSolidBrush (mkrgb_gi (GI_YELLOW)) ;
               hPenWhite    = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_WHITE)) ;
               hPenBlue     = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_BLUE))  ;
               hPenBlack    = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_BLACK)) ;
               
               return 0 ; 
               
          case WM_TIMER:     

               hdc  = GetDC (hwnd) ;
               
               SelectObject (hdc , hPenBlue)   ;   /* ... fuer Ueberzeichnen     */                                          
               SelectObject (hdc , hBrushBlue) ;   /* ... fuer Ueberzeichnen     */                                          
               tsttm_gi     (tm_crank) ;           /* Transformation fuer Kurbel */
               DrawCrank    (hdc) ;                /* Kurbel ueberzeichnen       */

               OmT += dOmT ;
               if (OmT > Pi * 1.5) OmT -= Pi * 2. ;
               
               if (OmT > - Pi / 3. && OmT < Pi / 3.) /* Kurbel im Eingriff       */
                   Phi = - atan2 (sin (OmT) , L / R - cos (OmT)) - Pi / 6. ; 
               else                                /* Kreuz in Ruhe              */
                   SelectObject (hdc , hPenWhite)   ;                                             

               tsttm_gi     (tm_cross) ;           /* Transformation fuer Kreuz  */
               DrawCross    (hdc) ;                /* Kreuz ueberzeichnen        */

               SelectObject (hdc , hPenWhite)  ;   /* ... fuer Neuzeichnen       */                                          
               SelectObject (hdc , hBrushCyan) ;   /* ... fuer Neuzeichnen       */                                          
               tsttm_gi     (tm_crank) ;           /* Transformation fuer Kurbel */
               trota_gi     (0. , L , dOmT) ;      /* mit zusaetzlicher Drehung  */
               DrawCrank    (hdc) ;                /* Kurbel neu zeichnen        */
               tgttm_gi     (tm_crank) ;           /* Transformation sichern     */

               SelectObject (hdc , hPenWhite)  ;                                             
               ttabs_gi     (0.  , 0. , Phi , 1. , 1. ) ;  
                                                   /* Transformation fuer Kreuz  */
               DrawCross    (hdc) ;                /* Kreuz neu zeichnen         */
               tgttm_gi     (tm_cross) ;           /* Transformation sichern     */

               ReleaseDC (hwnd , hdc) ;
     
               return 0 ; 
        
          case WM_SIZE:
          
               cxClient = LOWORD (lParam) ;        /* Abmessungen (Pixel) der    */
               cyClient = HIWORD (lParam) ;        /* "Client Area"              */

               return 0 ; 
                      
          case WM_PAINT :                       
                            
               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               SelectObject (hdc , hPenWhite)  ;                                             
               SelectObject (hdc , hBrushBlue) ;                                             
            
               vfrec_gi (hdc , 0 , 0 , cxClient - 1 , cyClient - 1) ;
               stuci_gi (- L , - L , 
                           L , L + R + Rs , 5.) ;
               
               DrawPivot (hdc , 0.) ;
               DrawPivot (hdc , L) ;
  
               gstop_gi (hwnd) ;      
                                 
               OmT     = - Pi * .5  ;
               Phi     =   0.       ;
               dOmT    =   Pi / 15. ;

               tinit_gi () ;              /* Transformation initialisieren       */
               tgttm_gi (tm_cross) ;      /* = Start-Transformation fuer Kreuz   */
               trota_gi (0. , L , OmT) ;  /* Transformation fuer Kurbel setzen   */
               tgttm_gi (tm_crank) ;      /* ... und sichern                     */
          
               return 0 ;

          case WM_DESTROY : 
                              
               DeleteObject    (hBrushBlue)   ;               
               DeleteObject    (hBrushCyan)   ;               
               DeleteObject    (hBrushBlack)  ;               
               DeleteObject    (hBrushYellow) ;               
               DeleteObject    (hPenWhite)    ;
               DeleteObject    (hPenBlue)     ;
               DeleteObject    (hPenBlack)    ;
               KillTimer       (hwnd , 1)     ;
                             
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

void DrawCross (HDC hdc)
{
   int  i ;
   
   for (i = 0 ; i < 6 ; i++)
     {
        tdarc_gi (hdc , 0. , L , Rc , - xA , yA , xA , yA) ;
        tmove_gi (hdc , xA , yA) ;
        trota_gi (0.  , 0. , - Pi / 6.) ;   /* ... um 30 drehen     */
        tline_gi (hdc , - Rs , Rm) ;
        tline_gi (hdc , - Rs , L - R) ;
        tdarc_gi (hdc , 0. , L - R , Rs , - Rs , L - R , Rs , L - R) ;
        tmove_gi (hdc , Rs , L - R) ;
        tline_gi (hdc , Rs , Rm) ;
        trota_gi (0.  , 0. , - Pi / 6.)  ;  /* ... noch einmal 30   */
        tline_gi (hdc , - xA , yA) ;
     }
}

void DrawCrank (HDC hdc)
{ 
     int i ;

     for (i = 0 ; i < 2 ; i++)
       {
        tmove_gi (hdc , xA , yB) ;
        tline_gi (hdc , xA * .7 , yB) ;
        tline_gi (hdc , Rs , L - R) ;
        trota_gi (0. , L , - OmT) ;  /* Bis zur y-Achse drehen, ...  */
        tmiry_gi () ;                /* Spiegeln an der y-Achse, ... */
        trota_gi (0. , L , OmT) ;    /* "Zurueckdrehen"              */
       } 
        
     tdarc_gi (hdc , 0. , L , Rc , xA , yB , - xA , yB) ;
     tfcir_gi (hdc , 0. , L - R , Rs) ;
}

void DrawPivot (HDC hdc , double y)
{       
        SelectObject (hdc , hBrushBlack) ;                                             
        SelectObject (hdc , hPenBlack)   ;                                             
        ufsec_gi     (hdc , 0. , y , Rs , 0. , y + Rs , - Rs , y) ;
        ufsec_gi     (hdc , 0. , y , Rs , 0. , y - Rs ,   Rs , y) ;
        SelectObject (hdc , hBrushYellow) ;                                             
        ufsec_gi     (hdc , 0. , y , Rs ,   Rs  , y , 0. , y + Rs) ;
        ufsec_gi     (hdc , 0. , y , Rs , - Rs  , y , 0. , y - Rs) ;
}