/**********************************************************************
 *  Header-Datei fuer die Einbindung der Library des Graphics-        *
 *  Interface "GIW"                                                   *
 *                                                                    *
 *  Autor: J. Dankert                                                 *
 **********************************************************************/ 
  
#include <windows.h>

#define DOUBLE_EPS  1.e-12
#define MARDIV_GI   20  /* Zur Festlegung des Standard-Marker-Offsets:    */
                        /* Offset = "1 Logical Inch" / MARDIV_GI          */                                

#define     GI_BLACK         0
#define     GI_BLUE          1
#define     GI_GREEN         2
#define     GI_CYAN          3
#define     GI_RED           4
#define     GI_MAGENTA       5
#define     GI_YELLOW        6
#define     GI_WHITE         7
#define     GI_TRANSPARENT  -1

#define     GI_TOPLEFT       1
#define     GI_BASELEFT      2
#define     GI_BOTTOMLEFT    3
#define     GI_TOPCENTER     4
#define     GI_BASECENTER    5
#define     GI_BOTTOMCENTER  6
#define     GI_TOPRIGHT      7
#define     GI_BASERIGHT     8
#define     GI_BOTTOMRIGHT   9

#define     GI_XYBOTTOMLEFT  0
#define     GI_XYCENTER      1
#define     GI_XYTOPLEFT     2
#define     GI_XYTOPRIGHT    3
#define     GI_XYBOTTOMRIGHT 4

#define     GI_MKCIRCLE      1
#define     GI_MKSQUARE      2
#define     GI_MKCROSS       3
#define     GI_MKVBAR        4
#define     GI_MKHBAR        5
#define     GI_MKFCIRCLE     6
#define     GI_MKFSQUARE     7

#define     GI_UPLEFT        1
#define     GI_LEFT          2
#define     GI_DOWNLEFT      3
#define     GI_UP            4
#define     GI_CENTER        5
#define     GI_DOWN          6
#define     GI_UPRIGHT       7
#define     GI_RIGHT         8
#define     GI_DOWNRIGHT     9

#define     GI_CUBIGCROSS    1
#define     GI_CUSMALLCROSS  2
#define     GI_CURECTANGLE   3

#define     GI_CENTRAL       1
#define     GI_PARALLEL      2

#define     GI_AXISX         0
#define     GI_AXISY         1
#define     GI_AXISZ         2

typedef struct GI_OBJ_tag                 /* ... fuer verkettete Listen */
         {                                /* und binaere Baeume, die    */
            int                type  ;    /* insol_gi und insot_gi      */
            void              *data  ;    /* angelegt werden            */
            double             dist  ;
            struct GI_OBJ_tag *left  ;
            struct GI_OBJ_tag *right ;
         
         }  GI_OBJ ; 

typedef struct GI_ELEM_tag                /* ... fuer die Liste der     */
         {                                /* Elemente, die von rddfl_gi */
            int                 nop   ;   /* angelegt wird              */
            int                *param ;
            struct GI_ELEM_tag *next  ;
            
         }  GI_ELEM ;          

/*********  Prototypen der Interface-Routinen der GIW-TOOLBOX:   ********/

void     desot_gi (GI_OBJ *root_p) ;
void     flini_gi (HWND hwnd) ;
int      flodl_gi (HWND hwnd, char *pathnm , char *filenm) ;
void     frell_gi (GI_ELEM *kroot_p) ;
void     gstop_gi (HWND hwnd) ;
HDC      gstrt_gi (HWND hwnd , int cxClient , int cyClient) ;                                              
int      insol_gi (GI_OBJ **root_pp , int    type , void   *data , 
                   double   xw      , double yw   , double zw) ;
int      insot_gi (GI_OBJ **root_pp , int    type , void   *data , 
                   double xw        , double yw   , double zw) ;
COLORREF mkrgb_gi (int color) ;
int      prfpl_gi (HDC hdc , int    npoin , double xw [] ,
                             double yw [] , double zw []) ;
void     prgtd_gi (double *xwd , double *ywd , double *zwd) ;
void     prgte_gi (double *xwe , double *ywe , double *zwe) ;
int      prgtp_gi () ;
void     prgtr_gi (double *xwr , double *ywr , double *zwr) ;
void     prini_gi () ;
int      prlin_gi (HDC hdc , double xw , double yw , double zw) ;
int      prmov_gi (HDC hdc , double xw , double yw , double zw) ;
void     projn_gi (int ptyp) ;
int      prstc_gi (double xwe , double ywe , double zwe ,
                   double xwr , double ywr , double zwr) ;
int      prstd_gi (double xwd , double ywd , double zwd) ;
int      prste_gi (double xwe , double ywe , double zwe)  ;
int      prstp_gi (double xwd , double ywd , double zwd ,
                   double xwr , double ywr , double zwr) ;
int      prstr_gi (double xwr , double ywr , double zwr) ;
int      prw2u_gi (double xw , double  yw , double  zw ,
                               double *xu , double *yu) ;
double   ptdis_gi (double xw , double yw , double zw) ;
int      ptfpl_gi (HDC hdc      , int npoin ,
                   double xw [] , double yw [] , double zw []) ;
void     ptini_gi () ;
int      ptmov_gi (HDC hdc , double xw , double yw , double zw) ;
int      ptmrk_gi (HDC    hdc , int    mtype , double msize , 
                   double xw  , double yw    , double zw    , int offset) ;
int      ptmx3_gi (int    npoin  , double xyzw [] , 
                   double *xumin , double *xumax  , 
                   double *yumin , double *yumax) ;
int      ptlin_gi (HDC hdc , double xw , double yw , double zw) ;
int      ptw2u_gi (double xw , double  yw , double  zw ,
                          double *xu , double *yu) ;
int      ptwdl_gi (HDC hdc , double x1w  , double y1w , double z1w ,
                             double x2w  , double y2w , double z2w ,
                             int    wpix , COLORREF wcol ,
                             int    ipix , COLORREF icol) ;
int      rddfl_gi (HWND hwnd , char *pathnm , int     *ne_p , int  *nk_p , 
                          int  *ke_p   , double **xy_pp , GI_ELEM **km_pp) ;
int      rpick_gi (HWND hwnd , LONG lParam , double *x1u , double *y1u  , 
                                             double *x2u , double *y2u) ;
void     scapp_gi (HWND hwnd , int xv , int yv , int ctype) ;
void     scdap_gi (HWND hwnd) ;
void     scupd_gi (HWND hwnd , LONG lParam) ;
void     stcvp_gi (HDC  hdc  , int pulx  , int puly   ,
                               int width , int height , int cstype) ;
void     stuca_gi (double p1xu , double p1yu ,
                   double p2xu , double p2yu , double pmarg) ;
void     stuci_gi (double p1xu , double p1yu ,
                   double p2xu , double p2yu , double pmarg) ;
void     t3gtm_gi (double *tm) ;
void     t3mam_gi (double *tnew) ;
void     t3rot_gi (double phi , int axis) ;
void     t3stm_gi (double *tm) ;
void     t3trn_gi (double tx , double ty , double tz) ;
void     t3w2w_gi (double  xw  , double  yw  , double  zw , 
                   double *txw , double *tyw , double *tzw) ;
void     tdarc_gi (HDC hdc , double xc , double yc , double r  , 
                             double xs , double ys , double xe , double ye) ;
void     tfcir_gi (HDC hdc , double xc , double yc , double r) ;
void     tgttm_gi (double *tm) ;
void     tinit_gi () ;
void     tline_gi (HDC hdc , double xu , double yu) ;
void     tmamu_gi (double *tnew) ;
void     tmirx_gi () ;
void     tmiry_gi () ;
void     tmove_gi (HDC hdc , double xu , double yu) ;
void     trota_gi (double xm , double ym , double phi) ;
void     tru2t_gi (double xu , double yu , double *txu , double *tyu) ;
void     tsttm_gi (double *tm) ;
void     ttabs_gi (double tx , double ty , double phi , 
                   double sx , double sy) ;
void     ttran_gi (double tx , double ty) ;
void     udarc_gi (HDC hdc , double xc , double yc , double r  , 
                             double xs , double ys , double xe , double ye) ;
void     ufcir_gi (HDC hdc , double xc , double yc , double r) ;
void     ufell_gi (HDC hdc , double xu1 , double yu1 ,
                             double xu2 , double yu2) ;
void     ufel2_gi (HDC hdc , double xc , double yc ,
                             double a  , double b) ;
void     ufpie_gi (HDC hdc , double x1 , double y1 , double x2 , double y2  ,
                             double xs , double ys , double xe , double ye) ;
void     ufpi2_gi (HDC hdc , double xc , double yc , double a  , double b  ,
                             double xs , double ys , double xe , double ye) ;
int      ufpol_gi (HDC hdc , int npoin , double xu [] , double yu []) ;
void     ufrec_gi (HDC hdc , double xu1 , double yu1 ,
                             double xu2 , double yu2) ;
void     ufsec_gi (HDC hdc , double xc , double yc , double r  , 
                             double xs , double ys , double xe , double ye) ;
void     uline_gi (HDC hdc , double xu  , double yu) ;
void     umark_gi (HDC hdc , int    mtype , double msize , 
                             double xu    , double yu    , int offset) ;
void     umove_gi (HDC hdc , double xu , double yu) ;
int      umpos_gi (LONG lParam , double *xu , double *yu) ;
void     uwidl_gi (HDC hdc , double xu1 , double yu1 , 
                             double xu2 , double yu2 ,
                             int wpix   , COLORREF wcol ,
                             int ipix   , COLORREF icol) ;
int      upick_gi (HWND hwnd , LONG lParam , double *xu , double *yu) ;
void     vfram_gi (HDC hdc , int offset) ;
void     vfrec_gi (HDC hdc , int xv1 , int yv1 , int xv2 , int yv2) ;
void     vline_gi (HDC hdc , int xv  , int yv) ;
void     vmove_gi (HDC hdc , int xv  , int yv) ;
void     vrect_gi (HDC hdc , int xv1 , int yv1 , int xv2 , int yv2) ;
