/**********************************************************************
 *  Demonstrationsprogramm FILLCOL                                    *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Das Programm demonstriert die GIW-Funktionen mkrgb_gi             *
 *  (Ermitteln der RGB-Werte fuer 8 Grundfarben), vfrec_gi (Zeichnen  *
 *  eines in "Viewport Coordinates" gegebenen gefuellten Rechtecks)   *
 *  ufrec_gi (Zeichnen eines in "User Coordinates" gegebenen          *
 *  gefuellten Rechtecks), ufell_gi (Zeichnen einer in "User          *
 *  Coordinates" gegebenen gefuellten Ellipse), ufpol_gi (Zeichnen    *
 *  eines in "User Coordinates" gegebenen gefuellten Polygons) und    *
 *  ufpie_gi (Zeichnen eines in "User Coordinates" gegebenen          *
 *  Kreissektors).                                                    *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <stdio.h>
#include <stdlib.h>

HANDLE   hActInstance   ;  

LRESULT CALLBACK WndProc (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "FILLCOL" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     HDC            hdc  ;
     HBRUSH         hBrush1 , hBrush2 ;
     double         poly_x [4] = {   0. ,   6. , 5. ,   4. } , 
                    poly_y [4] = { - 3. , - 2. , 2. , - 1. } ;
     
     switch (message)
        { 
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;  /* ... sind die Abmessungen (Pixel) des */
               cyClient = HIWORD (lParam) ;  /*     Zeichen-Fensters                 */

               return 0 ; 
               
          case WM_PAINT :                       
          
               hdc     = gstrt_gi (hwnd , cxClient , cyClient) ;
               hBrush1 = CreateSolidBrush (mkrgb_gi (GI_BLUE)) ;
               hBrush2 = CreateSolidBrush (mkrgb_gi (GI_CYAN)) ;
               
               stcvp_gi (hdc , 2 , 2 , cxClient / 2 - 4 , cyClient - 4 , GI_XYBOTTOMLEFT) ;    
                        /* ... definiert "Current Viewport" in linker Fensterhaelfte     */           

               SelectObject (hdc , hBrush1) ;                            
               vfrec_gi (hdc , 0 , 0 , cxClient / 2 - 5 , cyClient - 5) ;
                        /* ... fuellt Viewport mit Farbe, zeichnet Rahmen                */       
                      
               stuca_gi (-1. , -4. , 11. , 5. , 0.) ;
                        /* ... definiert "User Coordinates": Punkt (-1;-4) wird auf die
                               linke untere Viewport-Ecke gelegt, Punkt (11;5) auf die
                               rechte obere Ecke (da die Werte keinen Bezug auf die
                               Viewport-Abmessungen nehmen, werden die beiden Achsen
                               im Regelfall unterschiedlich skaliert)                    */ 
                               
               SelectObject (hdc , hBrush2) ;                            
               ufrec_gi (hdc , 0. , 0. , 4. , 4.) ; 
                        /* ... zeichnet ein i. a. "zum Rechteck verzerrtes Quadrat"      */
               ufell_gi (hdc , 6. , - 2. , 10. , 2.) ; 
                        /* ... zeichnet einen i. a. "zur Ellipse verzerrten Kreis"       */
               ufell_gi (hdc , 8. , 3. , 14. , 6.) ; 
                        /* ... zeichnet Ellipse, die am Viewport-Rand "geclippt" wird    */
               ufpol_gi (hdc , 4 , poly_x , poly_y) ;
                        /* ... zeichnet geschlossenes Polygon mit 4 Punkten              */
               ufpie_gi (hdc , 4. , 0. , 8. , 4. , 7. , 4. , 4. , 3.) ; 
                        /* ... zeichnet einen i. a. verzerrten Kreissektor               */                
               
               stcvp_gi (hdc , cxClient / 2 + 2 , 2 , 
                               cxClient / 2 - 4 , cyClient - 4 , GI_XYBOTTOMLEFT) ;    
                        /* ... definiert "Current Viewport" in rechter Fensterhaelfte    */ 
                        
               /* Man beachte, dass die folgenden Aktionen im rechten Viewport exakt 
                  durch die gleichen Funktionsaufrufe wie fuer den linken Viewport
                  ausgeloest werden. Lediglich die fuer den Viewport festgelegten
                  "User Coordinates" fuehren auf ein abweichendes Ergebnis:              */                     

               vfrec_gi (hdc , 0 , 0 , cxClient / 2 - 5 , cyClient - 5) ;
                        /* ... fuellt Viewport mit Farbe, zeichnet Rahmen                */       
                      
               stuci_gi (-1. , -4. , 11. , 5. , 0.) ;
                        /* ... definiert "User Coordinates": Punkt (-1;-4) wird auf die
                               linke untere Viewport-Ecke gelegt, Punkt (11;5) auf die
                               rechte obere Ecke (die beiden Richtungen werden 
                               "isotrop skaliert")                                       */ 
                               
               SelectObject (hdc , hBrush1) ;                            
               ufrec_gi (hdc , 0. , 0. , 4. , 4.) ; 
                        /* ... zeichnet immer ein Quadrat                                */
               ufell_gi (hdc , 6. , - 2. , 10. , 2.) ; 
                        /* ... zeichnet immer einen Kreis                                */
               ufell_gi (hdc , 8. , 3. , 14. , 6.) ; 
                        /* ... zeichnet Ellipse, die am Viewport-Rand "geclippt" wird    */
               ufpol_gi (hdc , 4 , poly_x , poly_y) ;
                        /* ... zeichnet geschlossenes Polygon mit 4 Punkten              */        
               ufpie_gi (hdc , 4. , 0. , 8. , 4. , 7. , 4. , 4. , 3.) ;                 
                        /* ... zeichnet einen Kreissektor                                */                
     
               SelectObject (hdc , GetStockObject (WHITE_BRUSH)) ;                            
               DeleteObject (hBrush1) ;                            
               DeleteObject (hBrush2) ;                            

               gstop_gi (hwnd) ;  
               return 0 ;

          case WM_DESTROY : 
          
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}
