//###########################################################################
//#
//# Diplomarbeit von Michel Jaggi / Abalone Spiel
//#
//# Datum: 22.06.2002
//#
//# Klasse Matrix dient zur Erzeugung der Matrix und zur Behandlung der
//# Spielregeln und der grafischen Anzeige der Matrix.
//#
//###########################################################################
#include "Matrix.h"
#include "Unit1.h"

using namespace std;

//###########################################################################
//#
//# Erstellen des zweidimensionalen Arrays
//#
//###########################################################################
void Matrix::create_array(int MaX, int MaY)
{
  DataArray=new double*[MaX];
  for (int i=0; i<MaX; i++)
  {
    DataArray[i]=new double[MaY];
  }
  for (int x=0; x<XArraySize; x++)
  {
    for (int y=0; y<YArraySize; y++)
    {
      DataArray[x][y] = 99;
    }
  }
  RestArray=new double*[6];
  for (int i=0; i<6; i++)
  {
    RestArray[i]=new double[5];
  }
  for (int x=0; x<6; x++)
  {
    for (int y=0; y<5; y++)
    {
      RestArray[x][y] = 99;
    }
  }
}
//###########################################################################
//#
//# Konstruktor der Klasse Matrix; der Array wird erstellt.
//#
//###########################################################################
Matrix::Matrix(int MaXSize, int MaYSize)
{
  XArraySize = MaXSize;
  YArraySize = MaYSize;
  create_array(XArraySize, YArraySize);
}
//###########################################################################
//#
//# Lschen des zweidimensionalen Arrays
//#
//###########################################################################
void Matrix::delete_array(int MaX, int MaY)
{
  for (int i=0; i < MaX; i++)
  {
    delete[] DataArray[i];
  }
  delete[] DataArray;

  for (int i=0; i < 5; i++)
  {
    delete[] RestArray[i];
  }
  delete[] RestArray;
}
//###########################################################################
//#
//# Destruktor der Klasse Matrix; der Array wird gelscht.
//#
//###########################################################################
Matrix::~Matrix()
{
  delete_array(XArraySize, YArraySize);
}
//###########################################################################
//#
//# Initialisiert die Matrix mit den Default Werten
//#
//###########################################################################
void Matrix::initValue()
{
  for (int x=0; x<XArraySize; x++)
  {
    for (int y=0; y<YArraySize; y++)
    {
      DataArray[x][y] = 99;
    }
  }
  for (int x=0; x<6; x++)
  {
    for (int y=0; y<5; y++)
    {
      RestArray[x][y] = 0;
    }
  }
  int count;
  for (int x=0; x<XArraySize; x++)
  {
    for (int y=0; y<YArraySize; y++)
    {
      if (x==6 || x==8 || x==10 || x==12 || x==14)
      {
        if (y==2)
        {
          DataArray[x][y] = 1;
        }
      }
      if (x==5 || x==7 || x==9 || x==11 || x==13 || x==15)
      {
        if (y==3)
        {
          DataArray[x][y] = 1;
        }
      }
      if (x==8 || x==10 || x==12)
      {
        if (y==4)
        {
          DataArray[x][y] = 1;
        }
      }
      if (x==8 || x==10 || x==12)
      {
        if (y==8)
        {
          DataArray[x][y] = 2;
        }
      }
      if (x==5 || x==7 || x==9 || x==11 || x==13 || x==15)
      {
        if (y==9)
        {
          DataArray[x][y] = 2;
        }
      }
      if (x==6 || x==8 || x==10 || x==12 || x==14)
      {
        if (y==10)
        {
          DataArray[x][y] = 2;
        }
      }
      if (x==4 || x==6 || x==14 || x==16)
      {
        if (y==4)
        {
          DataArray[x][y] = 0;
        }
      }
      if (x==3 || x==5 || x==7 || x==9 || x==11 || x==13|| x==15 || x==17)
      {
        if (y==5)
        {
          DataArray[x][y] = 0;
        }
      }
      if (x==2 || x==4 || x==6 || x==8 || x==10 || x==12 || x==14 || x==16 || x==18)
      {
        if (y==6)
        {
          DataArray[x][y] = 0;
        }
      }
      if (x==3 || x==5 || x==7 || x==9 || x==11 || x==13|| x==15 || x==17)
      {
        if (y==7)
        {
          DataArray[x][y] = 0;
        }
      }
      if (x==4 || x==6 || x==14 || x==16)
      {
        if (y==8)
        {
          DataArray[x][y] = 0;
        }
      }
    }
  }
}
//###########################################################################
//#
//# Setzt an einem gewhlten Punkt in der Matrix einen bestimmten Wert ein
//#
//###########################################################################
void Matrix::setValue(int MaX, int MaY, int MaValue)
{
  DataArray[MaX][MaY]=MaValue;
}
//###########################################################################
//#
//# Setzt an einem gewhlten Punkt in der RestMatrix einen bestimmten Wert ein
//#
//###########################################################################
void Matrix::setRestVal(int MaX, int MaY, int MaValue)
{
  if (RestArray[MaX][MaY] != 0)
  {
    bool RestFlag = false;
    for (int i=0; i<6; i++)
    {
      for (int j=0; j<5; j++)
      {
        if (RestArray[i][j] == 0 && RestFlag == false)
        {
          RestArray[i][j] = RestArray[MaX][MaY];
          RestArray[MaX][MaY] = 0;
          RestFlag = true;
        }
      }
    }
  }
  RestArray[MaX][MaY]=MaValue;
}
//###########################################################################
//#
//# Verschiebt einen Stein in der Matrix. Wird der Stein aus dem Spielfeld
//# hinausgeschoben, so wird er in den Hilfsarray gelegt.
//#
//###########################################################################
int Matrix::MoveStone(int MaStoneColor)
{
  int nextX, nextY;
  int diffX, diffY;
  int countStones = 1;

  nextX = DestX;
  nextY = DestY;
  diffX = nextX - SourcX;
  diffY = nextY - SourcY;

  while (this->GetStoneValue(nextX, nextY) !=0 && this->GetStoneValue(nextX, nextY) !=99)
  {              // Solange kein leeres Feld kommt
    countStones++;
    nextX = nextX + diffX;
    nextY = nextY + diffY;
  }
  nextX = SourcX;
  nextY = SourcY;
  while (countStones > 0)
  {
    if (diffX > 0)
    {
      nextX = SourcX + (countStones * abs(diffX));
    }
    else
    {
      nextX = SourcX - (countStones * abs(diffX));
    }
    if (diffY > 0)
    {
      nextY = SourcY + (countStones * abs(diffY));
    }
    else
    {
      nextY = SourcY - (countStones * abs(diffY));
    }
    if (MaStoneColor == this->GetStoneValue(nextX -diffX, nextY - diffY) &&
      this->GetStoneValue(nextX, nextY) == 99)
    {
      return (8);
    }
    else
    {
      if (this->GetStoneValue(nextX, nextY) == 99) // Wenn ein gegnerischer Stein
      {                                            // Aus dem Spielfeld geschoben wird
        if (nextY == 1 && nextX == 7)
        {
          this->setRestVal(0,0,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 1 && nextX == 9)
        {
          this->setRestVal(0,1,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 1 && nextX == 11)
        {
          this->setRestVal(0,2,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 1 && nextX == 13)
        {
          this->setRestVal(0,3,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 1 && nextX == 15)
        {
          this->setRestVal(0,4,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 2 && nextX == 16)
        {
          this->setRestVal(1,0,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 3 && nextX == 17)
        {
          this->setRestVal(1,1,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 4 && nextX == 18)
        {
          this->setRestVal(1,2,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 5 && nextX == 19)
        {
          this->setRestVal(1,3,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 6 && nextX == 20)
        {
          this->setRestVal(1,4,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 7 && nextX == 19)
        {
          this->setRestVal(2,0,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 8 && nextX == 18)
        {
          this->setRestVal(2,1,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 9 && nextX == 17)
        {
          this->setRestVal(2,2,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 10 && nextX == 16)
        {
          this->setRestVal(2,3,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 11 && nextX == 15)
        {
          this->setRestVal(2,4,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 11 && nextX == 13)
        {
          this->setRestVal(3,0,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 11 && nextX == 11)
        {
          this->setRestVal(3,1,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 11 && nextX == 9)
        {
          this->setRestVal(3,2,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 11 && nextX == 7)
        {
          this->setRestVal(3,3,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 11 && nextX == 5)
        {
          this->setRestVal(3,4,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 10 && nextX == 4)
        {
          this->setRestVal(4,0,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 9 && nextX == 3)
        {
          this->setRestVal(4,1,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 8 && nextX == 2)
        {
          this->setRestVal(4,2,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 7 && nextX == 1)
        {
          this->setRestVal(4,3,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 6 && nextX == 0)
        {
          this->setRestVal(4,4,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 5 && nextX == 1)
        {
          this->setRestVal(5,0,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 4 && nextX == 2)
        {
          this->setRestVal(5,1,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 3 && nextX == 3)
        {
          this->setRestVal(5,2,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 2 && nextX == 4)
        {
          this->setRestVal(5,3,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
        if (nextY == 1 && nextX == 5)
        {
          this->setRestVal(5,4,this->GetStoneValue(nextX - diffX, nextY -diffY));
          this->RestShow();
        }
      }
      else
      {
        this->setValue(nextX, nextY, this->GetStoneValue(nextX - diffX, nextY -diffY));
      }
      this->setValue(nextX - diffX, nextY - diffY, 0);
      countStones--;
    }
  } // end while
  return (0);
}
//###########################################################################
//#
//# Liest die Rest Matrix aus und zeigt die Werte auf dem GUI an
//#
//###########################################################################
void Matrix::RestShow()
{
  for (int i=0; i<6; i++)
  {
    for (int j=0; j<5; j++)
    {
      int StoneColor = RestArray[i][j];
      if (StoneColor != 99)
      {
        if (i==0 && j==0)
        {
          if (StoneColor == 0)
          {
            Form1->Image70->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image70->Picture->Bitmap);
          }
          Form1->Image70->Refresh();
        }
        if (i==0 && j==1)
        {
          if (StoneColor == 0)
          {
            Form1->Image71->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image71->Picture->Bitmap);
          }
          Form1->Image71->Refresh();
        }
        if (i==0 && j==2)
        {
          if (StoneColor == 0)
          {
            Form1->Image72->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image72->Picture->Bitmap);
          }
          Form1->Image72->Refresh();
        }
        if (i==0 && j==3)
        {
          if (StoneColor == 0)
          {
            Form1->Image73->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image73->Picture->Bitmap);
          }
          Form1->Image73->Refresh();
        }
        if (i==0 && j==4)
        {
          if (StoneColor == 0)
          {
            Form1->Image74->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image74->Picture->Bitmap);
          }
          Form1->Image74->Refresh();
        }
        if (i==1 && j==0)
        {
          if (StoneColor == 0)
          {
            Form1->Image75->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image75->Picture->Bitmap);
          }
          Form1->Image75->Refresh();
        }
        if (i==1 && j==1)
        {
          if (StoneColor == 0)
          {
            Form1->Image76->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image76->Picture->Bitmap);
          }
          Form1->Image76->Refresh();
        }
        if (i==1 && j==2)
        {
          if (StoneColor == 0)
          {
            Form1->Image77->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image77->Picture->Bitmap);
          }
          Form1->Image77->Refresh();
        }
        if (i==1 && j==3)
        {
          if (StoneColor == 0)
          {
            Form1->Image78->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image78->Picture->Bitmap);
          }
          Form1->Image78->Refresh();
        }
        if (i==1 && j==4)
        {
          if (StoneColor == 0)
          {
            Form1->Image79->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image79->Picture->Bitmap);
          }
          Form1->Image79->Refresh();
        }
        if (i==2 && j==0)
        {
          if (StoneColor == 0)
          {
            Form1->Image80->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image80->Picture->Bitmap);
          }
          Form1->Image80->Refresh();
        }
        if (i==2 && j==1)
        {
          if (StoneColor == 0)
          {
            Form1->Image81->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image81->Picture->Bitmap);
          }
          Form1->Image81->Refresh();
        }
        if (i==2 && j==2)
        {
          if (StoneColor == 0)
          {
            Form1->Image82->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image82->Picture->Bitmap);
          }
          Form1->Image82->Refresh();
        }
        if (i==2 && j==3)
        {
          if (StoneColor == 0)
          {
            Form1->Image83->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image83->Picture->Bitmap);
          }
          Form1->Image83->Refresh();
        }
        if (i==2 && j==4)
        {
          if (StoneColor == 0)
          {
            Form1->Image84->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image84->Picture->Bitmap);
          }
          Form1->Image84->Refresh();
        }
        if (i==3 && j==0)
        {
          if (StoneColor == 0)
          {
            Form1->Image85->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image85->Picture->Bitmap);
          }
          Form1->Image85->Refresh();
        }
        if (i==3 && j==1)
        {
          if (StoneColor == 0)
          {
            Form1->Image86->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image86->Picture->Bitmap);
          }
          Form1->Image86->Refresh();
        }
        if (i==3 && j==2)
        {
          if (StoneColor == 0)
          {
            Form1->Image87->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image87->Picture->Bitmap);
          }
          Form1->Image87->Refresh();
        }
        if (i==3 && j==3)
        {
          if (StoneColor == 0)
          {
            Form1->Image88->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image88->Picture->Bitmap);
          }
          Form1->Image88->Refresh();
        }
        if (i==3 && j==4)
        {
          if (StoneColor == 0)
          {
            Form1->Image89->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image89->Picture->Bitmap);
          }
          Form1->Image89->Refresh();
        }
        if (i==4 && j==0)
        {
          if (StoneColor == 0)
          {
            Form1->Image90->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image90->Picture->Bitmap);
          }
          Form1->Image90->Refresh();
        }
        if (i==4 && j==1)
        {
          if (StoneColor == 0)
          {
            Form1->Image91->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image91->Picture->Bitmap);
          }
          Form1->Image91->Refresh();
        }
        if (i==4 && j==2)
        {
          if (StoneColor == 0)
          {
            Form1->Image92->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image92->Picture->Bitmap);
          }
          Form1->Image92->Refresh();
        }
        if (i==4 && j==3)
        {
          if (StoneColor == 0)
          {
            Form1->Image93->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image93->Picture->Bitmap);
          }
          Form1->Image93->Refresh();
        }
        if (i==4 && j==4)
        {
          if (StoneColor == 0)
          {
            Form1->Image94->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image94->Picture->Bitmap);
          }
          Form1->Image94->Refresh();
        }
        if (i==5 && j==0)
        {
          if (StoneColor == 0)
          {
            Form1->Image95->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image95->Picture->Bitmap);
          }
          Form1->Image95->Refresh();
        }
        if (i==5 && j==1)
        {
          if (StoneColor == 0)
          {
            Form1->Image96->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image96->Picture->Bitmap);
          }
          Form1->Image96->Refresh();
        }
        if (i==5 && j==2)
        {
          if (StoneColor == 0)
          {
            Form1->Image97->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image97->Picture->Bitmap);
          }
          Form1->Image97->Refresh();
        }
        if (i==5 && j==3)
        {
          if (StoneColor == 0)
          {
            Form1->Image98->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image98->Picture->Bitmap);
          }
          Form1->Image98->Refresh();
        }
        if (i==5 && j==4)
        {
          if (StoneColor == 0)
          {
            Form1->Image99->Picture = NULL;
          }
          else
          {
            Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image99->Picture->Bitmap);
          }
          Form1->Image99->Refresh();
        }
      }
    }
  }
}
//###########################################################################
//#
//# Liest die Matrix aus und zeigt die Werte auf dem GUI an
//#
//###########################################################################
void Matrix::GraphicShow(int MaStoneColor)
{
  for (int i=0; i<XArraySize; i++)
  {
    for (int j=0; j<YArraySize; j++)
    {
      int StoneColor = DataArray[i][j];

      if (StoneColor != 99)
      {

      if (i==6 && j==2)
      {
        if (StoneColor == 0)
        {
          Form1->Image8->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image8->Picture->Bitmap);
        }
        Form1->Image8->Refresh();
      }
      if (i==8 && j==2)
      {
        if (StoneColor == 0)
        {
          Form1->Image9->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image9->Picture->Bitmap);
        }
        Form1->Image9->Refresh();
      }
      if (i==10 && j==2)
      {
        if (StoneColor == 0)
        {
          Form1->Image10->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image10->Picture->Bitmap);
        }
        Form1->Image10->Refresh();
      }
      if (i==12 && j==2)
      {
        if (StoneColor == 0)
        {
          Form1->Image11->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image11->Picture->Bitmap);
        }
        Form1->Image11->Refresh();
      }
      if (i==14 && j==2)
      {
        if (StoneColor == 0)
        {
          Form1->Image12->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image12->Picture->Bitmap);
        }
        Form1->Image12->Refresh();
      }
      if (i==5 && j==3)
      {
        if (StoneColor == 0)
        {
          Form1->Image13->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image13->Picture->Bitmap);
        }
        Form1->Image13->Refresh();
      }
      if (i==7 && j==3)
      {
        if (StoneColor == 0)
        {
          Form1->Image14->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image14->Picture->Bitmap);
        }
        Form1->Image14->Refresh();
      }
      if (i==9 && j==3)
      {
        if (StoneColor == 0)
        {
          Form1->Image15->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image15->Picture->Bitmap);
        }
        Form1->Image15->Refresh();
      }
      if (i==11 && j==3)
      {
        if (StoneColor == 0)
        {
          Form1->Image16->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image16->Picture->Bitmap);
        }
        Form1->Image16->Refresh();
      }
      if (i==13 && j==3)
      {
        if (StoneColor == 0)
        {
          Form1->Image17->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image17->Picture->Bitmap);
        }
        Form1->Image17->Refresh();
      }
      if (i==15 && j==3)
      {
        if (StoneColor == 0)
        {
          Form1->Image18->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image18->Picture->Bitmap);
        }
        Form1->Image18->Refresh();
      }
      if (i==4 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image19->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image19->Picture->Bitmap);
        }
        Form1->Image19->Refresh();
      }
      if (i==6 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image20->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image20->Picture->Bitmap);
        }
        Form1->Image20->Refresh();
      }
      if (i==8 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image21->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image21->Picture->Bitmap);
        }
        Form1->Image21->Refresh();
      }
      if (i==10 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image22->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image22->Picture->Bitmap);
        }
        Form1->Image22->Refresh();
      }
      if (i==12 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image23->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image23->Picture->Bitmap);
        }
        Form1->Image23->Refresh();
      }
      if (i==14 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image24->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image24->Picture->Bitmap);
        }
        Form1->Image24->Refresh();
      }
      if (i==16 && j==4)
      {
        if (StoneColor == 0)
        {
          Form1->Image25->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image25->Picture->Bitmap);
        }
        Form1->Image25->Refresh();
      }
      if (i==3 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image26->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image26->Picture->Bitmap);
        }
        Form1->Image26->Refresh();
      }
      if (i==5 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image27->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image27->Picture->Bitmap);
        }
        Form1->Image27->Refresh();
      }
      if (i==7 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image28->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image28->Picture->Bitmap);
        }
        Form1->Image28->Refresh();
      }
      if (i==9 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image29->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image29->Picture->Bitmap);
        }
        Form1->Image29->Refresh();
      }
      if (i==11 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image30->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image30->Picture->Bitmap);
        }
        Form1->Image30->Refresh();
      }
      if (i==13 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image31->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image31->Picture->Bitmap);
        }
        Form1->Image31->Refresh();
      }
      if (i==15 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image32->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image32->Picture->Bitmap);
        }
        Form1->Image32->Refresh();
      }
      if (i==17 && j==5)
      {
        if (StoneColor == 0)
        {
          Form1->Image33->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image33->Picture->Bitmap);
        }
        Form1->Image33->Refresh();
      }
      if (i==2 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image34->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image34->Picture->Bitmap);
        }
        Form1->Image34->Refresh();
      }
      if (i==4 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image35->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image35->Picture->Bitmap);
        }
        Form1->Image35->Refresh();
      }
      if (i==6 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image36->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image36->Picture->Bitmap);
        }
        Form1->Image36->Refresh();
      }
      if (i==8 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image37->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image37->Picture->Bitmap);
        }
        Form1->Image37->Refresh();
      }
      if (i==10 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image38->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image38->Picture->Bitmap);
        }
        Form1->Image38->Refresh();
      }
      if (i==12 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image39->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image39->Picture->Bitmap);
        }
        Form1->Image39->Refresh();
      }
      if (i==14 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image40->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image40->Picture->Bitmap);
        }
        Form1->Image40->Refresh();
      }
      if (i==16 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image41->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image41->Picture->Bitmap);
        }
        Form1->Image41->Refresh();
      }
      if (i==18 && j==6)
      {
        if (StoneColor == 0)
        {
          Form1->Image42->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image42->Picture->Bitmap);
        }
        Form1->Image42->Refresh();
      }
      if (i==3 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image43->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image43->Picture->Bitmap);
        }
        Form1->Image43->Refresh();
      }
      if (i==5 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image44->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image44->Picture->Bitmap);
        }
        Form1->Image44->Refresh();
      }
      if (i==7 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image46->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image46->Picture->Bitmap);
        }
        Form1->Image46->Refresh();
      }
      if (i==9 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image47->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image47->Picture->Bitmap);
        }
        Form1->Image47->Refresh();
      }
      if (i==11 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image48->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image48->Picture->Bitmap);
        }
        Form1->Image48->Refresh();
      }
      if (i==13 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image49->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image49->Picture->Bitmap);
        }
        Form1->Image49->Refresh();
      }
      if (i==15 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image50->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image50->Picture->Bitmap);
        }
        Form1->Image50->Refresh();
      }
      if (i==17 && j==7)
      {
        if (StoneColor == 0)
        {
          Form1->Image51->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image51->Picture->Bitmap);
        }
        Form1->Image51->Refresh();
      }
      if (i==4 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image52->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image52->Picture->Bitmap);
        }
        Form1->Image52->Refresh();
      }
      if (i==6 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image53->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image53->Picture->Bitmap);
        }
        Form1->Image53->Refresh();
      }
      if (i==8 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image54->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image54->Picture->Bitmap);
        }
        Form1->Image54->Refresh();
      }
      if (i==10 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image55->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image55->Picture->Bitmap);
        }
        Form1->Image55->Refresh();
      }
      if (i==12 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image56->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image56->Picture->Bitmap);
        }
        Form1->Image56->Refresh();
      }
      if (i==14 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image57->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image57->Picture->Bitmap);
        }
        Form1->Image57->Refresh();
      }
      if (i==16 && j==8)
      {
        if (StoneColor == 0)
        {
          Form1->Image58->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image58->Picture->Bitmap);
        }
        Form1->Image58->Refresh();
      }
      if (i==5 && j==9)
      {
        if (StoneColor == 0)
        {
          Form1->Image59->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image59->Picture->Bitmap);
        }
        Form1->Image59->Refresh();
      }
      if (i==7 && j==9)
      {
        if (StoneColor == 0)
        {
          Form1->Image60->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image60->Picture->Bitmap);
        }
        Form1->Image60->Refresh();
      }
      if (i==9 && j==9)
      {
        if (StoneColor == 0)
        {
          Form1->Image61->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image61->Picture->Bitmap);
        }
        Form1->Image61->Refresh();
      }
      if (i==11 && j==9)
      {
        if (StoneColor == 0)
        {
          Form1->Image62->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image62->Picture->Bitmap);
        }
        Form1->Image62->Refresh();
      }
      if (i==13 && j==9)
      {
        if (StoneColor == 0)
        {
          Form1->Image63->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image63->Picture->Bitmap);
        }
        Form1->Image63->Refresh();
      }
      if (i==15 && j==9)
      {
        if (StoneColor == 0)
        {
          Form1->Image64->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image64->Picture->Bitmap);
        }
        Form1->Image64->Refresh();
      }
      if (i==6 && j==10)
      {
        if (StoneColor == 0)
        {
          Form1->Image65->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image65->Picture->Bitmap);
        }
        Form1->Image65->Refresh();
      }
      if (i==8 && j==10)
      {
        if (StoneColor == 0)
        {
          Form1->Image66->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image66->Picture->Bitmap);
        }
        Form1->Image66->Refresh();
      }
      if (i==10 && j==10)
      {
        if (StoneColor == 0)
        {
          Form1->Image67->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image67->Picture->Bitmap);
        }
        Form1->Image67->Refresh();
      }
      if (i==12 && j==10)
      {
        if (StoneColor == 0)
        {
          Form1->Image68->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image68->Picture->Bitmap);
        }
        Form1->Image68->Refresh();
      }
      if (i==14 && j==10)
      {
        if (StoneColor == 0)
        {
          Form1->Image69->Picture = NULL;
        }
        else
        {
          Form1->ImageList1->GetBitmap(StoneColor-1,Form1->Image69->Picture->Bitmap);
        }
        Form1->Image69->Refresh();
      }
      }
    }
  }
}
//###########################################################################
//#
//# berprft, ob der Zug den Spielregeln entspricht, wenn nicht, wird eine
//# Fehlermeldung ausgegeben.
//#
//###########################################################################
int Matrix::ScanRules(int MaStoneColor)
{
  int nextX, nextY;
  int diffX, diffY;
  int lastX, lastY;
  int countStones = 1;

  nextX = DestX;
  nextY = DestY;
  lastX = SourcX;
  lastY = SourcY;
  diffX = DestX - SourcX;
  diffY = DestY - SourcY;
////////////////////////////////////////////////////////////////////////////////
// Checkt, ob mehr als ein Loch bersprungen wird.
// Wenn ja, wird eine Fehlermeldung angezeigt.
//
  if (diffX > 2 || diffX < -2 || diffY > 1 || diffY < -1)
  {
    return (1);
  }

////////////////////////////////////////////////////////////////////////////////
// Checken, ob sich in der entgegengesetzten Schiebrichtung ein Stein befindet.
// Wenn ja, wird eine Fehlermeldung angezeigt.
//
  if (this->GetStoneValue(lastX - diffX, lastY - diffY) != 0
     && this->GetStoneValue(lastX - diffX, lastY - diffY) != 99)
  {
    return (1);
  }
  else
  {

////////////////////////////////////////////////////////////////////////////////
// Checken, ob mehr als drei Kugeln seiner Farbe in einer Reihe verschoben
// werden. Wenn ja, wird eine Fehlermeldung ausgegeben.
//
  while (this->GetStoneValue(nextX, nextY) !=0               // Wenn nchstes Feld nicht leer
        && this->GetStoneValue(nextX, nextY) !=99            // Wenn nchstes Feld existiert
        && this->GetStoneValue(nextX, nextY) == MaStoneColor)// Wenn nchstes Feld noch gleiche
  {                                                          // Farbe
    countStones++;
    nextX = nextX + diffX;
    nextY = nextY + diffY;
  }
  if (countStones > 3)
  {
    return (1);
  }

////////////////////////////////////////////////////////////////////////////////
// Checken, ob es sich um ein PATT handelt. (gleich viele Kugeln auf beiden
// Seiten. Wenn ja wird eine Fehlermeldung ausgegeben.
//

  nextX = DestX;
  nextY = DestY;
  int change=0;
  int countStoneOwn=1;
  int countStoneRival=0;

  while (this->GetStoneValue(nextX, nextY) !=0               // Wenn nchstes Feld nicht leer
        && this->GetStoneValue(nextX, nextY) !=99)            // Wenn nchstes Feld existiert
  {
    if (this->GetStoneValue(nextX - diffX,nextY - diffY) != this->GetStoneValue(nextX, nextY))
    {
      change++;
    }
    if (this->GetStoneValue(nextX, nextY) == MaStoneColor)
    {
      countStoneOwn++;
    }
    else
    {
      countStoneRival++;
    }
    nextX = nextX + diffX;
    nextY = nextY + diffY;
  }
  if (change > 1 || countStoneRival >= countStoneOwn || countStoneRival > 3 || countStoneOwn >3)
  {
    return (1);
  }

  }
  return (0);
}
//###########################################################################
//#
//# Ueberprft, ob schon ein Spieler gewonnen hat. Wenn ja, wird der Fabwert
//# der Kugel zurckgegeben, von dem Spieler der gewonnen hat.
//#
//###########################################################################
int Matrix::FindWinner()
{
  int BlackStone=0;
  int WhiteStone=0;
  for (int x=0; x<6; x++)
  {
    for (int y=0; y<5; y++)
    {
      if (RestArray[x][y] == 1)
      {
        WhiteStone++;
      }
      if (RestArray[x][y] == 2)
      {
        BlackStone++;
      }
    }
  }
  if (WhiteStone >= 6)
  {
    return (2);
  }
  if (BlackStone >= 6)
  {
    return (1);
  }
  return (99);
}
