//###########################################################################
//#
//# Diplomarbeit von Michel Jaggi / Abalone Spiel
//#
//# Datum: 22.06.2002
//#
//# Klasse Game ist die Oberklasse aller Klassen und dient als Schnitt-
//# stelle zum GUI.
//#
//###########################################################################
#include "Game.h"
#include "Unit1.h"

using namespace std;

Game::Game()
{
  abaOptions = new abaoption;
  activePlayer = new Player;
  inactivePlayer = new Player;
  Message = new IOMessages;

  abaOptions->setMaxPoints(500);
  abaOptions->setMaxTime(15);
  abaOptions->setPort(1024);

  StoneChecked = false;
}

//###########################################################################
//#
//# Ist die Methode fr ein normales zweispieler Spiel
//#
//###########################################################################
void Game::GameNormalMode()
{
  AnsiString TempName;
  if (InputQuery("Spieler 1", "Bitte Namen von Spieler 1 eingeben:", TempName))
  {
    if (TempName.Length() > 0)
    {
      this->SetActivePlayer(1);
      this->activePlayer->setName(TempName);
      this->activePlayer->setStoneC(1);
      this->activePlayer->setID(1);
      Form1->Label3->Caption=TempName;
      TempName = "";

      if (InputQuery("Spieler 2", "Bitte Namen von Spieler 2 eingeben:", TempName))
      {
        if (TempName.Length() > 0 )
        {
          Form1->TimeCounter = 0;
          this->SwitchActivePlayer();
          this->activePlayer->setName(TempName);
          this->activePlayer->setStoneC(2);
          this->activePlayer->setID(2);
          Form1->Label4->Caption=TempName;
          this->SwitchActivePlayer();

          this->SetGameState(1);
          this->DataMatrix.initValue();
          this->DataMatrix.GraphicShow(0);
          this->DataMatrix.RestShow();
        }
        else
        {
          this->Message->ShowMessage(6);
          Form1->Label3->Caption="Name 1";
          Form1->Label4->Caption="Name 2";
        }
      }
      else
      {
        Form1->Label3->Caption="Name 1";
        Form1->Label4->Caption="Name 2";
      }
    }
    else
    {
      this->Message->ShowMessage(6);
    }
  }
}
//###########################################################################
//#
//# berprft, ob sich auf dem angeklickten Feld ein Stein befindet. Wenn sich
//# ein Stein darauf befindet und er zum ersten mal angeklickt wird, verfrbt
//# er sich rot. Wird er zum zweiten mal angeklickt, nimmt er wieder die ur-
//# sprngliche Farbe ein. Ebenfalls werden die Start- und Zielkoordinaten
//# gesetzt. (SourcX, SourcY, DestX, DestY)
//#
//###########################################################################
int Game::CheckStatus(int GaXSource, int GaYSource)
{
  if (GameState == 0)
  {
    this->Message->ShowMessage(5);
    return (0);
  }
  else
  {
    if (this->DataMatrix.GetStoneValue(GaXSource, GaYSource) == 0 && StoneChecked == false)
    {
      this->Message->ShowMessage(4);
      return (0);
    }
    else
    {
      if (this->activePlayer->getStoneC() != this->DataMatrix.GetStoneValue(GaXSource, GaYSource)
      && StoneChecked == false)
      {
        this->Message->ShowMessage(7);
        return (0);
      }
      else
      {
        if (StoneChecked)    // Wenn schon ein Stein angeklickt, dann wechselt Farbe
        {                    // zu original Farbe.
          StoneChecked = false;
          if (this->DataMatrix.getSourcX() == GaXSource && this->DataMatrix.getSourcY() == GaYSource)
          {
            this->DataMatrix.setSourceX(0);
            this->DataMatrix.setSourcY(0);
            return (this->activePlayer->getStoneC()); // Die Steinfarbe wird zurckgegeben
          }
          else              // Wenn die Source Koordinaten nicht gleich den GaXSource und GaYSource
          {                 // sind, werden die Ziel Koordinaten gesetzt.
            this->DataMatrix.setDestX(GaXSource);
            this->DataMatrix.setDestY(GaYSource);
            return (0);
          }
        }
        else                 // Wenn noch kein Stein angeklickt, dann wechselt Farbe
        {                    // zu Rot Tnung
          StoneChecked = true;
          this->DataMatrix.setSourceX(GaXSource);
          this->DataMatrix.setSourcY(GaYSource);
          return (this->activePlayer->getStoneC()+2); // Die Steinfarbe der Verfrbung wird
        }                                             // zurckgegeben
      }
    }
  }
}
//###########################################################################
//#
//# Legt den aktiven Spieler fest
//#
//###########################################################################
void Game::SetActivePlayer(int GaAcitvePlayer)
{
		if (GaAcitvePlayer==1)
                {
                   activePlayer=&Player1;
                   inactivePlayer=&Player2;
                }
		if (GaAcitvePlayer==2)
                {
                   activePlayer=&Player2;
                   inactivePlayer=&Player1;
                }
}
//###########################################################################
//#
//# Wechselt zwischen dem aktiven und dem passiven Spieler
//#
//###########################################################################
void Game::SwitchActivePlayer()
{
	if ( activePlayer == &Player1)
	{
		activePlayer=&Player2;
                inactivePlayer=&Player1;
	}
	else
	{
		activePlayer=&Player1;
                inactivePlayer=&Player2;
	}
}
//###########################################################################
//#
//# Ist die Schnittstelle zwischen Formular und den Klassen. Von hier aus wir
//# das ganze Spiel gesteuert und die Daten aufgerufen und gespeichert.
//#
//###########################################################################
int Game::Play()
{
  if (this->DataMatrix.getDestX() != 0 && this->DataMatrix.getDestY() != 0)
  {
    //StoneChecked = false;
    int Error;
    int Info;
    this->SetNewGame(true);
    int TempColor = this->activePlayer->getStoneC();
    if (StoneChecked == false)
    {
      Error = this->DataMatrix.ScanRules(TempColor);
      this->Message->ShowMessage(Error);
      if (Error <= 0)
      {
        Error = this->DataMatrix.MoveStone(TempColor);
        this->Message->ShowMessage(Error);
      }
    }
    StoneChecked = false;
    this->DataMatrix.setDestX(0);
    this->DataMatrix.setDestY(0);
    this->DataMatrix.GraphicShow(this->activePlayer->getStoneC());
    Info = this->DataMatrix.FindWinner();
    if (Info < 99)
    {
      this->SetGameState(0);
      if (Info == 1)
      {
        if (this->abaOptions->getTimer() == true);
        {
          this->SetActivePlayer(1);
          Form1->Label7->Caption = IntToStr(this->activePlayer->getScore());
          Form1->Label8->Caption = IntToStr(this->inactivePlayer->getScore() - 200);
        }
        this->Message->ShowMessage(24);
      }
      if (Info == 2)
      {
        if (this->abaOptions->getTimer() == true)
        {
          this->SetActivePlayer(2);
          Form1->Label8->Caption = IntToStr(this->activePlayer->getScore());
          Form1->Label7->Caption = IntToStr(this->inactivePlayer->getScore() - 200);
        }
        this->Message->ShowMessage(25);
      }
    }
    else
    {
      if (Error <= 0)
      {
        this->SwitchActivePlayer();
      }

      Form1->Label10->Caption = this->activePlayer->getName();
      Form1->ImageList1->GetBitmap(this->activePlayer->getStoneC()-1,Form1->Image45->Picture->Bitmap);

      Form1->Image45->Refresh();
    }
  }
}
