/**********************************************************************
 *  Demonstrationsprogramm ZOOM                                       *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Das Programm demonstriert die Verwendung der Funktionen umpos_gi, *
 *  upick_gi, scapp_gi, scupdt_gi, scdap_gi und rpick_gi.             *
 *                                                                    *
 *  Es wird gezeigt, wie die Mausbewegungen in "User Coordinates"     *
 *  zu verfolgen sind und wie durch das "Aufziehen eines Rechtecks"   *
 *  ein Zoom vorbereitet wird.                                        *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define  NINT   10000      /* Anzahl der zu zeichnenden Abschnitte      */

HANDLE   hActInstance   ;  /* ... ist der an WinMain uebergebene Handle */ 
                                      
LRESULT CALLBACK WndProc    (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "Zoom" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}


LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient , zoom = 0 , vpbig = 1 ;
     int            i ;
     double         t , dt , xu , yu ;
     static double  p1x = - 4. , p1y = - 4. , p2x = 4. , p2y = 4. ;
     HDC            hdc ;
     char           str [30] ;

     switch (message)
        { 
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;  /* ... sind die Abmessungen (Pixel) des */
               cyClient = HIWORD (lParam) ;  /*     Zeichen-Fensters (Client area)   */

               return 0 ; 
                      
          case WM_COMMAND:
          
               switch (wParam)
                  {
                     case 10:           /* Zoom */
               
                        scapp_gi (hwnd , 0 , 0 , GI_CUBIGCROSS) ;
                        zoom = 1 ;      /* ... das grosse Kreuz erscheint als Cursor */
                        
                        return 0 ;
                     
                     case 20:              /* Optimale Groesse */
          
                        scdap_gi (hwnd) ;  /* ... es koennte ein "Spezial-Cursor"    */
                        p1x = - 4. ;       /* (z. B. das grosse Kreuz) noch aktiv    */
                        p1y = - 4. ;       /* sein, scdap_gi schaltet diesen ab      */ 
                        p2x =   4. ;
                        p2y =   4. ;
                        InvalidateRect (hwnd , NULL , TRUE) ;
                 
                        return 0 ;  

                     case 30:              /* Viewport gross/klein */ 
                     
                        vpbig = (vpbig == 1) ? 0 : 1 ;
                        SendMessage (hwnd , WM_COMMAND , 20 , 0) ;
                        
                        return 0 ;
                     
                     case 40:              /* Ende */
                     
                        SendMessage (hwnd , WM_CLOSE , 0 , 0) ;
                        
                        return 0 ;
                  }

          case WM_MOUSEMOVE:
               
               hdc  = GetDC (hwnd) ;

               if (umpos_gi (lParam , &xu , &yu)) /* Punkt im "Current Viewport"? */ 
                   sprintf  (str , "%6.2lf ; %6.2lf " , xu , yu) ;
               else    
                   strcpy   (str , "********      ") ;

               TextOut   (hdc  , 5 , 10 , str , strlen (str)) ;
               ReleaseDC (hwnd , hdc) ;
               
               if (zoom) scupd_gi (hwnd , lParam) ; /* ... aktualisiert Position  
                                                           des Spezial-Cursors    */
               return 0 ;
               
          case WM_LBUTTONDOWN:
               
               if (zoom)  
                 {
                    if (rpick_gi (hwnd , lParam , &p1x , &p1y , &p2x , &p2y))
                       InvalidateRect (hwnd , NULL , TRUE) ;  /* ... wird erst beim 
                                          zweiten Aufruf von rpick_gi ausgefuehrt */
                 }
               else
                 {
                    upick_gi   (hwnd , lParam , &xu , &yu) ;
                    sprintf    (str , "x = %g,  y = %g" , xu , yu) ;
                    MessageBox (hwnd , str , "Gepickter Punkt" , MB_OK) ;
                 }  

               return 0 ;  
               
          case WM_PAINT :                       
                            
               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
                                  
               if (vpbig)
                   stcvp_gi (hdc , 0 , 0 , cxClient , cyClient , GI_XYCENTER) ;
               else 
                 {
                   stcvp_gi (hdc , cxClient / 4 , cyClient / 4 , 
                                   cxClient / 2 , cyClient / 2 , GI_XYCENTER) ;
                   vfram_gi (hdc , 0) ;
                 }    
               
               stuci_gi (min (p1x,p2x) , min (p1y,p2y) , 
                         max (p1x,p2x) , max (p1y,p2y) , 10.) ;

               t  = 0. ;               
               dt = atan (1.) * 8. / NINT ;   
               
               for (i = 0 ; i <= NINT ; i++)
                 {
                    uline_gi (hdc , 4. * cos (51. * t) , 4. * sin (50. * t)) ;
                    t += dt ;
                 }   
               
               gstop_gi (hwnd) ;
                                 
               zoom = 0 ;                  
               return 0 ;

          case WM_DESTROY : 
          
               PostQuitMessage (0) ;
               
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}
