/**********************************************************************
 *  Demonstrationsprogramm VIEWPT                                     *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Auf einem (nicht gezeichneten) Kreis werden nPoints Punkte        *
 *  gleichmaessig verteilt und jeder Punkt mit jedem anderen durch    *
 *  eine Gerade verbunden, es werden also nPoints*(nPoints-1) gerade  *
 *  Linien gezeichnet. Die Anzahl der Punkte nPoints (Voreinstel-     *
 *  lung: 25) und das Verhaeltnis von Kreisdurchmesser zur kleineren  *
 *  Fensterabmessung (Voreinstellung: 0.9) koennen ueber einen        *
 *  Dialog geaendert werden.                                          *
 *                                                                    *
 *  Das Programm demonstriert die Arbeit mit den "GIW"-Routinen:      *
 *                                                                    *
 *  Die Zeichenaktionen (ausgeloest durch die WM_PAINT-Nachricht)     *
 *  werden von gstrt_gi und gstop_gi "eingerahmt", die u. a.          *
 *  die Windows-Routinen BeginPaint bzw. EndPaint aufrufen).          *
 *                                                                    *
 *  Die Routinen vmove_gi und vline_gi arbeiten mit den (Geraete-)    *
 *  Viewport-Koordinaten, die von stcvp_gi ("Set current viewport")   *
 *  definiert werden. ber den Benutzer-Dialog kann die Anzahl        *
 *  zu zeichnender Viewports (Voreinstellung beim Programmstart: 1)   *
 *  festgelegt werden. Die Viewports werden vom Programm gleich-      *
 *  maessig in ueber die Zeichenflaeche verteilt, an den Viewport-    *
 *  grenzen wird die Ausgabe geclippt.                                *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

HANDLE   hActInstance   ;  /* ... ist der an WinMain uebergebene Handle */ 

int      nPoints = 25 , nViewpx = 1 , nViewpy = 1 ;
double   QuotDiamLowDist = .9 ;

LRESULT CALLBACK WndProc    (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProc (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance , HINSTANCE hPrevInstance ,
                    LPSTR  lpszCmdLine  , int       nCmdShow)
{
     static char szAppName [] = "VIEWPT" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , szAppName , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     double         Radius , dPhi ;
     int            i , j , xs , ys ;
     static FARPROC Ptr2DialogProc ;
     HDC            hdc ;
     long           ix , iy;  /* ... werden long vereinbart, weil bei der Berechnung
                                     der Viewportgrenzen Zwischenergebnisse auftreten
                                     koennen, die groesser als der Wertebereich der
                                     int-Variablen sind                              */

     switch (message)
        { 
          case WM_CREATE : 
          
               Ptr2DialogProc = MakeProcInstance (DialogProc , hActInstance) ; 
               /* ... definiert Pointer auf die Dialogfunktion zur 
                      Abfrage von n und Radius                         */
                      
               return 0 ; 

	      case WM_COMMAND:
 
             if (wParam == 100)                 
                 {             
                   if (DialogBox (hActInstance , "VIEWPT" , hwnd , Ptr2DialogProc))
                     InvalidateRect (hwnd , NULL , TRUE) ; /* ... weil beim Verlassen
                               der Dialogbox ueber die Schaltflaeche "OK" (Function 
                               DialogBox liefert TRUE ab) die Parameter wahrscheinlich
                               geaendert wurden                                      */
                   return 0 ;
                 }                                                        
                 
             break ;    
                  
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;  /* ... sind die Abmessungen (Pixel) des */
               cyClient = HIWORD (lParam) ;  /*     Zeichen-Fensters ("Client Area") */

               return 0 ; 
               
          case WM_PAINT :                       

               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               for (ix = 0 ; ix < nViewpx ; ix++)
                 for (iy = 0 ; iy < nViewpy ; iy++)
                   {
                     stcvp_gi (hdc , (int) (cxClient * ix / nViewpx) , 
                                     (int) (cyClient * iy / nViewpy) , 
                                     (int) (cxClient / nViewpx) ,
                                     (int) (cyClient / nViewpy) , GI_XYCENTER) ;    
                     /* ... definiert den "Current Viewport" mit einem (Pixel-)Viewport-
                            Koordinatensystem in Viewportmitte                             */           
              
                     Radius = (cxClient / nViewpx > cyClient / nViewpy) ? cyClient / nViewpy : 
                                                                          cxClient / nViewpx ;
                     Radius = Radius * QuotDiamLowDist / 2 ;
                     dPhi   = atan (1.) * 8. / nPoints ;    /*     pi * 2 / nPoints        */

                     if (Radius > 10000.) Radius = 10000. ; /* Das ist eine brutale,
                       aber immerhin wirksame Moeglichkeit, Ueberlauf bei der unvermeid-
                       lichen Konvertierung auf Integer-Koordinaten zu vermeiden, bessere
                       Moeglichkeiten findet man in nachfolgenden Demonstrationsprogrammen */

                     for (i = 0 ; i < nPoints ; i++)
                       {                      
                          xs = (int) (Radius * cos (dPhi * i) + .5) ;
                          ys = (int) (Radius * sin (dPhi * i) + .5) ;
                    
                          for (j = 0 ; j < nPoints ; j++)
                            { 
                               if (j != i)
                                 {
                                   vmove_gi (hdc , xs , ys) ;
                                   vline_gi (hdc , (int) (Radius * cos (dPhi * j) + .5)  ,
                                                   (int) (Radius * sin (dPhi * j) + .5)) ;
                                 }              
                            }
                       }  
                         
                   } 
                   
               gstop_gi (hwnd) ;  
               return 0 ;

          case WM_DESTROY : 
          
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

BOOL CALLBACK DialogProc (HWND   hDlg   , UINT   message ,
                          WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       
  char    *end_p ;
  int     n ;

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12i" , nPoints) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , QuotDiamLowDist) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12i" , nViewpx) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      sprintf (StrBuff , "%12i" , nViewpy) ;
      SetDlgItemText (hDlg , 410 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            n = (int) strtol (StrBuff , &end_p , 10) ;
            if (*end_p == '\0') nPoints = n ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            QuotDiamLowDist = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            n = (int) strtol (StrBuff , &end_p , 10) ;
            if (*end_p == '\0') nViewpx = n ;
    
            GetDlgItemText (hDlg , 410 , StrBuff , 15) ; 
            n = (int) strtol (StrBuff , &end_p , 10) ;
            if (*end_p == '\0') nViewpy = n ;
    
            EndDialog (hDlg , TRUE) ; 
            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 
            return TRUE ;
        }
  }
  return FALSE ;
}
