/**********************************************************************
 *  Demonstrationsprogramm POLYAREA                                   *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Es wird der Einsatz der GIW-Routinen fuer die Darstellung von     *
 *  3D-Objekten demonstriert ("pt...-Funktionen):                     *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>                                   

double  xwe , ywe , zwe ;          /* Koordinaten des "Eye Points"    */
double  xwr , ywr , zwr ;          /* Koordinaten des Referenzpunktes */
double  xwd , ywd , zwd ;          /* Koordinaten der "Blickrichtung" */
double  pi  ;

HINSTANCE  hActInstance ;

LRESULT CALLBACK WndProc      (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcE  (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcD  (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcR  (HWND , UINT , WPARAM , LPARAM) ;
void    DrawRecursive         (GI_OBJ *) ;
 
HBRUSH  hBrush[8] ;
HDC     hdc ;
double  *xy_p ;

int WINAPI WinMain (HINSTANCE hInstance    , HINSTANCE hPrevInstance ,
                    LPSTR     lpszCmdParam , int       nCmdShow)  
{
     static char szAppName [] = "POLYAREA" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;
     pi = atan (1.) * 4. ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , "3D-Projektion und -Transformation" , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     static char    pathnm [_MAX_PATH] ;
     static char    filenm [_MAX_FNAME + _MAX_EXT] ;
     static int     nk , ne , ke , model ; 
     static double  *coord_p ;
     static int     rot = 1 , proj_chngd = 1 ;
     static GI_ELEM *re_p , *elem_p ;
     int            i , k , n ;
     static double  xumin , yumin , xumax , yumax ;
     static GI_OBJ  *robj_p = NULL , *gi_obj_p ;
     double         xc , yc , zc ; 

     switch (message)
        { 
          case WM_CREATE : 
          
             ptini_gi () ;                          /* Initialisieren und */
             prgte_gi (&xwe , &ywe , &zwe) ;        /* Erfragen der       */
             prgtr_gi (&xwr , &ywr , &zwr) ;        /* Projektions-       */
             prgtd_gi (&xwd , &ywd , &zwd) ;        /* Parameter          */   
             
             for (i = 0 ; i < 8 ; i++)
               hBrush[i] = CreateSolidBrush (mkrgb_gi (i)) ;
             
             model = rddfl_gi (hwnd , "p_wuerfl.dat" , 
                               &ne , &nk , &ke , &xy_p , &re_p) ;
                               
               /* ... versucht Datei "p_wuerfel.dat" zu lesen, bei Erfolg
                  werden mit ptmx3_gi die Extremwerte der "User Coordinates"
                  berechnet, die sich unter Anwendung der aktuellen
                  Transformation und der aktuellen Projektion aller Punkte
                  ergeben wuerden:                                        */
                                  
             if (model) ptmx3_gi (nk  , xy_p , &xumin , &xumax  , 
                                               &yumin , &yumax) ;

             flini_gi (hwnd) ;                      /* ... als Vorbeitung */
                                                    /* fuer flodl_gi      */
             return 0 ; 

	      case WM_COMMAND:
             
             switch (wParam)
               { 
                 case 10:
                   
                   if (flodl_gi (hwnd, pathnm , filenm))
                   
                         /* ... startet den typischen "Windows-Dialog" 
                            fuer die Eingabe eines File-Namens            */

                     {
                         /* Wenn vom Programm bereits ein Berechnungsmodell
                            erfolgreich eingelesen worden ist, wurde
                            Speicherplatz fuer die Knoten-Koordinaten und
                            die Elementbeschreibungen dynamisch in rddfl_gi
                            angefordert, der nun freigegeben wird:        */
                             
                       if (model)          
                         {
                            free     (xy_p) ;
                            frell_gi (re_p) ;
                         }
                   
                       model = rddfl_gi (hwnd , pathnm , 
                                         &ne , &nk , &ke , &xy_p , &re_p) ;
                                         
                         /* ... liest die Datei "pathnm" (Name wurde vom
                            "flodl_gi"-Dialog geliefert), legt dabei 
                            ausreichenden Speicherplatz fuer die Koordinaten
                            ab xy_p und fuer eine verkettete Liste mit den
                            Elementbeschreibungen (Root-Pointer re_p) an. */
                                            
                       if (model) ptmx3_gi (nk  , xy_p , &xumin , &xumax  , 
                                                         &yumin , &yumax) ;
                       proj_chngd = 1 ;
                                         
                       InvalidateRect (hwnd , NULL , TRUE) ;
                     }
                                         
                   return 0 ;

                 case 100:                 /* ... aendert Projektionstyp: */          
                               
                   if   (prgtp_gi () == GI_CENTRAL) projn_gi (GI_PARALLEL) ;
                   else                             projn_gi (GI_CENTRAL)  ;

                   proj_chngd = 1 ;
                   InvalidateRect (hwnd , NULL , TRUE) ;

                   return 0 ;
                                                                         
                 case 200:                 /* "Eye Point" aendern:        */    
                               
                   if (DialogBox (hActInstance , "EYEPOINT" , hwnd , 
                       MakeProcInstance (DialogProcE , hActInstance)))
                     {
                        proj_chngd = 1 ;
                        if (!prste_gi (xwe , ywe , zwe))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 300:                 /* "Blickrichtung" aendern:    */     
                               
                   if (DialogBox (hActInstance , "BLICKRICHTUNG" , hwnd , 
                       MakeProcInstance (DialogProcD , hActInstance)))
                     {
                        proj_chngd = 1 ;
                        if (!prstd_gi (xwd , ywd , zwd))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 400:                  /* "Referenzpunkt" aendern:   */    
                               
                   if (DialogBox (hActInstance , "REFERENZ" , hwnd , 
                       MakeProcInstance (DialogProcR , hActInstance)))
                     {
                        proj_chngd = 1 ;
                        if (!prstr_gi (xwr , ywr , zwr))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 500:           /* Zurueck zur Standard-Einstellung: */  
                               
                   ptini_gi () ;               
                   prgte_gi (&xwe , &ywe , &zwe) ;
                   prgtr_gi (&xwr , &ywr , &zwr) ;
                   prgtd_gi (&xwd , &ywd , &zwd) ;

                   proj_chngd = 1 ;
                   InvalidateRect (hwnd , NULL , TRUE) ;

                   return 0 ;
                                                                         
                 case 600:           /* Tasten x, y, z, X, Y, Z sollen    */  
                                     /* Rotationen bewirken               */
                   rot = 1 ;               
                   return 0 ;
                                                                         
                 case 700:           /* Tasten x, y, z, X, Y, Z sollen    */  
                                     /* Zranslationen bewirken            */
                   rot = 0 ;               
                   return 0 ;
                                                                         
                 case 1000:             
                               
                   SendMessage (hwnd , WM_CLOSE , 0 , 0L) ;               
                   return 0 ;
                }
                 
             break ;    
                  
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ; 

               return 0 ;
               
          case WM_CHAR :
          
               switch (wParam)
                 {
                    case 'x' :  rot ? t3rot_gi (pi / 18. , GI_AXISX) :
                                      t3trn_gi (1. , 0. , 0.) ; 
                                break ;
                    case 'X' :  rot ? t3rot_gi (- pi / 18. , GI_AXISX) :
                                      t3trn_gi (- 1. , 0. , 0.) ; 
                                break ;
                    case 'y' :  rot ? t3rot_gi (pi / 18. , GI_AXISY) :
                                      t3trn_gi (0. , 1. , 0.) ; 
                                break ;
                    case 'Y' :  rot ? t3rot_gi (- pi / 18. , GI_AXISY) :
                                      t3trn_gi (0. , - 1. , 0.) ; 
                                break ;
                    case 'z' :  rot ? t3rot_gi (pi / 18. , GI_AXISZ) :
                                      t3trn_gi (0. , 0. , 1.) ; 
                                break ;
                    case 'Z' :  rot ? t3rot_gi (- pi / 18. , GI_AXISZ) :
                                      t3trn_gi (0. , 0. , - 1.) ;
                                break ;       
                   }
                 
               proj_chngd = 1 ;
               InvalidateRect (hwnd , NULL , TRUE) ;
               
               return 0 ;        
               
          case WM_PAINT :                       

               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               if (model)
                {
                  stuci_gi (xumin , yumin , xumax , yumax , 10.) ;
                  
                    /* ... definiert "User Coordinates" nach dem mit
                       ptmx3_gi ermittelten Bedarf, sieht "10% Rand" vor  */

                  if (proj_chngd)
                    {
                       desot_gi (robj_p) ;
                       robj_p = NULL ;
                  
                       elem_p = re_p ;
                  
                       while (elem_p)              /* ... ueber alle Elemente  */
                        { 
                          xc = 0. ;
                          yc = 0. ;
                          zc = 0. ;
                          n  = elem_p->nop - 1 ;   /* Anzahl der Elementknoten */
                          
                          for (i = 0 ; i < n ; i++)
                            {
                               k = *(elem_p->param + i) - 1 ; 
                               coord_p = xy_p + k * 3 ;
                               
                               xc += *(coord_p)     ;    
                               yc += *(coord_p + 1) ;    
                               zc += *(coord_p + 2) ;    
                            } 

                          xc = xc / n ;
                          yc = yc / n ;         /* Mittelwerte der Koordinaten */
                          zc = zc / n ;         /* der Polgon-Punkte           */
                          
                          insot_gi (&robj_p , 1 , elem_p , xc , yc , zc) ; 
                          
                            /* ... fuegt ein Objekt sortiert in den binaeren
                               Baum ein.                                       */
                     
                          elem_p = elem_p->next ;
                        }
                        
                       proj_chngd = 0 ; 
                    }
                  
                  DrawRecursive (robj_p) ;
                }
               
               gstop_gi (hwnd) ;  

               return 0 ;

          case WM_DESTROY :                         
               
               for (i = 0 ; i < 8 ; i++)
                   DeleteObject (hBrush[i]) ;

               desot_gi (robj_p) ;
          
               if (model)
                 {
                    free     (xy_p) ;
                    frell_gi (re_p) ;
                 }
                   
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}


/* Grosszuegig bemessene Arbeitsfelder werden global vereinbart,
   um bei tiefer Rekursion keinen "Stack Overflow" zu riskieren
   (moeglich, weil Fuellen der Felder und Uebergeben an 
   ptfpl_gi ohne Unterbrechung durch einen rekursiven
   Aufruf der Funktion erfolgt):                               */
   
double  xpoly[40] , ypoly[40] , zpoly[40] ; 
                  
void DrawRecursive (GI_OBJ *gi_obj_p) 
{
   int        k , n , i ;
   GI_ELEM   *elem_p ;          
   double    *coord_p ;
    
   if (gi_obj_p->left) DrawRecursive (gi_obj_p->left) ; 
   
     /* ... zeichnet zuerst alle weiter entfernten Objekte, ... */
                  
   elem_p = (GI_ELEM *) gi_obj_p->data ;
                     
   n = elem_p->nop - 1 ;      
                     
   for (i = 0 ; i < n ; i++)
     {
       k = *(elem_p->param + i) - 1 ; 
       coord_p = xy_p + k * 3 ;
                                       /* ... danach mit einem  */
       xpoly[i] = *(coord_p)     ;     /* "Brush", der waehrend */
       ypoly[i] = *(coord_p + 1) ;     /* der WM_CREATE-Aktion  */    
       zpoly[i] = *(coord_p + 2) ;     /* erzeugt wird (und     */
     }                                 /* global vereinbart     */
                                       /* ist), ...             */
   SelectObject (hdc , hBrush[*(elem_p->param + n)]) ;
    
   ptfpl_gi (hdc , n , xpoly , ypoly , zpoly) ; 
   
     /* ... das aktuelle Objekt, bevor (wieder rekursiv) alle
        naeherliegenden Objekte gezeichnet werden:              */

   if (gi_obj_p->right) DrawRecursive (gi_obj_p->right) ;
}

BOOL CALLBACK DialogProcE (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwe) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywe) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwe) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwe = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywe = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwe = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}

BOOL CALLBACK DialogProcD (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwd) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywd) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwd) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwd = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywd = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwd = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}

BOOL CALLBACK DialogProcR (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwr) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywr) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwr) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwr = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywr = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwr = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}
