/**********************************************************************
 *  Demonstrationsprogramm ESCHER                                     *
 *  Autor: J. Dankert                                                 *
 *                                                                    *
 *  Es wird der Einsatz der GIW-Routinen fuer die Darstellung von     *
 *  3D-Objekten demonstriert ("pt...-Funktionen):                     *
 *                                                                    *
 **********************************************************************/ 
  
#include "..\giw\giw.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>                                   

double  xwe , ywe , zwe ;          /* Koordinaten des "Eye Points"    */
double  xwr , ywr , zwr ;          /* Koordinaten des Referenzpunktes */
double  xwd , ywd , zwd ;          /* Koordinaten der "Blickrichtung" */
double  pi  ;

HINSTANCE  hActInstance ;

LRESULT CALLBACK WndProc      (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcE  (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcD  (HWND , UINT , WPARAM , LPARAM) ;
BOOL    CALLBACK DialogProcR  (HWND , UINT , WPARAM , LPARAM) ;

int WINAPI WinMain (HINSTANCE hInstance    , HINSTANCE hPrevInstance ,
                    LPSTR     lpszCmdParam , int       nCmdShow)  
{
     static char szAppName [] = "ESCHER" ;
     HWND        hwnd ;
     MSG         msg  ;
     WNDCLASS    wndclass ;

     hActInstance = hInstance ;
     pi = atan (1.) * 4. ;              
                    
     if (!hPrevInstance)
        { wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
        }

     hwnd = CreateWindow (szAppName , "3D-Projektion und -Transformation" , WS_OVERLAPPEDWINDOW   ,
                          CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT , CW_USEDEFAULT ,
                          NULL , NULL , hInstance , NULL) ;

     ShowWindow   (hwnd , nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg , NULL , 0 , 0))
        { 
          TranslateMessage (&msg) ;
          DispatchMessage  (&msg) ;
        }                  
        
     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND   hwnd   , UINT   message , 
                          WPARAM wParam , LPARAM lParam)                
{
     static int     cxClient , cyClient ;
     static HPEN    hPenBlue ;
     static HBRUSH  hBrushCyan ;
     HDC            hdc ;
     static char    pathnm [_MAX_PATH] ;
     static char    filenm [_MAX_FNAME + _MAX_EXT] ;
     static int     nk , ne , ke , model ; 
     static double  *xy_p , *coord1_p , *coord2_p ;
     static int     rot = 1  ;
     static GI_ELEM *re_p , *elem_p ;
     int            i , k1 , k2 ;
     static double  xumin , yumin , xumax , yumax ;    

     switch (message)
        { 
          case WM_CREATE : 
          
             ptini_gi () ;                          /* Initialisieren und */
             prgte_gi (&xwe , &ywe , &zwe) ;        /* Erfragen der       */
             prgtr_gi (&xwr , &ywr , &zwr) ;        /* Projektions-       */
             prgtd_gi (&xwd , &ywd , &zwd) ;        /* Parameter          */   
             
             hPenBlue   = CreatePen (PS_SOLID , 1 , mkrgb_gi (GI_BLUE)) ;
             hBrushCyan = CreateSolidBrush (mkrgb_gi (GI_CYAN)) ;
             
             model = rddfl_gi (hwnd , "d_wuerfl.dat" , 
                               &ne , &nk , &ke , &xy_p , &re_p) ;
                               
               /* ... versucht Datei "d_wuerfel.dat" zu lesen, bei Erfolg
                  werden mit ptmx3_gi die Extremwerte der "User Coordinates"
                  berechnet, die sich unter Anwendung der aktuellen
                  Transformation und der aktuellen Projektion aller Punkte
                  ergeben wuerden:                                        */
                                  
             if (model) ptmx3_gi (nk  , xy_p , &xumin , &xumax  , 
                                               &yumin , &yumax) ;

             flini_gi (hwnd) ;                      /* ... als Vorbeitung */
                                                    /* fuer flodl_gi      */
             return 0 ; 

	      case WM_COMMAND:
             
             switch (wParam)
               { 
                 case 10:
                   
                   if (flodl_gi (hwnd, pathnm , filenm))
                   
                         /* ... startet den typischen "Windows-Dialog" 
                            fuer die Eingabe eines File-Namens            */

                     {
                         /* Wenn vom Programm bereits ein Berechnungsmodell
                            erfolgreich eingelesen worden ist, wurde
                            Speicherplatz fuer die Knoten-Koordinaten und
                            die Elementbeschreibungen dynamisch in rddfl_gi
                            angefordert, der nun freigegeben wird:        */
                             
                       if (model)          
                         {
                            free     (xy_p) ;
                            frell_gi (re_p) ;  /* ... loescht die gesamte */
                         }                     /* verkettete Liste        */
                   
                       model = rddfl_gi (hwnd , pathnm , 
                                         &ne , &nk , &ke , &xy_p , &re_p) ;
                                         
                         /* ... liest die Datei "pathnm" (Name wurde vom
                            "flodl_gi"-Dialog geliefert), legt dabei 
                            ausreichenden Speicherplatz fuer die Koordinaten
                            ab xy_p und fuer eine verkettete Liste mit den
                            Elementbeschreibungen (Root-Pointer re_p) an. */
                                            
                       if (model) ptmx3_gi (nk  , xy_p , &xumin , &xumax  , 
                                                         &yumin , &yumax) ;
                                         
                       InvalidateRect (hwnd , NULL , TRUE) ;
                     }
                                         
                   return 0 ;

                 case 100:                 /* ... aendert Projektionstyp: */          
                               
                   if   (prgtp_gi () == GI_CENTRAL) projn_gi (GI_PARALLEL) ;
                   else                             projn_gi (GI_CENTRAL)  ;

                   InvalidateRect (hwnd , NULL , TRUE) ;

                   return 0 ;
                                                                         
                 case 200:                 /* "Eye Point" aendern:        */    
                               
                   if (DialogBox (hActInstance , "EYEPOINT" , hwnd , 
                       MakeProcInstance (DialogProcE , hActInstance)))
                     {
                        if (!prste_gi (xwe , ywe , zwe))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 300:                 /* "Blickrichtung" aendern:    */     
                               
                   if (DialogBox (hActInstance , "BLICKRICHTUNG" , hwnd , 
                       MakeProcInstance (DialogProcD , hActInstance)))
                     {
                        if (!prstd_gi (xwd , ywd , zwd))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 400:                  /* "Referenzpunkt" aendern:   */    
                               
                   if (DialogBox (hActInstance , "REFERENZ" , hwnd , 
                       MakeProcInstance (DialogProcR , hActInstance)))
                     {
                        if (!prstr_gi (xwr , ywr , zwr))
                            MessageBox (hwnd , "Setzen der Projektion ist milungen!" ,
                                               "Sorry" , MB_ICONINFORMATION | MB_OK) ;    
                        else  
                            InvalidateRect (hwnd , NULL , TRUE) ;
                     }           

                   return 0 ;
                                                                         
                 case 500:           /* Zurueck zur Standard-Einstellung: */  
                               
                   ptini_gi () ;               
                   prgte_gi (&xwe , &ywe , &zwe) ;
                   prgtr_gi (&xwr , &ywr , &zwr) ;
                   prgtd_gi (&xwd , &ywd , &zwd) ;

                   InvalidateRect (hwnd , NULL , TRUE) ;

                   return 0 ;
                                                                         
                 case 600:           /* Tasten x, y, z, X, Y, Z sollen    */  
                                     /* Rotationen bewirken               */
                   rot = 1 ;               
                   return 0 ;
                                                                         
                 case 700:           /* Tasten x, y, z, X, Y, Z sollen    */  
                                     /* Zranslationen bewirken            */
                   rot = 0 ;               
                   return 0 ;
                                                                         
                 case 1000:             
                               
                   SendMessage (hwnd , WM_CLOSE , 0 , 0L) ;               
                   return 0 ;
                }
                 
             break ;    
                  
          case WM_SIZE :
          
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ; 

               return 0 ;
               
          case WM_CHAR :
          
               switch (wParam)
                 {
                    case 'x' :  rot ? t3rot_gi (pi / 18. , GI_AXISX) :
                                      t3trn_gi (1. , 0. , 0.) ; 
                                break ;
                    case 'X' :  rot ? t3rot_gi (- pi / 18. , GI_AXISX) :
                                      t3trn_gi (- 1. , 0. , 0.) ; 
                                break ;
                    case 'y' :  rot ? t3rot_gi (pi / 18. , GI_AXISY) :
                                      t3trn_gi (0. , 1. , 0.) ; 
                                break ;
                    case 'Y' :  rot ? t3rot_gi (- pi / 18. , GI_AXISY) :
                                      t3trn_gi (0. , - 1. , 0.) ; 
                                break ;
                    case 'z' :  rot ? t3rot_gi (pi / 18. , GI_AXISZ) :
                                      t3trn_gi (0. , 0. , 1.) ; 
                                break ;
                    case 'Z' :  rot ? t3rot_gi (- pi / 18. , GI_AXISZ) :
                                      t3trn_gi (0. , 0. , - 1.) ;
                                break ;       
                   }
                 
               InvalidateRect (hwnd , NULL , TRUE) ;
               
               return 0 ;        
               
          case WM_PAINT :                       

               hdc = gstrt_gi (hwnd , cxClient , cyClient) ;
               
               if (model)
                {
                  stuci_gi (xumin , yumin , xumax , yumax , 10.) ;
                  
                    /* ... definiert "User Coordinates" nach dem mit
                       ptmx3_gi ermittelten Bedarf, sieht "10% Rand" vor  */
                       
                  SelectObject (hdc , hPenBlue)     ; 
                  SelectObject (hdc , hBrushCyan) ; 
                  
                  elem_p = re_p ;
                  
                  while (elem_p)                     /* ... alle Elemente */
                   {                
                     k1 = *(elem_p->param)     - 1 ;   /* ... zugehoerige */
                     k2 = *(elem_p->param + 1) - 1 ;   /* Knotennummern   */
                     
                     coord1_p = xy_p + k1 * 3 ;  
                     coord2_p = xy_p + k2 * 3 ;
                     ptwdl_gi (hdc , *coord1_p , *(coord1_p+1) , *(coord1_p+2) ,
                                     *coord2_p , *(coord2_p+1) , *(coord2_p+2) ,
                                     5 , mkrgb_gi (GI_BLACK) , 1 , mkrgb_gi (GI_YELLOW)) ;
                     
                     elem_p = elem_p->next ;
                   }
                   
                  for (i = 0 ; i < nk ; i++)         /* ... alle Knoten   */
                   {                 
                     coord1_p = xy_p + i * 3 ;

                     ptmrk_gi (hdc , GI_MKFCIRCLE , 1. , 
                               *coord1_p , *(coord1_p+1) , *(coord1_p+2) , 0) ;

                         /* ... zeichnet Marker (gefuellten Kreis) in
                            Standard-Groesse                              */       
                   }
                }
               
               gstop_gi (hwnd) ;  

               return 0 ;

          case WM_DESTROY :                         
          
               DeleteObject (hPenBlue)     ;
               DeleteObject (hBrushCyan) ;
          
               if (model)
                 {
                    free     (xy_p) ;
                    frell_gi (re_p) ;
                 }
                   
               PostQuitMessage (0) ;
               return 0 ;
        }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

BOOL CALLBACK DialogProcE (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwe) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywe) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwe) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwe = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywe = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwe = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}

BOOL CALLBACK DialogProcD (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwd) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywd) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwd) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwd = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywd = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwd = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}

BOOL CALLBACK DialogProcR (HWND   hDlg   , UINT   message ,
                           WPARAM wParam , LPARAM lParam)
{
  char    StrBuff [15] ;                       

  switch (message)
  {                   
    case WM_INITDIALOG:
    
      sprintf (StrBuff , "%12g" , xwr) ;
      SetDlgItemText (hDlg , 110 , StrBuff) ;
  
      sprintf (StrBuff , "%12g" , ywr) ;
      SetDlgItemText (hDlg , 210 , StrBuff) ;                                             
      
      sprintf (StrBuff , "%12g" , zwr) ;
      SetDlgItemText (hDlg , 310 , StrBuff) ;
  
      return TRUE ;
  
    case WM_COMMAND:            
                                   
      switch (wParam)
        {            
          case IDOK: 
                     
            GetDlgItemText (hDlg , 110 , StrBuff , 15) ; 
            xwr = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 210 , StrBuff , 15) ; 
            ywr = atof (StrBuff) ;
    
            GetDlgItemText (hDlg , 310 , StrBuff , 15) ; 
            zwr = atof (StrBuff) ;
    
            EndDialog (hDlg , TRUE) ; 

            return TRUE ;
            
          case IDCANCEL:  
                          
            EndDialog (hDlg , FALSE) ; 

            return TRUE ;
        }
  }
  return FALSE ;
}
