/*!
	@class		NewSms
	@brief		Zeigt einen "NewSms" Dialog an.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-07
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		newsms.h
*/


#ifndef NEWSMS_H
#define NEWSMS_H


#include "newsmsdlg.h"


/**
  * Zeigt einen "NewSms" Dialog und sendet die Eingaben an BluePhone. 
  */
class NewSms : public FormNewSmsDlg
{
	Q_OBJECT

public:
	/**
   	  * Erstellt einen NewSmsDlg.
  	  * Falle eine Antwort geschickt wird, erwartet der Konstruktor die Daten der selektierten Message.
  	  * Meine Parameter: QString Mode, Receiver, Message
  	  */
	NewSms(QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0,
			const QString& Mode = "new", const QString& Receiver = 0, const QString& Message = 0 );
	
	/**
   	  * NewSms Destruktor
   	  */
	~NewSms();

	
signals:
	/** 
  	  * Diese Signal sendet die Daten des SMS an Bluephone.
  	  */
    void transmitSms(const QString&, const QString&, int, int);

	/** 
  	  * Dieses Signal setzt (diese "leuchtet") die gruene LED von BluePhone.
  	  */
    void transmitLedStateGreen();

			
public slots:
	/** 
  	  * Dieser Slot liest die Eingabefelder des Dialoges ein und sendet das Resultat via transmitSms an Bluephone.
  	  */
	virtual void          readSms();
	
	/** 
  	  * Dieser Slot updated die Felder lineEditNewSmsCharsLeft und lineEditNewSmsCount, 
 	  * wenn in textEditNewSmsMessage eine Aenderung geschieht.
  	  */
	virtual void          updateCharsLeft();
	
	/** 
 	  * Dieser Slot schliesst den Dialog.
 	  */
	virtual void          closeDialog();
	
	
	
protected:
	

protected slots:


private:
	/** 
	  * Beinhaltet die Werte des neuen SMS.  
	  */
	QString m_phoneSmsNumber, m_phoneSmsMessage;

	/** 
	  * Beinhaltet Werte eines neuen SMS.
	  * Der index wird fuer ueberlange SMS benoetigt, die ID ist eine random Zahl.
	  */
	int m_charCount, m_smsCount, m_index, m_id;
	
	/** 
	  * Beinhaltet die Werte fuer die "Needed SMS" und "Chars left" Anzeigen.  
	  */
	QString m_smsCounterStr, m_charsLeftStr;
	
	/** 
	  * Hilfsvariable zwecks Berechnung der Werte fuer die "Needed SMS" und "Chars left" Anzeigen.
	  */
	unsigned int m_charsInMessage, m_smsCounter, m_charsLeft;

};


#endif



