/*!
	@class		NewSms
	@brief		Zeigt einen "NewSms" Dialog an.
	@author  	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-07
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		newsms.cpp
*/


#include "newsms.h"

#include <qlineedit.h>
#include <qtextedit.h>


/**
  * Erstellt einen NewSmsDlg.
  * Falle eine Antwort geschickt wird, erwartet der Konstruktor die Daten der selektierten Message.
  * Meine Parameter: QString Mode, Receiver, Message
  */
NewSms::NewSms(QWidget* parent, const char* name, bool modal, WFlags fl, 
				const QString& Mode, const QString& Receiver, const QString& Message)
		: FormNewSmsDlg(parent,name, modal,fl)
{
	/* wird ein neues SMS geschickt oder ein erhaltenes beantwortet oder ein neues aus der Kontaktliste erstellt? */
	if ( Mode == "new" )
	{		
		/* setze den Titel des Dialoges */
		setCaption("New SMS");	
	}
	else if ( Mode == "reply" )
	{
		/* Parameter in die privaten Variablen abspeichern. */
		m_phoneSmsNumber = Receiver;
		m_phoneSmsMessage = Message;
		
		m_phoneSmsMessage.prepend("\nYou wrote: \n");
		
		/* fuelle die Werte in den NewSmsDlg ab. */
		lineEditNewSmsNumber->setText(m_phoneSmsNumber);
		textEditNewSmsMessage->setText(m_phoneSmsMessage);
		
		/* setze den Titel des Dialoges */
		setCaption("Reply SMS");
	}
	else if ( Mode == "fromcontact" )
	{
		/* Parameter in die private Variable abspeichern. */
		m_phoneSmsNumber = Receiver;
		
		/* fuelle den Wert in den NewSmsDlg ab. */
		lineEditNewSmsNumber->setText(m_phoneSmsNumber);
		
		/* setze den Titel des Dialoges */
		setCaption("New SMS");
	}	
}


/**
  * NewSms Destruktor
  */
NewSms::~NewSms()
{
}


/** 
  * Dieser Slot liest die Eingabefelder des Dialoges ein und sendet das Resultat via transmitSms an Bluephone.
  */
void NewSms::readSms()
{
	/* lese die Eingabefelder ein */
	m_phoneSmsNumber = lineEditNewSmsNumber->text();
	m_phoneSmsMessage = textEditNewSmsMessage->text();
	
	/* ermittle die Laenge der Message */
	m_charCount = m_phoneSmsMessage.length();
	
	/* Je nach Anzahl Zeichen der Message, muessen ein, zwei oder noch mehr SMS erstellt werden. */
	if ( m_charCount < 160 )
	{
		m_smsCount = 1;
	}
	else 
	{
		m_smsCount = m_charCount / 153;
	}
	
	if ( m_charCount % 153 && m_charCount > 160 )
	{
		m_smsCount++;
	}
	
	/* Erstelle eine Random Inteter fuer die Message ID.
	   Ist fuer das Telephon. Es verweiget die Annahme einer Nachricht, 
	   wenn es pro Session die selbe ID zweimal bekommt. Der eigentliche Wert der ID ist aber egal. */
	m_id=(int) (256.0*rand()/(RAND_MAX+1.0));
	
	
	/* sende das Resultat an Bluephone. Bei ueberlangen SMS wird dies mehrfach ausgeloest. */
	for (m_index = 1; m_index <= m_smsCount; m_index++)
	{ 
		emit transmitSms(m_phoneSmsNumber, m_phoneSmsMessage, m_index, m_id);
	}
	
	/* Setzte die LED auf gruen zurueck */
	emit transmitLedStateGreen();
	
	this->close();
}

  
/** 
  * Dieser Slot updated die Felder lineEditNewSmsCharsLeft und lineEditNewSmsCount, 
  * wenn in textEditNewSmsMessage eine Aenderung geschieht.
  */
void NewSms::updateCharsLeft()
{	
	/* hole die Anzahl Zeichen im Textfeld */
	m_charsInMessage = textEditNewSmsMessage->text().length();
	
	/* Berechne die benoetigte Anzahl SMS und die restlichen Zeichen im aktuellen SMS. */
	m_smsCounter = m_charsInMessage / 160;
	m_charsLeft = m_charsInMessage - (m_smsCounter * 160);
  	m_charsLeft = 160 - m_charsLeft;
	m_smsCounter = 1 + m_smsCounter;
	
	/* Wandle die Resultate in Strings um. */
  	m_charsLeftStr.setNum(m_charsLeft);
  	m_smsCounterStr.setNum(m_smsCounter);
  	
	/* fuelle die Werte in den NewSmsDlg ab. */
	lineEditNewSmsCharsLeft->setText(m_charsLeftStr);
	lineEditNewSmsCount->setText(m_smsCounterStr);
}


/** 
  * Dieser Slot schliesst den Dialog.
  */
void NewSms::closeDialog()
{	
	/* Setzte die LED auf gruen zurueck */
	emit transmitLedStateGreen();
	
	this->close();
}


#include "newsms.moc"


