/*!
	@class		NewContact
	@brief		Zeigt einen "NewContact" Dialog.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-05
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		newcontact.h
*/

#ifndef NEWCONTACT_H
#define NEWCONTACT_H

#include "newcontactdlg.h"



/**
  * Zeigt einen "NewContact" Dialog und sendet die Eingaben an BluePhone. 
  * Ich verwende fuer Edit den selben Dialog wie fuer New.
  * Via Konstruktor (Mode) wird definiert, welchen Modus der Dialog hat.
  */
class NewContact : public FormNewContactDlg
{
	Q_OBJECT

public:
	/**
     * Erstellt einen NewContactDlg.
     * Falle editiert wird, erwartet der Konstruktor die Daten des selektierten Eintrages.
     * Meine Parameter: QString Mode, ContactId, ContactType, ContactName, ContactNumber
     *
     */
	NewContact(QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0,  const QString& Mode = "new",
					const QString& ContactId = 0, const QString& ContactType = 0, const QString& ContactName = 0, const QString& ContactNumber = 0);
	
					
	/**
   	  * NewContact Destruktor
   	  */
	~NewContact();
	
			
signals:
	/** 
  	  * Diese Signal sendet die Daten des Eintrages an Bluephone.
  	  */
    void transmitContact(const QString&, const QString&, const QString&, const QString&);

	/** 
  	  * Dieses Signal setzt (diese "leuchtet") die gruene LED von BluePhone.
  	  */
    void transmitLedStateGreen();
	
	
public slots:
	/** 
  	  * Dieser Slot liest die Eingabefelder des Dialoges ein und sendet das Resultat via transmitContact an Bluephone.
  	  */
	virtual void          readContact();

	/** 
 	  * Dieser Slot schliesst den Dialog.
 	  */
	virtual void          closeDialog();


protected:

	
protected slots:	
    
	
private:
	/** 
	  * Beinhaltet Werte des neuen Kontaktes.  
	  */
	QString m_phoneContactId, m_phoneContactType, m_phoneContactName, m_phoneContactNumber;
	
};

#endif

