/*!
	@class		NewContact
	@brief		Zeigt einen "NewContact" Dialog.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-05
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		newcontact.cpp
*/


#include "newcontact.h"

#include <qlineedit.h>
#include <qcombobox.h>


/**
  * NewContact Konstruktor
  * Erstellt einen NewContactDlg.
  * Falle editiert wird, erwartet der Konstruktor die Daten des selektierten Eintrages.
  * Meine Parameter: QString Mode, ContactId, ContactType, ContactName, ContactNumber
  *
  */
NewContact::NewContact(QWidget* parent, const char* name, bool modal, WFlags fl, const QString& Mode, 
						const QString& ContactId, const QString& ContactType, const QString& ContactName, const QString& ContactNumber)
		: FormNewContactDlg(parent,name, modal,fl)
{
	/* wird ein bestehenden Kontakt editiert oder ein neuer erstellt? */
	if ( Mode == "new" )
	{
		/* Es wird ein neuer Kontakt hinzugefuegt, die Id des Eintrages generiert das Telephon. */
		m_phoneContactId = "generate";
		
		/* setze den Titel des Dialoges */
		setCaption("New Contact");	
	}
	else if ( Mode == "edit" )
	{
		/* Parameter in die privaten Variablen abspeichern. */
		m_phoneContactId = ContactId;
		m_phoneContactType = ContactType;
		m_phoneContactName = ContactName;
		m_phoneContactNumber = ContactNumber;

		/* fuelle die Werte in den NewContactDlg ab. */

		if ( m_phoneContactType == "Home" )
		{ comboBoxNewContactType->setCurrentItem(0); }
		else if ( m_phoneContactType == "Work" )
		{ comboBoxNewContactType->setCurrentItem(1); }
		else if ( m_phoneContactType == "Mobile" )
		{ comboBoxNewContactType->setCurrentItem(2); }
		else if ( m_phoneContactType == "Fax" )
		{ comboBoxNewContactType->setCurrentItem(3); }
		else 
		{ comboBoxNewContactType->setCurrentItem(4); }
		
		lineEditNewContactName->setText(m_phoneContactName);
		lineEditNewContactNumber->setText(m_phoneContactNumber);
		
		/* setze den Titel des Dialoges */
		setCaption("Edit Contact");
	}
}


/**
  * NewContact Destruktor
  */
NewContact::~NewContact()
{
}


/** 
  * Dieser Slot liest die Eingabefelder des Dialoges ein und sendet das Resultat via transmitContact an Bluephone.
  */
void NewContact::readContact()
{		
	/* lese die restlichen Eingabefelder ein */
	m_phoneContactType = comboBoxNewContactType->currentText();
	m_phoneContactName = lineEditNewContactName->text();
	m_phoneContactNumber = lineEditNewContactNumber->text();
	
	if ( m_phoneContactType == "Home" )
	{ m_phoneContactType = "H"; }
	else if ( m_phoneContactType == "Work" )
	{ m_phoneContactType = "W"; }
	else if ( m_phoneContactType == "Mobile" )
	{ m_phoneContactType = "M"; }
	else if ( m_phoneContactType == "Fax" )
	{ m_phoneContactType = "F"; }
	else 
	{ m_phoneContactType = "O"; }
		
	/* sende das Resultat an Bluephone */
	emit transmitContact(m_phoneContactId, m_phoneContactType, m_phoneContactName, m_phoneContactNumber);

	/* Setzte die LED auf gruen zurueck */
	emit transmitLedStateGreen();

	this->close();
}


/** 
  * Dieser Slot schliesst den Dialog.
  */
void NewContact::closeDialog()
{	
	/* Setzte die LED auf gruen zurueck */
	emit transmitLedStateGreen();
	
	this->close();
}


#include "newcontact.moc"

