/*!
	@class		Main
	@brief		Enthaelt die main Funktion von BluePhone.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-05-07
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		main.cpp
*/


#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "bluephone.h"


static const char description[] =
    I18N_NOOP("BluePhone - A tool to run a Sony Ericsson mobile phone from a PC.");

static const char version[] = "1.0";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("bluephone", I18N_NOOP("BluePhone"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Thomas Gemperli", 0, "http://www.gemperli.net", "bluephone@gemperli.net");
    about.addAuthor( "Thomas Gemperli", 0, "bluephone@gemperli.net" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    BluePhone *mainWin = 0;

    mainWin = new BluePhone();
    app.setMainWidget( mainWin );
    mainWin->show();

    /* mainWin has WDestructiveClose flag by default, so it will delete itself. */
    return app.exec();
}

