/*!
	@class		BlueSettings
	@brief		Speichert die Einstellungen von BluePhone.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-03
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		bluesettings.h
*/


#ifndef BLUESETTINGS_H
#define BLUESETTINGS_H


#include "bluephone.h"
#include <qstring.h>
#include <qstringlist.h>



/**
  * Dese Klasse speichert die Einstellungen von BluePhone unter Verwendung von KConfig ab.
  * Das Konfigurationsfile liegt in ~/.kde/share/config/bluephonerc.
  */
class BlueSettings 
{

public:
	/**
 	  * Erstellt ein BlueSettings Objekt.
 	  */
    BlueSettings();
	
	/**
 	  * BlueSettings Destruktor.
 	  */
    ~BlueSettings();
	
	
	/** 
 	  * Diese Methode schreibt das Konfigurationsfile von BluePhone.
	  * Das Konfigurationsfile liegt in ~/.kde/share/config/bluephonerc.
  	  * Parameter: QString settingsDevice, QString settingsBtAddress, int settingsBtChannel, QString settingsConnectStartup
 	  */
	void writeSettings(QString settingsDevice, QString settingsBtAddress, int settingsBtChannel, QString settingsConnectStartup);
	
	
	/** 
	  * Diese Methode liest das Konfigurationsfile von BluePhone aus.
 	  * Das Konfigurationsfile liegt in ~/.kde/share/config/bluephonerc.
 	  * Rueckgabewert: QString AllSettings
  	  */
	QString readSettings();
	


private:

	
	/** 
	  * Beinhaltet alle Konfigurations Settings. 
	  */
	QStringList m_settingsAllList;
	
	/** 
	  * Beinhaltet alle Konfigurations Settings. 
	  */
	QString m_settingsAll, m_settingsDevice, m_settingsBtAddress, m_settingsBtChannel, m_settingsConnectStartup;

};


#endif



