/*!
	@class		BlueSettings
	@brief		Speichert die Einstellungen von BluePhone.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-03
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		bluesettings.cpp
*/


#include "bluesettings.h"
#include <kconfig.h> 
#include <kapp.h>


/**
  * BlueSettings Konstruktor.
  * Erstellt ein BlueSettings Objekt.
  */
BlueSettings::BlueSettings()
{

}


/**
  * BlueSettings Destruktor.
  */
BlueSettings::~BlueSettings()
{
}


/** 
  * Diese Methode schreibt das Konfigurationsfile von BluePhone.
  * Das Konfigurationsfile liegt in ~/.kde/share/config/bluephonerc
  * Parameter: QString settingsDevice, QString settingsBtAddress, int settingsBtChannel, QString settingsConnectStartup
  */
void BlueSettings::writeSettings(QString settingsDevice, QString settingsBtAddress, int settingsBtChannel, QString settingsConnectStartup)
{
	/* Erstelle einen Zeiger auf die Config Methode von kapp. */
	KConfig *settings = kapp->config();
	
	/* Spitze die Werte ab. */
	settings->setGroup("Main");
	
	settings->writeEntry("Device", settingsDevice);
	settings->writeEntry("BtAddress", settingsBtAddress);
	settings->writeEntry("BtChannel", settingsBtChannel);
	settings->writeEntry("ConnectOnStartUp", settingsConnectStartup);
	
	/* Schreibe die Werte in das Configfile. */
	settings->sync();
}



/** 
  * Diese Methode liest das Konfigurationsfile von BluePhone aus.
  * Das Konfigurationsfile liegt in ~/.kde/share/config/bluephonerc
  * Rueckgabewert: QString AllSettings
  */
QString BlueSettings::readSettings()
{
	/* Erstelle einen Zeiger auf die Config Methode von kapp. */
	KConfig *settings = kapp->config();
	
	/* Lese die Werte aus dem Configfile aus. */
	settings->setGroup("Main");
	
	m_settingsDevice = settings->readEntry("Device");
	m_settingsBtAddress = settings->readEntry("BtAddress");
	m_settingsBtChannel = settings->readEntry("BtChannel");
	m_settingsConnectStartup = settings->readEntry("ConnectOnStartUp");
	
	/* Erstelle eine Liste aus allen Werten und liefere sie an den Aufrufer zurueck . */	
	m_settingsAllList.append(m_settingsDevice);
	m_settingsAllList.append(m_settingsBtAddress);
	m_settingsAllList.append(m_settingsBtChannel);
	m_settingsAllList.append(m_settingsConnectStartup);
	m_settingsAll = m_settingsAllList.join(",");

	return m_settingsAll;

}



