/*!
	@class		BluePhone
	@brief		Hauptklasse von BluePhone.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-03
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		bluephone.h
*/


#ifndef BLUEPHONE_H
#define BLUEPHONE_H


/**
  * In bluephonedlg.h stecken saemtliche Informationen und Includes, die ich fuer und von meiner Form benoetige.
  * Dieses File wird (unter anderen) von QT Designer aus einem xml File (.ui) generiert. Danke Designer. :)
  */
#include "bluephonedlg.h"

#include "bluelink.h"
#include "bluesettings.h"
#include "blueconvert.h"
#include "blueobex.h"
#include "newcontact.h"
#include "newsms.h"


/**
  * Dies ist die Basisklasse von BluePhone, von ihr aus wird die ganze Applikation gesteuert.
  * Diese Klasse enthaelt saemtliche Slots & Signals, die von QT-Designer waehrend des UI-Designs erstellt wurden.
  */
class BluePhone : public FormBluePhone
{
	Q_OBJECT

public:
	/**
     * Erstellt das QWidget Objekt BluePhone im Hauptfenster.
     */
	BluePhone(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	
	/**
     * BluePhone Destruktor.
     */	
	~BluePhone();
	
	/** 
	  * Diese Methode liest, falls vorhanden, die aktuellen Settings aus dem Configfile ein. 
	  */
	void readSettings();
	
	/** 
	  * Diese Methode updatet das "Settings" Tab mit den aktuellen Settings. 
	  */
	void setSettingsView();
		
	/** 
  	  * Diese Methode liest Informationen ueber eine File aus
  	  * und stellt diese im Tab "File" dar.
  	  * Parameter: QString "Pfad zur Datei"
  	  */
	void showMetaInfo(const QString&);
	
	
	
public slots:	 
	
	/**
	  * Dieser Slot speichert die Settings.
  	  * Die Configuration wird in ~/.kde/share/config/bluephonerc gesichert
	  */
	virtual void          settingsSave();
	
	/**
 	  * Dieser Slot zeigt eine Messagebox an, die erklaert, wie die Bluetooth Adresse des Telephons gefunden werden kann.
 	  */
	virtual void          settingsGetAddress();
	
	/**
  	  * Dieser Slot erstellt ein neues SMS an den selektierten Kontakt.
  	  */
	virtual void          contactsSms();
	
	/** 
  	  * Dieser Slot ruft den selektierten Kontakt an. 
 	  */
	virtual void          contactsCall();
	
	/** 
  	  * Dieser Slot ueberschreibt das Telephonbuch auf dem Telephon mit einem Backup.  
 	  */
	virtual void          contactsRestore();
	
	/** 
   	  * Dieser Slot erstellt ein Textfile Backup aus allen Kontakten. 
 	  */
	virtual void          contactsBackup();
	
	/** 
	  * Dieser Slot loescht den selektierten Kontakt. 
 	  */
	virtual void          contactsDelete();
	
	/** 
     * Dieser Slot editiert den selektierten Kontakt. 
     */
	virtual void          contactsEdit();
	
	/**
 	  * Dieser Slot erstellt einen neuen Kontakt.
 	  */
	virtual void          contactsNew();
	
	/**
 	  * Dieser Slot liest das Telephonbuch des Telephons ein.
 	  */
	virtual void          contactsRead();
		
	/**
 	  * Dieser Slot erstellt ein neues SMS.
 	  */
	virtual void          smsNew();
	
	/**
	  * Dieser Slot loescht alle SMS auf dem Telephon.
	  */	
	virtual void          smsDeleteAll();
	
	/**
	  * Dieser Slot loescht ein SMS.
 	  */	
	virtual void          smsDelete();
	
	/**
 	  * Dieser Slot speichert alle Kurznachrichten in einem Textfile ab.
 	  */	
	virtual void          smsSaveAll();
	
	/**
  	  * Dieser Slot speichert eine Kurznachricht in einem Textfile ab.
  	  */
	virtual void          smsSave();
	
	/**
	  * Dieser Slot liest die Kurznachrichten vom Telephon ein.
	  */	
	virtual void          smsRead();
	
	/**
	  * Dieser Slot zeigt eine Nachricht in einer Messagebox an.
	  */	
	virtual void          smsShow();
	
	/**
	  * Dieser Slot bietet die Moeglichkeit, eine Nachricht zu beantworteten.
	  */	
	virtual void          smsReply();
	
	/**
 	  * Dieser Slot sendet, ueber Obex, eine Datei an das Telphon. 
 	  */
	virtual void          fileSend();
	
	/**
	  * Dieser Slot dient zum Auswaehlen der Datei, die an das Telphon geschickt werden soll. 
  	  */	
	virtual void          fileBrowse();
	
	/**
 	  * Dieser Slot liest einige generelle Informationen aus dem Telephon aus.
	  * Diese sind: Hersteller, Modell, Revision, Status, Batterieladung
 	  */
	virtual void          phoneGetInfo();
	
	/**
 	  * Dieser Slot schliesst die Verbindung mit dem Telephon.
 	  */
	virtual void          phoneDisconnect();
	
	/**
 	  * Dieser Slot verbindet BluePhone mit dem Telephon.
 	  * Die Logik dieses Slots ist in BlueLink.
  	  */
	virtual void          phoneConnect();
	
	/**
 	  * Dieser Slot zeigt die "About" Messagebox an.
 	  */
	virtual void          helpAbout();
	
	/**
 	  * Diesr Slot beendet das Programm.
 	  */
	virtual void          fileExit();
	
   /** 
	 * Dieser Slot setzt die gruene LED rsp. diese "leuchtet", falls die Verbindung zum Telephon steht.
	 */
	virtual void          setLedGreen();
	
	/** 
	  * Dieser Slot setzt die orange LED rsp. diese "leuchtet" , falls die Verbindung zum Telephon steht.
	  */
	virtual void          setLedOrange();
	
	/** 
	  * Dieser Slot etzt die rote LED rsp. diese "leuchtet". 
	  */
	virtual void          setLedRed();
	
	/**
 	  * Dieser Slot sendet einen neuen oder editierten Kontakt an das Telephon.
 	  * Parameter: QString ContactId, ContactType, ContactName, ContactNumber
	  */
	virtual void          sendContactToPhone(const QString&, const QString&, const QString&, const QString&);
	
	/**
 	  * Dieser Slot sendet ein SMS an das Telephon.
 	  * Parameter: QString Receiver, QString Message, int index, int id
	  */
	virtual void          sendSmsToPhone(const QString&, const QString&, int, int);

	
			
protected:

	
protected slots:	

	
private:
	/** 
	  * BluePhone Vesion. 
	  */
	QString version;

	/** 
	  * Erstellt ein BlueLink Objekt. 
	  */
	BlueLink myLink;
	
	/** 
	  * Erstellt ein BlueConvert Objekt. 
	  */
	BlueConvert myConvert;
					
	/** 
	  * Zeiger auf ezv24 Objekt "Port". 
	  * Siehe http://ezv24.sourceforge.net/api-html fuer weitere Informationen.
	  */
	v24_port_t *m_Port;
	
	/** 
	  * Beinhaltet den Pfad zum seriellen ezv24 Device. 
	  */
	QString m_Device;
	
	/** 
	  * Beinhaltet die Bluetooth Adresse des Telephons. 
	  */
	QString m_BtAddress;
	
	/** 
	  * Beinhaltet den Bluetooth Channnel des Telephons. 
	  */
	QString m_BtChannel;
	
	/** 
	  * Beinhaltet den Bluetooth Channnel des Telephons als Inteter. 
	  */
	int m_BtChannelInt;
	
	/** 
	  * Soll beim Programmstart automatisch connected werden? 
	  * Wird vom Konstruktor ausgewertet. 
	  */
	QString m_ConnectStartup;

	/** 
	  * Beinhaltet die Antwort des Telephons. 
	  */
	QStringList m_phoneAnswer;
	
	/** 
	  * Beinhaltet Angaben zum Telephon.
	  */
	QString m_phoneManufacturer, m_phoneModel, m_phoneBattery, m_phoneRevision, m_phoneStatus;
	
	/** 
	  * Beinhaltet Pfadangaben zum verwenden Device.
	  */
	QString m_defaultBtDevice, m_defaultIrdaDevice, m_defaultSerialDevice;
	
	/** 
	  * Beinhaltet Angaben zur Verbindung. 
	  * Werden im Configfile gespeichert.
	  */
	QString m_settingsAll, m_settingsDevice, m_settingsBtAddress, m_settingsConnectStartup;
	
	/** 
	  * Beinhaltet den Bluetooth Channnel des Telephons als Inteter. Hilfsvariable.
	  */
	int m_settingsBtChannel;
	
	/** 
	  * Beinhaltet Werte des Telephonbuchs. 
	  */
	QString m_phoneContactEntry, m_phoneContactId, m_phoneContactType, m_phoneContactName, m_phoneContactNumber, m_phoneContactCount;
	
	/** 
	  * Beinhaltet Werte eines SMS. 
	  */
	QString m_phoneSmsEntry, m_phoneSmsId, m_phoneSmsStatus, m_phoneSmsDateTmp, m_phoneSmsDate, m_phoneSmsNumber, m_phoneSmsMessage, m_phoneSmsToShow;

	/** 
	  * Beinhaltet die PDU Daten (GSM 7-Bit Hex) eines SMS als QString. 
	  * Ein PDU Block sieht z.B. folgendermassen aus:                      
	  * 079194712272303325000C9194711232547600000BD4F29C4E2FE3E9BA4D19
	  * Siehe auch den Kommentar zu BlueConvert::extractPduData
	  */
	QString m_PDU;
	
	/** 
	  * Beinhaltet die Laenge einer PDU. 
	  */
	QString m_PduLength;
	
	/** 
	  * Beinhaltet Werte eines neuen SMS.
	  * Der index wird fuer ueberlange SMS benoetigt, die ID ist eine random Zahl.
	  */
	int m_index, m_id;
	
	/** 
	  * Beinhaltet das AT Kommando fuer das Telephon. 
	  */
	QString m_AtCommand;
	
	/** 
	  * Beinhaltet den Pfad zu dem zu speichernden rsp. zu ladenden File. 
	  */
	QString m_FileName;

	/** 
	  * Beinhaltet den Pfad zu dem File, das auf das Telephon hochgeladen werden soll.
	  */
	QString m_UploadFileName, m_UploadFilePath;

};


#endif

