/*!
	@class		BlueObex
	@brief		Stellt OpenOBEX zur Verfuegung. Diese "Klasse" ist aus einer OpenOBEX Demo App entstanden.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-08
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		blueobex.h
*/


#ifndef BLUEOBEX_H
#define BLUEOBEX_H


/**
  * Ich benutze die OpenOBEX C Api. 
  * Damit der Linker die Funktionen unterscheiden kann rsp. damit der cpp Compiler
  * diese nicht irgendwie benennt und so den Linker aus dem Tritt bringt, hier ein extern "C"
  */
extern "C"
{
  #include <openobex/obex.h>
}


/**
  * Dieses enum teilt Obex mit, ueber welche Schnittstelle (rsp. Protokoll) kommuniziert wird.
  */
enum session_transport
{
	TRANS_NONE,
	TRANS_TCP,
	TRANS_IRDA,
	TRANS_SERIAL
};


/**
  * Dieses enum teilt Obex mit, was getan werden soll (nichts, empfangen oder senden).
  */
enum session_operation
{
	OPERATION_NONE,
	OPERATION_BACKUP,
	OPERATION_SEND
};


/**
  * Dieses enum teilt Obex mit, was empfangen oder gesendet werden soll.
  */
enum session_target
{
	TARGET_NONE,
	TARGET_PHONEBOOK,
	TARGET_CAL,
	TARGET_ALL
};


/**
  * Enthaelt alle Daten zu einer Obex Session.
  * Dieses Struktur und die folgenden Funktionen sind aus einer OpenOBEX Demo Applikation entstanden.
  * Sie findet sich, in aehnlicher Form, in vielen Applikationen, die OpenOBEX verwenden.
  * Ich muss gestehen, dass meine C (ohne ++) Kenntnisse nicht ausreichen, um wirklich 
  * alles dieser API zu verstehen.
  * Zu OpenOBEX existiert leider keine (gute) Dokumentation, wie z.B. zu QT oder ezV24
  */
struct BlueObex
{
	int connected;
	bool client_done;
	enum session_transport transport;
	enum session_operation operation;
	enum session_target target;
	const char *filename;
};



/**
  * Initialisiert Obex mit allen benoetigen Parametern.
  */
obex_t* obexInit(struct BlueObex *myObex, int method, const char *address, int channel);


/**
  * Stellt eine Obex Verbindung zur Gegenstelle her.
  */
int obexConnect(obex_t *handle);


/**
  * Behandelt ein Obex Ereigniss.
  */
void obexEvent(obex_t *handle, obex_object_t *object, int mode, int event, int obex_cmd, int obex_rsp);


/**
  * Liest eine Datei in einen Buffer ein und stellt sie somit Obex zur Verfuegung, dass sie gesendet werden kann.
  */
char* obexPutReadFile(const char *filename, int *length);


/**
  * Sendet der Gegenstelle eine Datei.
  */
int obexPutfile(obex_t *handle, struct BlueObex *s, const char *name);


/**
  * Behandelt das Warten auf die Bestaetigung der Gegenstelle.
  */
void syncwait(obex_t *handle);


/**
  * Beendet ein Obex Ereigniss.
  */
void obexEventDone(obex_t *handle, obex_object_t *object, int obex_cmd, int obex_rsp);


/**
  * Trennt eine Obex Verbindung.
  */
int obexDisconnect(obex_t *handle);



#endif


