/*!
	@class		BlueLink
	@brief		Stellt die Verbindung zum Telephon bereit.
	@author 	Thomas Gemperli, <bluephone@gemperli.net>
	@version	1.0
	@date		2004-08-03
	@par		This program is free software; you can redistribute it and/or 
				modify it under the terms of the GNU General Public License.
	@file		bluelink.h
*/


#ifndef BLUELINK_H
#define BLUELINK_H


/**
  * Ich benutze die ezV24 Bibliothek. 
  * Das Ziel dieser Bibliothek ist die Bereitstellung eines einfachen Interfaces zur seriellen Schnittstelle unter Linux.
  * Dieses Ziel haben die Entwickler erreicht. Bleibt zu hoffen, dass diese Lib bald zum Standard Umfang jeder Distri gehoeren wird.
  */
#include <ezV24/ezV24.h>


#include <qstring.h>
#include <qstringlist.h>



/**
  * Diese Klasse stellt die serielle Verbindung zum Telephon bereit.
  * Als Traeger werden Bluetooth, IrDA und serielle Kabel unterstuetzt.
  */
class BlueLink 
{


public:
	/**
     * Erstellt ein BlueLink Objekt.
     */
	BlueLink();
	
	/**
     * BlueLink Destruktor
     */
    ~BlueLink();
	
	/** 
	  * Diese Methode verbindet das rfcomm Device mit dem entfernten Bluetooth Device (dem Telephon). 
 	  * Parameter: const QString& comDevice, btAddr
 	  */
	int connectRfcomm(const QString&, const QString&);
	
	/** 
 	  * Diese Methode trennt die rfcomm Verbindung mit dem Telephon. 
 	  * Parameter: const QString& comDevice
 	  */
	int disconnectRfcomm(const QString&);
	
	/**
	  * Diese Methode erstellt die Verbindung zum Telephon.
	  * Parameter: QString mit dem zu verwendenden Device, diese sind unter Linux normalerweise:
	  * /dev/rfcomm0 fuer Bluetooth, /dev/ircomm0 fuer IrDA oder /dev/ttyS0 fuer ein serielles Kabel
	  */
	void connecttoPhone(const QString&);
	
	/** 
	  * Diese Methode liefet einen Pointer auf einen v24_port_t zurueck.
	  * Siehe http://ezv24.sourceforge.net/api-html fuer weitere Informationen.
	  */
	v24_port_t* getPort();
	
	/** 
	  * Diese Methode liefert den Status des Links zum Telephon zurueck.  
	  * Rueckgabewert: bool Status
	  */
	bool getState();
	
	/**
     * Diese Methode trennt die Verbindung zum Telephon.
     */
	void disconnectPhone();
	
	/**
     * Diese Methode tauscht Informationen mit dem Telephon aus.
     * Parameter: v24_port_t* v24_port, QString Befehl .
     * Rueckgabewert: QStringList mit allen Antworten des Telephons.
     */
	QStringList talktoPhone(v24_port_t*, const QString&);
	
		
private:
	/** 
	  * Status Variable, sind wir am kommunizieren oder nicht? 
	  */
	bool m_communicate;
	
	/** 
	  * Status Variable, sind wir mit dem Telephon verbunden oder nicht? 
	  */
	bool m_connected;
		
	/** 
	  * Zeiger auf ezv24 Objekt "Port". 
	  * Siehe http://ezv24.sourceforge.net/api-html fuer weitere Informationen.
	  */
	v24_port_t *m_port;
	
	/** 
	  * Beinhaltet die Antwort des Telephons. 
	  */
	QStringList m_phoneAnswer;
		
	/** 
	  * Beinhaltet den "New SMS Benachrichtigungs Modus" des Telephons.
	  */	
	QString m_phoneMode;

	/** 
	  * Beinhaltet die rfcomm Verbindungsparameter.
	  */	
	QString m_rfcommCommand;

};

#endif

