#include "textresourceimpl.h"

#include <windows.h>
#include <malloc.h>

///////////////////////////////////////////////////////////

TextResource::TextResource(const std::string& string,
                           unsigned short resourceId)
{
    HRSRC resource = FindResource(0, 
                                 (LPSTR)((ULONG_PTR)((WORD)(resourceId))),
                                 string.c_str());

    if(resource)
    {
        DWORD size = SizeofResource(0, resource);

        HGLOBAL resmem = LoadResource(0, resource);
        if(resmem)
        {
            void* data = LockResource(resmem);
            char* text = (char*)_alloca(size+1);
            text[size] = 0;
            memcpy(text, data, size);

            _string = (const char*)text;
        }
    }

}

///////////////////////////////////////////////////////////

TextResource::~TextResource(void)
{
}

///////////////////////////////////////////////////////////

const std::string& TextResource::str() const
{
    return _string;
}

///////////////////////////////////////////////////////////

