#ifndef KREISTEXT_H // der sogenannte Include-Blocker
#define KREISTEXT_H

#include "Kreis.h"
#include "Text.h"
#include "ZeichenFlaeche.h"
#include <string>


struct Koordinaten
{
	long x;
	long y;
};


class KreisText
{
	public:
		// Zwei Konstruktoren mit Parametern
		// Der erste nimmt zwei longs als Koordinaten
		KreisText(long x, long y, long kreisRadius);
		// Dieser zweite Konstruktor nimmt als Parameter
		// eine Koordinaten-Struktur
		KreisText(Koordinaten koordinaten, long kreisRadius);

		// hier zwei Funktionen zum setzen der Koordinaten
		// auch wieder einmal mit longs, die andere mit
		// einer Koordinaten-Struktur
		void setzeKoordinaten(long x, long y);
		void setzeKoordinaten(Koordinaten koordinaten);

		void setzeKreisFarbe(unsigned char rot,
							 unsigned char gruen,
							 unsigned char blau);

		void setzeKreisRadius(long radius);

		void setzeText(const std::string& text);

		// Hier noch die Hilfsfunktion um die
		// Elemente auf die Zeichenflaeche zu bringen
		void aufZeichenFlaeche(ZeichenFlaeche& zeichenFlaeche);
	
	private:
		Kreis		m_Kreis;
		Text		m_Text;
		COLORREF	m_Farbe;
		Koordinaten m_Koordinaten;
};


#endif