#include "KreisText.h"

////////////////////////////////////////////////////////////////

const COLORREF Schwarz = RGB(0,0,0);
const COLORREF Weiss = RGB(255,255,255);

////////////////////////////////////////////////////////////////

// Der Konstruktor muss eine Initialisierungsliste
// verwenden, denn die Elemente haben auch Konstruktoren
// mit Parametern
KreisText::KreisText(long x, long y, long kreisRadius)
          :m_Text(x,y), m_Kreis(x, y, kreisRadius)
{
}

////////////////////////////////////////////////////////////////

KreisText::KreisText(Koordinaten koordinaten, long kreisRadius)
          :m_Text(koordinaten.x, koordinaten.y), 
		   m_Kreis(koordinaten.x, koordinaten.y, kreisRadius)
{
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKoordinaten(long x, long y)
{
	m_Kreis.setzeKoordinaten(x, y);
	m_Text.setzeKoordinaten(x, y);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKoordinaten(Koordinaten koordinaten)
{
	m_Kreis.setzeKoordinaten(koordinaten.x, koordinaten.y);
	m_Text.setzeKoordinaten(koordinaten.x, koordinaten.y);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKreisFarbe(unsigned char rot,
							    unsigned char gruen,
							    unsigned char blau)
{
	// Hier mssen wir entscheiden ob wir
	// den Text schwarz oder weiss machen
	COLORREF textFarbe = Weiss;

	if(blau+rot+gruen > 400)
	{
		textFarbe = Schwarz;
	}

	if(gruen > blau+rot+150)
	{
		textFarbe = Schwarz;
	}

	m_Kreis.setzeFarbe(RGB(rot, gruen, blau));
	m_Text.setzeFarbe(textFarbe);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeKreisRadius(long radius)
{
	m_Kreis.setzeRadius(radius);
}

////////////////////////////////////////////////////////////////

void KreisText::setzeText(const string& text)
{
	m_Text.setzeText(text);
}

////////////////////////////////////////////////////////////////

void KreisText::aufZeichenFlaeche(ZeichenFlaeche& zeichenFlaeche)
{
	zeichenFlaeche.kreisHinzufuegen(m_Kreis);
	zeichenFlaeche.textHinzufuegen(m_Text);
}

////////////////////////////////////////////////////////////////



