#ifndef ZAHL_H
#define ZAHL_H

#include <sstream>
#include <string>

enum Basis
{
    Binaer = 2,
    Octal = 8,
    Decimal = 10,
    Hexadecimal = 16
};

class Zahl
{
    public:
        Zahl(const char* string, Basis basis);
        Zahl(double d);
        Zahl(long l);

        double ToDouble();
        long   ToLong();
        const char* ToString();
        const char* ToString(Basis basis);

        Zahl& operator=(double d);
        Zahl& operator=(long l);
        Zahl& operator=(const Zahl& z);

        const char* TransformTo(Basis basis);
    
    private:
        Basis             m_basis;
        std::string       m_string;
};


#endif