#include "Medienshop.h"
#include <iostream>
#include <fstream>
#include "Menu.h"




int main()
{
    const char* Menupunkte [] =
    {
        "Medien anzeigen",
        "Cd definieren",
        "Buch definieren",
        "Medium definieren",
        "Medien speichern",
        "Medien laden",
        "Medien loeschen",
        "Als Html speichern",
    };

    // Wir erzeugen unseren
    // Medienshop
    Medienshop shop("mein kleiner Shop");
    
    // Menu definieren
    const long anzahlMenupunkte = sizeof(Menupunkte) / sizeof(Menupunkte[0]);
    Menu hauptMenu;
    for(long menuIndex = 0; menuIndex < anzahlMenupunkte; ++menuIndex)
    {
        hauptMenu.addMenuEntry(Menupunkte[menuIndex]);
    }

    menuIndex = 0;
    while(menuIndex != 99)
    {
        hauptMenu.show();
        menuIndex = hauptMenu.getUserInput();
        switch(menuIndex)
        {
            case 0:
                shop.anzeigen();
                break;
            case 1:
                shop.cdDefinieren();
                break;
            case 2:
                shop.buchDefinieren();
                break;
            case 3:
                shop.mediumDefinieren();
                break;
            case 4:
                {
                    std::string dateiname;
                    std::cout << "Dateiname : ";
                    std::getline(std::cin, dateiname, '\n');
                    if(!dateiname.empty())
                    {
                        std::ofstream out(dateiname.c_str());
                        if(out.is_open())
                        {
                            shop.speichern(out);
                        }
                    }
                }
                break;
            case 5:
                {
                    std::string dateiname;
                    std::cout << "Dateiname : ";
                    std::getline(std::cin, dateiname, '\n');
                    if(!dateiname.empty())
                    {
                        std::ifstream in(dateiname.c_str());
                        if(in.is_open())
                        {
                            shop.laden(in);
                        }
                    }
                }
                break;
            case 6:
                shop.alleLoeschen();
                break;
            case 7:
                shop.speichernAlsHtml();
                break;
            default:
                break;
        }
    }
    
    return 0;
}