#ifndef MEDIUM_H
#define MEDIUM_H

#include <string>
#include <iostream>
#include <fstream> 
#include "HtmlDocument.h"

const char Trennzeichen = ';';

// unsere Basisklasse
// fr die verschiedenen Medien
class Medium
{
public:
    // Ein Konstruktor mit
    // Parametern ist recht ntzlich
    Medium(const std::string& titel,
           double preis);

    // Es braucht einen Default
    // Konstruktor
    Medium();

    // Da wir erwarten, dass von
    // dieser Klasse abgeleitet wird
    // sollten wir den Destruktor
    // virtuell machen.
    virtual ~Medium();

    // geeignet um die Daten
    // auf der Konsole auszugeben.
    // Diese Methode ist nicht virtuell
    // und sollte nicht berschrieben
    // werden. Stattdessen sollten
    // abgeleitete Klasse die Methode
    // zusatzAusgabe berschreiben!
    void bildschirmAusgabe()
    {
        medienTypAusgabe();
        medienAusgabe();
        zusatzAusgabe();
        neueLinie();
    }

    // Diese Methode speichert
    // zuerst die Daten der Klasse
    // Medium und ruft danach
    // die virtuelle Methode zusatzspeichern
    // auf, die in einer abgeleiteten
    // Klasse berschrieben werden kann
    // um zustzliche Daten zu speichern
    void speichern(std::ofstream& out)
    {
        medienTypSpeichern(out);
        mediumSpeichern(out);
        zusatzSpeichern(out);
        neueLinieSpeichern(out);
    }

    // geeignet um die Daten
    // aus einer datei auszulesen.
    // berschreibe in einer
    // abgeleiteten Klasse die
    // Methode zusatzLaden
    // um weitere Daten auszulesen
    void laden(std::ifstream& in)
    {
        mediumLaden(in);
        zusatzLaden(in);
        neueLinieLaden(in);
    }

    // Diese Methode fragt den Benutzer
    // nach den Angaben zum Medium.
    // Sie ruft auch definiereZusaetzlicheDaten
    // auf, die in den abgeleiteten Klassen
    // berschrieben wird.
    void definieren()
    {
        definiereMedium();
        definiereZusaetzlicheDaten();
    }

    void speichernAlsHtml(HtmlTag& tag)
    {
        mediumTypAlsHtml(tag);
        mediumAlsHtml(tag);
        zusatzAlsHtml(tag);
    }

    // Diese statische! Methode liest aus
    // einer Datei den Medientyp aus und
    // erzeugt dann daraus das richtige Medium
    static Medium* ausDateiErzeugen(std::ifstream& in);

private:
    // abgeleitete Klassen
    // sollten diese Methode
    // berschreiben um zustzliche
    // Daten auf der Console
    // auszugeben
    virtual void zusatzAusgabe() 
    {
        // macht nichts
    }
    // abgeleitete Klassen
    // sollten diese Methode
    // berschreiben um zustzliche
    // Daten aus der Datei zu lesen
    virtual void zusatzLaden(std::ifstream& in)
    {
        // macht nichts
    }
    // berschreibe diese Methode
    // in der abgeleiteten Klasse
    // um zustzliche Daten vom
    // Benutzer definieren zu lassen
    virtual void definiereZusaetzlicheDaten()
    {
        // macht nichts
    }

    // jede abgeleitete Klasse muss
    // den richtigen Medientyp in die
    // Datei schreiben, damit das
    // richtige Medium erzeugt wird.
    virtual void medienTypSpeichern(std::ofstream& out)
    {
        out << "Medium" << Trennzeichen;
    }
    virtual void medienTypAusgabe()
    {
        std::cout << "Medium" << "\t";
    }
    virtual void mediumTypAlsHtml(HtmlTag& tag)
    {
        HtmlTag zelle("td");
        zelle << "Medium";
        tag << zelle;
    }
    // berschreiben diese Methode
    // in einer abgeleiteten Klasse
    // um zustzliche Daten in eine
    // Datei zu speichern.
    virtual void zusatzSpeichern(std::ofstream& out)
    {
        // macht nichts
    }

    virtual void zusatzAlsHtml(HtmlTag& tag)
    {
        // macht nichts
    }

private:
    // Console
    void medienAusgabe();
    void neueLinie();
    // Speichern
    void mediumSpeichern(std::ofstream& out);
    void neueLinieSpeichern(std::ofstream& out);
    // Laden
    void mediumLaden(std::ifstream& in);
    void neueLinieLaden(std::ifstream& in);
    // Definieren
    void definiereMedium();

    void mediumAlsHtml(HtmlTag& tag);

private:
    double      _preis;
    std::string _titel;
    std::string _bild;
};


#endif