#ifndef MEDIENSHOP_H
#define MEDIENSHOP_H

#include <string>
#include <vector>
#include <fstream>
#include "Medium.h"

typedef std::vector<Medium*> Medien;

// Ich denke, wenn wir einen
// Medienshop "abstrahieren"
// sollte es eine Klasse Medienshop
// geben.
class Medienshop
{
public:
    Medienshop(const std::string& shopName);
    // wir brauchen einen Destruktor
    // denn wir werden die Medien
    // mit new und delete erzeugen
    // und zerstren
    ~Medienshop();
    // Um ein neues Medium zu erzeugen
    // und zu definieren
    void mediumDefinieren();
    void cdDefinieren();
    void buchDefinieren();
    // Um alle Medien zu speichern
    void speichern(std::ofstream& out);

    void speichernAlsHtml();

    void laden(std::ifstream& in);

    void alleLoeschen();

    void anzeigen();

private:
    std::string _shopName;
    Medien      _medien;
};


#endif