#ifndef SUBJECTIMPL_H
#define SUBJECTIMPL_H

#pragma warning (disable : 4786)

#include "Subject.h"
#include <set>

typedef std::set<Observer*> Observers;

class SubjectImpl : public Subject
{
public:
    SubjectImpl();
    virtual ~SubjectImpl();

    // interface Subject
    virtual void subscribe(Observer* observer);
    virtual void unsubscribe(Observer* observer);

    virtual const Data& getData() const;
    virtual void setData(const Data& newData);

private:
    Data _data;
    Observers _observers; 
};

#endif