#include "SubjectImpl.h"
#include "Observer.h"
#include <iostream>

SubjectImpl::SubjectImpl()
            :_data(0)
{
    std::cout << "A Subject has been created" << std::endl;
}

SubjectImpl::~SubjectImpl()
{
    std::cout << "A Subject has been destroyed" << std::endl;
}

void SubjectImpl::subscribe(Observer* observer)
{
    _observers.insert(observer);
}

void SubjectImpl::unsubscribe(Observer* observer)
{
    _observers.erase(observer);
}

const Data& SubjectImpl::getData() const
{
    return _data;
}

void SubjectImpl::setData(const Data& newData)
{
    _data = newData;
    Observers::iterator it = _observers.begin();
    Observers::iterator end = _observers.end();

    for( ; it != end; ++it)
    {
        Observer* pO = *it;
        // wir geben mit, dass wir uns
        // ndern
        pO->update(this);
    }
}
