#ifndef SUBJECT_H
#define SUBJECT_H

class Observer;

typedef int Data;

class Subject
{
public:
    virtual ~Subject() {}

    virtual void subscribe(Observer* observer) = 0;
    virtual void unsubscribe(Observer* observer) = 0;

    virtual const Data& getData() const = 0;
    virtual void setData(const Data& newData) = 0;
};

#endif