#include "Medium.h"
#include <iomanip>
#include <sstream>
#include "Cd.h"
#include "Buch.h"

/////////////////////////////////////////////////

Medium::Medium(const std::string& titel,
               double preis)
               :_titel(titel),
                _preis(preis)
{
}

/////////////////////////////////////////////////

Medium::Medium()
{
}

/////////////////////////////////////////////////

Medium::~Medium()
{
}

/////////////////////////////////////////////////

void Medium::medienAusgabe()
{
    std::cout << _titel << "\t";
    std::cout << _preis << "\t";
    std::cout << _bild << "\t";
}

/////////////////////////////////////////////////

void Medium::neueLinie()
{
    std::cout << std::endl;
}

/////////////////////////////////////////////////

void Medium::mediumSpeichern(std::ofstream& out)
{
    out << _titel << Trennzeichen;
    out << _preis << Trennzeichen;
    out << _bild  << Trennzeichen;
}

/////////////////////////////////////////////////

void Medium::neueLinieSpeichern(std::ofstream& out)
{
    out << std::endl;
}

/////////////////////////////////////////////////

void Medium::mediumLaden(std::ifstream& in)
{
    std::getline(in, _titel, Trennzeichen);
    // Preis ist ein wenig aufwendiger
    std::string preisAngabe;
    std::getline(in, preisAngabe, Trennzeichen);
    std::stringstream stream(preisAngabe);
    stream >> _preis;

    std::getline(in, _bild, Trennzeichen);
}

/////////////////////////////////////////////////

void Medium::neueLinieLaden(std::ifstream& in)
{
    std::string neueLinie;
    std::getline(in, neueLinie, '\n');
}

/////////////////////////////////////////////////

void Medium::definiereMedium()
{
    char buffer[50];
    std::cout << "Titel     : ";
    std::cin.getline(buffer, 50);
    _titel = buffer;
    _preis = -1.0;
    while(-1.0 == _preis)
    {
        std::cout << "Preis     : ";
        std::cin.getline(buffer, 50);
        std::string eingabe = buffer;
        std::stringstream stream(eingabe);
        stream >> _preis;
    }
    std::cout << "Bilddatei : ";
    std::cin.getline(buffer, 50);
    _bild = buffer;
}

/////////////////////////////////////////////////

void Medium::mediumAlsHtml(HtmlTag& tag)
{
    HtmlTag bild("td");
    HtmlTag bildLink("img");
    std::string bildString = "src=\"" + _bild + "\"";
    HtmlAttribute bildAttribut(bildString);
    bildLink << bildAttribut;
    bild << bildLink;
    tag << bild;
    HtmlTag titel("td");
    titel << _titel;
    tag << titel;
    HtmlTag preis("td");
    preis << _preis;
    tag << preis;
}

/////////////////////////////////////////////////

Medium* Medium::ausDateiErzeugen(std::ifstream& in)
{
    Medium* neuesMedium = 0;

    std::string medienTyp;
    std::getline(in, medienTyp, Trennzeichen);
    if(medienTyp == "Medium")
    {
        neuesMedium = new Medium;    
    }
    else if(medienTyp == "Cd")
    {
        neuesMedium = new Cd;
    }
    else if(medienTyp == "Buch")
    {
        neuesMedium = new Buch;
    }

    return neuesMedium;
}

/////////////////////////////////////////////////
