#include "Medienshop.h"
#include "Cd.h"
#include "Buch.h"


/////////////////////////////////////////////////

Medienshop::Medienshop(const std::string& shopName)
           :_shopName(shopName)
{
}

/////////////////////////////////////////////////

Medienshop::~Medienshop()
{
    alleLoeschen();
}

/////////////////////////////////////////////////

void Medienshop::mediumDefinieren()
{
    Medium* medium = new Medium;
    medium->definieren();
    _medien.push_back(medium);
    std::string titel = medium->holeTitel();
    _katalog[titel] = medium;
}

/////////////////////////////////////////////////

void Medienshop::cdDefinieren()
{
    Medium* medium = new Cd;
    medium->definieren();
    _medien.push_back(medium);
    std::string titel = medium->holeTitel();
    _katalog[titel] = medium;
}

/////////////////////////////////////////////////

void Medienshop::buchDefinieren()
{
    Medium* medium = new Buch;
    medium->definieren();
    _medien.push_back(medium);
    std::string titel = medium->holeTitel();
    _katalog[titel] = medium;
}

/////////////////////////////////////////////////

void Medienshop::alleLoeschen()
{
    // zuerst werden die
    // Medienobjekte ber
    // die Zeiger gelscht
    Medien::iterator it = _medien.begin();
    Medien::iterator end = _medien.end();

    for( ; it != end; ++it)
    {
        Medium* medium = *it;
        delete medium;
    }
    // Jetzt mssen wir noch
    // alle Zeiger aus der
    // Kollektion entfernen
    _medien.clear();
}

/////////////////////////////////////////////////

void Medienshop::speichern(std::ofstream& out)
{
    Medien::iterator it = _medien.begin();
    Medien::iterator end = _medien.end();

    for( ; it != end; ++it)
    {
        Medium* medium = *it;
        medium->speichern(out);
    }
}

/////////////////////////////////////////////////

void Medienshop::laden(std::ifstream& in)
{
    while(!in.eof())
    {
        Medium* medium = Medium::ausDateiErzeugen(in);
        if(medium != 0)
        {
            medium->laden(in);
            _medien.push_back(medium);
            std::string titel = medium->holeTitel();
            _katalog[titel] = medium;
        }
    }
}

/////////////////////////////////////////////////

void Medienshop::anzeigen()
{
    std::cout << " --- Medienshop" << std::endl;
    std::cout << " --- " << _shopName << std::endl;

    Medien::iterator it = _medien.begin();
    Medien::iterator end = _medien.end();

    for( ; it != end; ++it)
    {
        Medium* medium = *it;
        medium->bildschirmAusgabe();
    }
}

/////////////////////////////////////////////////

void Medienshop::speichernAlsHtml()
{
    HtmlDocument html(_shopName + ".html", _shopName);
    HtmlTag titel("H1");
    titel << "Medienshop";
    html << titel;
    HtmlTag unterTitel("H2");
    unterTitel << _shopName;
    html << unterTitel;

    HtmlTag table("table");
    HtmlTag titleRow("tr");
    HtmlTag titleCell1("td");
    HtmlTag titleCell2("td");
    HtmlTag titleCell3("td");
    HtmlTag titleCell4("td");
    HtmlTag titleCell5("td");
    HtmlAttribute tableAttribute("border = \"2\"");
    titleCell1 << "Medientyp";
    titleRow << titleCell1;
    titleCell2 << "Bild";
    titleRow << titleCell2;
    titleCell3 << "Titel";
    titleRow << titleCell3;
    titleCell4 << "Preis";
    titleRow << titleCell4;
    titleCell5 << "Weitere Infos";
    titleRow << titleCell5;
    table << tableAttribute;
    table << titleRow;

    Medien::iterator it = _medien.begin();
    Medien::iterator end = _medien.end();

    for( ; it != end; ++it)
    {
        HtmlTag row("tr");
        Medium* medium = *it;
        medium->speichernAlsHtml(row);
        table << row;
    }

    html << table;
    html.save();
}

/////////////////////////////////////////////////

Medium* Medienshop::suchen(const std::string& suchString)
{
    Medium* ergebnis = 0;
    MedienKatalog::iterator gefunden = _katalog.find(suchString);
    if(gefunden != _katalog.end())
    {
        ergebnis = gefunden->second;
    }
    return ergebnis;
}

/////////////////////////////////////////////////

void Medienshop::verbrennen()
{
}