#ifndef ZAHL_H
#define ZAHL_H

#include <sstream>
#include <string>

enum Basis
{
    Binaer = 2,
    Octal = 8,
    Decimal = 10,
    Hexadecimal = 16
};

class Zahl
{
    public:
        // Construction
        Zahl(const std::string& text, Basis basis); 
        Zahl(double d);
        Zahl(long l);
        // Copy Construction
        Zahl(const Zahl& z);

        // Extraction
        double ToDouble() const;
        long   ToLong() const;
        std::string ToString(Basis basis) const;
        std::string ToString() const;

        operator double() const
        {
            return ToDouble();
        }

        // Assignment
        Zahl& operator=(double d);
        Zahl& operator=(long l);
        Zahl& operator=(const Zahl& z);

    
    private:
        Basis             m_basis;
        std::string       m_string;
};


#endif