#include <bitset>
#include "Zahl.h"
#include <iomanip>

///////////////////////////////////////////////////////////

Zahl::Zahl(const std::string& text, Basis basis)
     :m_basis(basis), m_string(text)
{
}

///////////////////////////////////////////////////////////

Zahl::Zahl(double d)
     :m_basis(Decimal)
{
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit); 
    // exceptions einschalten falls etwas schiefgeht
    stream << std::setprecision(16); // damit nichts verloren
                                     // geht
    stream << d;
    stream >> m_string;
}

///////////////////////////////////////////////////////////

Zahl::Zahl(long l)
     :m_basis(Decimal)
{
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit); 
    // exceptions einschalten falls etwas schiefgeht
    stream << l;
    stream >> m_string;
}

///////////////////////////////////////////////////////////

Zahl::Zahl(const Zahl& z)
{
    m_basis = z.m_basis;
    m_string = z.m_string;
}

///////////////////////////////////////////////////////////

Zahl& Zahl::operator =(const Zahl& z)
{
    m_string = z.m_string;
    m_basis = z.m_basis;

    return *this;
}

///////////////////////////////////////////////////////////

Zahl& Zahl::operator =(long l)
{
    m_basis = Decimal;
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit); 
    // exceptions einschalten falls etwas schiefgeht
    stream << l;
    stream >> m_string;

    return *this;
}

///////////////////////////////////////////////////////////

Zahl& Zahl::operator =(double d)
{
    m_basis = Decimal;
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit); 
    // exceptions einschalten falls etwas schiefgeht
    stream << d;
    stream >> m_string;

    return *this;
}

///////////////////////////////////////////////////////////

long Zahl::ToLong() const
{
    std::stringstream stream;
    // exceptions einschalten falls etwas schiefgeht
    stream.exceptions(std::ios_base::failbit);
    // die Basis einstellen, bevor wir
    // den string einfgen
    stream << std::setbase(m_basis);
    stream << m_string;
    long result;
    stream >> result;

    return result;
}

///////////////////////////////////////////////////////////

double Zahl::ToDouble() const
{
    std::stringstream stream;
    // exceptions einschalten falls etwas schiefgeht
    stream.exceptions(std::ios_base::failbit); 
    // die Basis einstellen, bevor wir
    // den string einfgen
    stream << std::setbase(m_basis);
    // mglichst beim double keine Stellen 
    // abschneiden darum setprecision
    stream << std::setprecision(16);
    stream << m_string;

    double d;
 
    if(Decimal == m_basis)
    {
        stream >> d;
    }
    else
    {
        int t;
        stream >> t;
        d = t;
    }

    return d;
}

///////////////////////////////////////////////////////////

std::string Zahl::ToString() const
{
    return m_string;
}

///////////////////////////////////////////////////////////

std::string Zahl::ToString(Basis basis) const
{
    std::stringstream stream;
    stream.exceptions(std::ios_base::failbit); 
    // exceptions einschalten falls etwas schiefgeht
    std::string copy(m_string); // Kopie erstellen, damit
                                // unser Original-String
                                // nicht verndert wird

    // am besten holen wir uns einfach
    // einen double, mit lsst es sich
    // am besten weiterarbeiten
    double d = ToDouble();

    if(Decimal == basis)
    {
        stream << std::setbase(Decimal);
        stream << d;
        
        copy = stream.str();
    }
    else if(Binaer == basis)
    {
        // hier die nette kleine
        // Klasse bitset, die aus einer
        // Ganzzahl ein binaeres Muster
        // als String erzeugen kann
        int t = (int)d;
        std::bitset<32> bits(t);

        // leider ist diese Zeile kaum zu verstehen...
        copy = bits.to_string<char, std::char_traits<char>, std::allocator<char> >();
    }
    else
    {
        // oktal oder hexadezimal wandeln
        // wir in eine Ganzzahl
        int t = (int)d;
        stream << std::setbase(basis);
        stream << t;

        copy = stream.str();
    }
    
    return copy;
}

///////////////////////////////////////////////////////////
