#ifndef MYSTRING_H
#define MYSTRING_H

#include "iostream"
using namespace std;

class MyString
{
    public:
        // Konstruktor
        MyString();
        // Destruktor
        ~MyString();

        // Kopierkonstruktor
        MyString(const MyString& c);

        MyString& operator=(const MyString& z);

        // Konstruktor mit
        // Parameter
        MyString(const char* text);

        // Zuweisungsoperator fr char*
        void operator=(const char* text);

        // externe Funktion zur Ausgabe
        // diese Klasse gehrt nicht
        // zur Klasse MyString, hat aber
        // dank friend Zugriff auf private
        // Datenelemente von MyString
        friend ostream& operator<<(ostream& out, MyString& s);

        // anhngen von Text
        void operator+(const char* text);
        void operator+(const MyString& a);

    private:
        // Zeiger auf dynamisch
        // allozierten Speicher
        char* m_pChars;

    private:
        // Kopierfunktion
        void Copy(const char* text);
        // Anhnge-Funktion
        void Append(const char* text);
};

#endif