#include "MyString.h"

// fr strlen und
// strcnpy
#include <string.h>

///////////////////////////////////////

MyString::MyString()
{
    // wichtig !!
    // Zeiger auf 0 initialisieren
    m_pChars = 0;
}

///////////////////////////////////////

MyString::~MyString()
{
    // Speicher wieder
    // freigeben !
    delete [] m_pChars;
}

///////////////////////////////////////

// Konstruktor mit Parametern
MyString::MyString(const char* text)
{
    // unsere Copy-Funktion
    // ist genau richtig
    Copy(text);
}

///////////////////////////////////////

// Kopierkonstruktor
MyString::MyString(const MyString& c)
{
    // Auch hier knnen
    // wir unsere Copy-Funk
    // verwenden. Wir mssen
    // einfach auf m_pChars
    // des Objektes c zugreifen
    Copy(c.m_pChars);
}

///////////////////////////////////////

// Zuweisungsoperator
MyString& MyString::operator=(const MyString& z)
{
    // Zuweisung an mich selbst ?
    // Also prfen ob this ungleich
    // der Adresse von z ist
    if(this != &z)
    {
        // zuerst alten Speicher
        // freigeben !
        delete [] m_pChars;

        // jetzt genau gleich
        // wie im Kopierkonstruktor
        Copy(z.m_pChars);
    }

    return *this;
}

///////////////////////////////////////

// Zuweisungsoperator fr char
void MyString::operator=(const char* text)
{
    // falls vorher bereits
    // Speicher alloziert wurde
    // zum Beispiel im Konstruktor
    // mit Parameter, diesen wieder
    // freigeben !
    delete [] m_pChars;

    // jetzt gleicher Code wie
    // oben im Konstruktor mit Parametern
    Copy(text);
}

///////////////////////////////////////

void MyString::operator+(const char* text)
{
    Append(text);
}

///////////////////////////////////////

void MyString::operator+(const MyString& a)
{
    Append(a.m_pChars);
}

///////////////////////////////////////

///////////////////////////////////////

// Anfgefunktion
void MyString::Append(const char* text)
{
    // Die Lnge ist die
    // Lnge des bereits
    // vorhandenen Textes
    // plus die Lnge des 
    // Textes vom Objekt a
    int laenge = strlen(m_pChars) + strlen(text);

    // Jetzt zuerst Speicher
    // fr kompletten Text
    char* Temp = new char[laenge+1];

    // jetzt zuerst eigenen
    // alten Text in neues
    // Array kopieren
    strcpy(Temp, m_pChars);

    // Jetzt den neuen Text
    // anfgen
    strcat(Temp, text);

    // alten Speicher erst
    // jetzt freigeben
    delete [] m_pChars;
    
    // m_pChars auf den neuen
    // zusammengesetzten String
    // zeigen lassen
    m_pChars = Temp;
}


///////////////////////////////////////

// Kopierfunktion
void MyString::Copy(const char* text)
{
    // Lnge des Textes
    // herausfinden
    int laenge = strlen(text);

    // gengend Speicher allozieren.
    // nicht vergessen  : 
    // das abschliessende 0 braucht
    // auch ein Byte, also +1
    m_pChars = new char[laenge+1];

    // Alle Zeichen vom Text
    // kopieren einschl. der
    // abschliessenden 0 
    strncpy(m_pChars, text, laenge+1);
}

///////////////////////////////////////
///////////////////////////////////////

ostream& operator<<(ostream& out, MyString& s)
{
    out << s.m_pChars;

    return out;
}

