
#include "CD.h"
#include "CDListe.h"
#include "Menu.h"

enum MainFunctions
{
    AddCd,
    ShowCds,
    SortCds,
    SearchCd
};

const char* MenuEntryStrings[] = 
{
    "CD Hinzufuegen",
    "CD's anzeigen",
    "CD's sortieren",
    "CD suchen"
};

// Function prototype
CD::Kriterium askKriterium();

int main()
{
    CDListe liste;

    Menu menu;

    long menuEntryCount = sizeof(MenuEntryStrings) / sizeof(MenuEntryStrings[0]);

    for(long i = 0; i < menuEntryCount; ++i)
    {
        menu.addMenuEntry(MenuEntryStrings[i]);
    }

    int userInput = 0;
    while(99 != userInput)
    {
        menu.show();
        userInput = menu.getUserInput();
        
        switch(userInput)
        {
        case AddCd:
            {
                CD aCD;
                aCD.einlesen();
                liste.hinzufuegen(aCD);
            }
            break;
        case ShowCds:
            liste.ausgeben();
            break;
        case SortCds:
            {
                CD::Kriterium krit = askKriterium();
                liste.sortieren(krit);
                liste.ausgeben();
            }
            break;
        default:
            liste.ausgeben();
            break;
        }
    }

    return 0;
}

struct Kriterien
{
    CD::Kriterium Kriterium;
    const char* Bezeichnung;
};

Kriterien KriterienMitBezeichnung[] =
{
    { CD::eId, "Nach der Id"},
    { CD::eInterpret, "Nach Interpret"},
    { CD::eLaenge, "Nach Laenge"},
    { CD::eTitel, "Nach Titel"}
};

CD::Kriterium askKriterium()
{
    CD::Kriterium nachWasSortieren = CD::eId;

    Menu menu;
    
    long kritCount = sizeof(KriterienMitBezeichnung) / 
                     sizeof(KriterienMitBezeichnung[0]);

    for(long i = 0; i < kritCount; ++i)
    {
        menu.addMenuEntry(KriterienMitBezeichnung[i].Bezeichnung);
    }
    menu.show();

    int userInput = menu.getUserInput();

    if(userInput < kritCount)
    {
        nachWasSortieren = KriterienMitBezeichnung[userInput].Kriterium;
    }

    return nachWasSortieren;
}
