#ifndef NOTE_H
#define NOTE_H

class Note
{
public:
    enum Round
    {
        Whole = 1,
        Half = 2,
        Fourth = 4,
        Tenth = 10
    };

    Note();
    Note(double initValue);

    double getValue() const
    {
        return _value;
    }

    // do not call with value less
    // than 1.0 or greater than 6.0
    // otherwise the method will assert
    void setValue(double value);

    void readFromConsole();
    void writeToConsole() const;
    void writeToConsole(Round how) const;

    double getRoundedValue(Round how) const;

private:
    double _value;
};


#endif