#include "Note.h"
#include <iostream>
#include <crtdbg.h>

using namespace std;

Note::Note()
        :_value(1.0)
{
}

Note::Note(double initValue)
        :_value(initValue)
{
}

void Note::readFromConsole()
{
    do
    {
        cout << "Note ? ";
        cin >> _value;
    }while(1.0 > _value || _value > 6.0);
}

void Note::setValue(double value)
{
    // do not use invalid marks
    _ASSERT(value >= 1.0 && value <= 6.0);

    _value = value;
}

void Note::writeToConsole(Round how) const
{
    double temp = getRoundedValue(how);
    cout << temp;
}

void Note::writeToConsole() const
{
    cout << _value;
}

double Note::getRoundedValue(Round how) const
{
    double round = (double)how;

    // Wer wird auf null runden wollen ?????
    _ASSERT(0 != round);

    double corr = 1.0 / round / 2.0; 
    double temp = _value + corr;
    temp = temp * round;
    temp = (int)temp;
    temp = temp / round;

    return temp;
}
