#include "SerialPort.h"
#include <string>
#include <sstream>

SerialPort::SerialPort()
:_handle(INVALID_HANDLE_VALUE)
{
}

SerialPort::~SerialPort()
{
    close();
}

void SerialPort::open(unsigned char portNumber)
{ 
    _handle = CreateFile("COM1",
               GENERIC_READ | GENERIC_WRITE,
               0,
               0,
               OPEN_EXISTING,
               FILE_ATTRIBUTE_NORMAL,
               0);
    if(INVALID_HANDLE_VALUE == _handle)
    {
        throw std::string("Konnte Port nicht ffnen");
    }
}

void SerialPort::close()
{
    if(INVALID_HANDLE_VALUE != _handle)
    {
        CloseHandle(_handle);
        _handle = INVALID_HANDLE_VALUE;
    }
}

void SerialPort::writeByte(unsigned char data)
{
    if(INVALID_HANDLE_VALUE == _handle)
    {
        throw std::string("Port nicht offen");
    }

    DWORD bytesWritten = 0;
    BOOL result = FALSE;

    result = WriteFile(_handle, 
                      &data,
                      1,
                      &bytesWritten,
                      0);
    if(FALSE == result)
    {
        DWORD error = GetLastError();
        std::stringstream stream;
        stream << "WriteFile misslungen mit";
        stream << " error Code : " << error;
        throw stream.str();
    }

}


