
#ifndef SERIALPORT_H
#define SERIALPORT_H

#include <windows.h>

#pragma warning (disable : 4786)

#include <map>
#include <set>
#include "CriticalSection.h"

class SerialPort;

typedef std::map<unsigned char, SerialPort*> SerialPorts;

class SerialPortObserver
{
public:
    virtual void newSerialData(const SerialPort& port,
                                             unsigned char data) = 0;
};

typedef std::set<SerialPortObserver*> Observers;

class SerialPort
{
    public:
        ~SerialPort();

        void addObserver(SerialPortObserver* observer);
        void removeObserver(SerialPortObserver* observer);

        static SerialPort& getSerialPort(unsigned char portNumber);

        unsigned char readByte();
        void writeByte(unsigned char data);

        friend SerialPorts;

        unsigned char getPortNumber() const;

    private:
        static DWORD WINAPI readThread(LPVOID param);
        void readAndDispatch();

        SerialPort();
        void open(unsigned char port);
        void close();

    private:
        HANDLE m_handle;
        HANDLE m_thread;
        unsigned char m_portNumber;
        Observers m_observers;
        CriticalSection m_cs;
};




#endif